/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml;

import com.google.common.collect.Lists;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.IGraphLayoutEngine;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.GraphFeature;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class RecursiveGraphLayoutEngine
implements IGraphLayoutEngine {
    @Override
    public void layout(KNode layoutGraph, IKielerProgressMonitor progressMonitor) {
        int nodeCount = this.countNodesRecursively(layoutGraph, true);
        progressMonitor.begin("Recursive Graph Layout", (float)nodeCount);
        this.layoutRecursively(layoutGraph, progressMonitor);
        progressMonitor.done();
    }

    private List<KEdge> layoutRecursively(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        boolean hasInsideSelfLoops;
        if (progressMonitor.isCanceled()) {
            return Collections.emptyList();
        }
        KShapeLayout layoutNodeShapeLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        if (((Boolean)layoutNodeShapeLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) {
            return Collections.emptyList();
        }
        boolean hasChildren = !layoutNode.getChildren().isEmpty();
        List<KEdge> insideSelfLoops = this.gatherInsideSelfLoops(layoutNode);
        boolean bl = hasInsideSelfLoops = !insideSelfLoops.isEmpty();
        if (hasChildren || hasInsideSelfLoops) {
            int nodeCount;
            LayoutAlgorithmData algorithmData = this.getAlgorithm(layoutNode);
            boolean supportsHierarchy = algorithmData.supportsFeature(GraphFeature.COMPOUND);
            boolean supportsClusters = algorithmData.supportsFeature(GraphFeature.CLUSTERS);
            boolean supportsInsideSelfLoops = algorithmData.supportsFeature(GraphFeature.INSIDE_SELF_LOOPS);
            this.evaluateHierarchyHandlingInheritance(layoutNode);
            if (!hasChildren && hasInsideSelfLoops && !supportsInsideSelfLoops) {
                return Collections.emptyList();
            }
            ArrayList childrenInsideSelfLoops = Lists.newArrayList();
            if (layoutNodeShapeLayout.getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.INCLUDE_CHILDREN && (supportsHierarchy || supportsClusters)) {
                nodeCount = this.countNodesWithHierarchy(layoutNode);
                LinkedList kNodeQueue = Lists.newLinkedList();
                kNodeQueue.addAll(layoutNode.getChildren());
                while (!kNodeQueue.isEmpty()) {
                    boolean stopHierarchy;
                    KNode knode = (KNode)kNodeQueue.poll();
                    this.evaluateHierarchyHandlingInheritance(knode);
                    KShapeLayout knodeLayout = (KShapeLayout)knode.getData(KShapeLayout.class);
                    boolean bl2 = stopHierarchy = knodeLayout.getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN;
                    if (stopHierarchy || !this.getAlgorithm(knode).equals(algorithmData)) {
                        List<KEdge> childLayoutSelfLoops = this.layoutRecursively(knode, progressMonitor);
                        childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                        knodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
                        KimlUtil.applyConfiguredNodeScaling(knode);
                        continue;
                    }
                    kNodeQueue.addAll(knode.getChildren());
                }
            } else {
                nodeCount = layoutNode.getChildren().size();
                for (KNode child : layoutNode.getChildren()) {
                    List<KEdge> childLayoutSelfLoops = this.layoutRecursively(child, progressMonitor);
                    childrenInsideSelfLoops.addAll(childLayoutSelfLoops);
                    KimlUtil.applyConfiguredNodeScaling(child);
                }
            }
            if (progressMonitor.isCanceled()) {
                return Collections.emptyList();
            }
            for (KEdge selfLoop : childrenInsideSelfLoops) {
                KEdgeLayout edgeLayout = (KEdgeLayout)selfLoop.getData(KEdgeLayout.class);
                edgeLayout.setProperty(LayoutOptions.NO_LAYOUT, true);
            }
            AbstractLayoutProvider layoutProvider = (AbstractLayoutProvider)algorithmData.getInstancePool().fetch();
            try {
                layoutProvider.doLayout(layoutNode, progressMonitor.subTask((float)nodeCount));
                algorithmData.getInstancePool().release((Object)layoutProvider);
            }
            catch (RuntimeException exception) {
                layoutProvider.dispose();
                throw exception;
            }
            this.postProcessInsideSelfLoops(childrenInsideSelfLoops);
            if (hasInsideSelfLoops && supportsInsideSelfLoops) {
                return insideSelfLoops;
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    private LayoutAlgorithmData getAlgorithm(KNode layoutNode) {
        String diagramType;
        KShapeLayout nodeLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        String layoutHint = (String)nodeLayout.getProperty(LayoutOptions.ALGORITHM);
        LayoutAlgorithmData algorithmData = DefaultLayoutConfig.getLayouterData(layoutHint, diagramType = (String)nodeLayout.getProperty(LayoutOptions.DIAGRAM_TYPE));
        if (algorithmData == null) {
            throw new IllegalStateException("No registered layout algorithm is available.");
        }
        return algorithmData;
    }

    private int countNodesRecursively(KNode layoutNode, boolean countAncestors) {
        int count = layoutNode.getChildren().size();
        for (KNode childNode : layoutNode.getChildren()) {
            if (childNode.getChildren().isEmpty()) continue;
            count += this.countNodesRecursively(childNode, false);
        }
        if (countAncestors) {
            KNode parent = layoutNode.getParent();
            while (parent != null) {
                count += parent.getChildren().size();
                parent = parent.getParent();
            }
        }
        return count;
    }

    private void evaluateHierarchyHandlingInheritance(KNode layoutNode) {
        KLayoutData layoutNodeShapeLayout = (KLayoutData)layoutNode.getData(KShapeLayout.class);
        boolean hasLayoutHierarchy = (Boolean)layoutNodeShapeLayout.getProperty(LayoutOptions.LAYOUT_HIERARCHY);
        if (hasLayoutHierarchy) {
            layoutNodeShapeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
        }
        if (layoutNodeShapeLayout.getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.INHERIT) {
            if (layoutNode.getParent() == null) {
                layoutNodeShapeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.SEPARATE_CHILDREN);
            } else {
                HierarchyHandling parentHandling = (HierarchyHandling)((Object)((KShapeLayout)layoutNode.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.HIERARCHY_HANDLING));
                layoutNodeShapeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)parentHandling);
            }
        }
    }

    private int countNodesWithHierarchy(KNode layoutNode) {
        int count = layoutNode.getChildren().size();
        for (KNode childNode : layoutNode.getChildren()) {
            if (((KShapeLayout)childNode.getData(KShapeLayout.class)).getProperty(LayoutOptions.HIERARCHY_HANDLING) == HierarchyHandling.SEPARATE_CHILDREN || !this.getAlgorithm(layoutNode).equals(this.getAlgorithm(childNode)) || childNode.getChildren().isEmpty()) continue;
            count += this.countNodesWithHierarchy(childNode);
        }
        return count;
    }

    private List<KEdge> gatherInsideSelfLoops(KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        if (((Boolean)nodeLayout.getProperty(LayoutOptions.SELF_LOOP_INSIDE)).booleanValue()) {
            ArrayList insideSelfLoops = Lists.newArrayListWithCapacity((int)node.getOutgoingEdges().size());
            for (KEdge edge : node.getOutgoingEdges()) {
                KEdgeLayout edgeLayout;
                if (edge.getTarget() != node || !((Boolean)(edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class)).getProperty(LayoutOptions.SELF_LOOP_INSIDE)).booleanValue()) continue;
                insideSelfLoops.add(edge);
            }
            return insideSelfLoops;
        }
        return Collections.emptyList();
    }

    private void postProcessInsideSelfLoops(List<KEdge> insideSelfLoops) {
        for (KEdge selfLoop : insideSelfLoops) {
            KNode node = selfLoop.getSource();
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KEdgeLayout edgeLayout = (KEdgeLayout)selfLoop.getData(KEdgeLayout.class);
            float xOffset = nodeLayout.getXpos();
            float yOffset = nodeLayout.getYpos();
            this.applyOffset(edgeLayout.getSourcePoint(), xOffset, yOffset);
            this.applyOffset(edgeLayout.getTargetPoint(), xOffset, yOffset);
            for (KPoint bend : edgeLayout.getBendPoints()) {
                this.applyOffset(bend, xOffset, yOffset);
            }
        }
    }

    private void applyOffset(KPoint point, float xOffset, float yOffset) {
        point.setX(point.getX() + xOffset);
        point.setY(point.getY() + yOffset);
    }
}

