/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.comments.IHeuristic;

public abstract class AbstractNormalizedHeuristic
implements IHeuristic {
    private double worstRawValue = 0.0;
    private double bestRawValue = 1.0;
    private NormalizationFunction normalizationFunction = NormalizationFunction.LINEAR;

    protected AbstractNormalizedHeuristic withBounds(double worstRawVal, double bestRawVal) {
        this.worstRawValue = worstRawVal;
        this.bestRawValue = bestRawVal;
        return this;
    }

    protected AbstractNormalizedHeuristic withNormalizationFunction(NormalizationFunction function) {
        if (function == null) {
            throw new IllegalArgumentException("Normalization function cannot be null.");
        }
        this.normalizationFunction = function;
        return this;
    }

    public double getWorstRawValue() {
        return this.worstRawValue;
    }

    public double getBestRawValue() {
        return this.bestRawValue;
    }

    @Override
    public double normalized(KNode comment, KGraphElement element) {
        double rawValue = this.raw(comment, element);
        switch (this.normalizationFunction) {
            case LINEAR: {
                return this.normalizeLinear(rawValue);
            }
            case BINARY: {
                return this.normalizeBinary(rawValue);
            }
        }
        assert (false);
        return 0.0;
    }

    protected final double normalizeLinear(double raw) {
        if (this.worstRawValue < this.bestRawValue) {
            if (raw <= this.worstRawValue) {
                return 0.0;
            }
            if (raw >= this.bestRawValue) {
                return 1.0;
            }
            return (raw - this.worstRawValue) / (this.bestRawValue - this.worstRawValue);
        }
        if (this.bestRawValue < this.worstRawValue) {
            if (raw <= this.bestRawValue) {
                return 1.0;
            }
            if (raw >= this.worstRawValue) {
                return 0.0;
            }
            return 1.0 - (raw - this.bestRawValue) / (this.worstRawValue - this.bestRawValue);
        }
        return raw == this.bestRawValue ? 1 : 0;
    }

    protected final double normalizeBinary(double raw) {
        if (this.worstRawValue < this.bestRawValue) {
            return !(raw <= this.worstRawValue) ? 1 : 0;
        }
        if (this.bestRawValue < this.worstRawValue) {
            return !(raw >= this.worstRawValue) ? 1 : 0;
        }
        return raw == this.bestRawValue ? 1 : 0;
    }

    public static enum NormalizationFunction {
        LINEAR,
        BINARY;

    }
}

