/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.kiml.comments.IAttachmentDecider;
import de.cau.cs.kieler.kiml.comments.IHeuristic;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

public final class AggregatedHeuristicsAttachmentDecider
implements IAttachmentDecider {
    private ToDoubleFunction<Collection<Double>> aggregator = AggregatedHeuristicsAttachmentDecider::max;
    private double lowerBoundary = 0.0;
    private boolean includeLowerBoundary = false;

    public AggregatedHeuristicsAttachmentDecider withAggregator(ToDoubleFunction<Collection<Double>> f) {
        if (f == null) {
            throw new IllegalArgumentException("Aggregator cannot be null.");
        }
        this.aggregator = f;
        return this;
    }

    public AggregatedHeuristicsAttachmentDecider withLowerAttachmentBoundary(double lower) {
        if (lower < 0.0) {
            throw new IllegalArgumentException("Lower boundary must be >= 0.");
        }
        this.lowerBoundary = lower;
        return this;
    }

    public AggregatedHeuristicsAttachmentDecider withLowerBoundaryIncluded(boolean include) {
        this.includeLowerBoundary = include;
        return this;
    }

    @Override
    public KGraphElement makeAttachmentDecision(Map<KGraphElement, Map<Class<? extends IHeuristic>, Double>> normalizedHeuristics) {
        double max = Double.NEGATIVE_INFINITY;
        KGraphElement maxElement = null;
        for (Map.Entry<KGraphElement, Map<Class<? extends IHeuristic>, Double>> entry : normalizedHeuristics.entrySet()) {
            double aggregate = this.aggregator.applyAsDouble(entry.getValue().values());
            if (aggregate < 0.0) {
                throw new IllegalStateException("The aggregator provided a value < 0.");
            }
            if (!(aggregate > max)) continue;
            max = aggregate;
            maxElement = entry.getKey();
        }
        if (this.includeLowerBoundary) {
            return max >= this.lowerBoundary ? maxElement : null;
        }
        return max > this.lowerBoundary ? maxElement : null;
    }

    public static double max(Collection<Double> values) {
        return Collections.max(values);
    }

    public static double min(Collection<Double> values) {
        return Collections.min(values);
    }

    public static double avg(Collection<Double> values) {
        return values.stream().collect(Collectors.averagingDouble(d -> d));
    }

    public static double sum(Collection<Double> values) {
        return values.stream().collect(Collectors.summingDouble(d -> d));
    }
}

