/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.comments.AggregatedHeuristicsAttachmentDecider;
import de.cau.cs.kieler.kiml.comments.IAttachmentDecider;
import de.cau.cs.kieler.kiml.comments.IAttachmentTargetProvider;
import de.cau.cs.kieler.kiml.comments.IBoundsProvider;
import de.cau.cs.kieler.kiml.comments.IEligibilityFilter;
import de.cau.cs.kieler.kiml.comments.IExplicitAttachmentProvider;
import de.cau.cs.kieler.kiml.comments.IHeuristic;
import de.cau.cs.kieler.kiml.comments.ShapeLayoutBoundsProvider;
import de.cau.cs.kieler.kiml.comments.SiblingAttachmentTargetProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public final class CommentAttacher {
    private boolean includeHierarchy = true;
    private boolean explicitAttachmentsDisableHeuristics = true;
    private IExplicitAttachmentProvider explicitAttachmentProvider = a -> null;
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private IAttachmentTargetProvider targetProvider = new SiblingAttachmentTargetProvider();
    private List<IEligibilityFilter> eligibilityFilters = Lists.newArrayList();
    private List<IHeuristic> heuristics = Lists.newArrayList();
    private IAttachmentDecider attachmentDecider = new AggregatedHeuristicsAttachmentDecider();

    public CommentAttacher limitToCurrentHierarchyLevel() {
        this.includeHierarchy = false;
        return this;
    }

    public CommentAttacher keepHeuristicsEnabledWithExplicitAttachments() {
        this.explicitAttachmentsDisableHeuristics = false;
        return this;
    }

    public CommentAttacher withExplicitAttachmentProvider(IExplicitAttachmentProvider provider) {
        this.explicitAttachmentProvider = provider == null ? a -> null : provider;
        return this;
    }

    public CommentAttacher withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    public CommentAttacher withAttachmentTargetProvider(IAttachmentTargetProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.targetProvider = provider;
        return this;
    }

    public CommentAttacher addEligibilityFilter(IEligibilityFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The eligibility filter must not be null.");
        }
        this.eligibilityFilters.add(filter);
        return this;
    }

    public CommentAttacher addHeuristic(IHeuristic heuristic) {
        if (heuristic == null) {
            throw new IllegalArgumentException("The attachment heuristic must not be null.");
        }
        this.heuristics.add(heuristic);
        return this;
    }

    public CommentAttacher withAttachmentDecider(IAttachmentDecider decider) {
        if (decider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.attachmentDecider = decider;
        return this;
    }

    public Collection<KEdge> attachComments(KNode graph) {
        this.preprocess(graph);
        ArrayList explicitAttachments = Lists.newArrayList();
        ArrayList heuristicAttachments = Lists.newArrayList();
        LinkedList processingQueue = Lists.newLinkedList((Iterable)graph.getChildren());
        while (!processingQueue.isEmpty()) {
            KNode node = (KNode)processingQueue.poll();
            if (CommentAttacher.isComment(node)) {
                KGraphElement heuristicAttachment;
                KGraphElement explicitAttachment = this.explicitAttachmentProvider.findExplicitAttachment(node);
                if (explicitAttachment != null) {
                    explicitAttachments.add(Pair.of((Object)node, (Object)explicitAttachment));
                } else if ((explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) && this.isEligibleForHeuristicAttachment(node) && (heuristicAttachment = this.findHeuristicAttachment(node)) != null) {
                    heuristicAttachments.add(Pair.of((Object)node, (Object)heuristicAttachment));
                }
            }
            if (!this.includeHierarchy) continue;
            processingQueue.addAll(node.getChildren());
        }
        this.cleanup();
        Collection<KEdge> createdEdges = this.edgeifyFoundAttachments(explicitAttachments, heuristicAttachments);
        return createdEdges;
    }

    private void preprocess(KNode graph) {
        this.explicitAttachmentProvider.preprocess(graph, this.includeHierarchy);
        this.boundsProvider.preprocess(graph, this.includeHierarchy);
        this.targetProvider.preprocess(graph, this.includeHierarchy);
        this.eligibilityFilters.stream().forEach(f -> f.preprocess(graph, this.includeHierarchy));
        this.heuristics.stream().forEach(h -> h.preprocess(graph, this.includeHierarchy));
    }

    private boolean isEligibleForHeuristicAttachment(KNode comment) {
        return this.eligibilityFilters.stream().allMatch(f -> f.eligibleForAttachment(comment));
    }

    private KGraphElement findHeuristicAttachment(KNode comment) {
        if (this.heuristics.isEmpty()) {
            return null;
        }
        List<KGraphElement> candidates = this.targetProvider.provideAttachmentTargetsFor(comment);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        HashMap results = Maps.newHashMap();
        for (KGraphElement candidate : candidates) {
            HashMap candidateResults = Maps.newHashMap();
            results.put(candidate, candidateResults);
            for (IHeuristic heuristic : this.heuristics) {
                candidateResults.put(heuristic.getClass(), heuristic.normalized(comment, candidate));
            }
        }
        return this.attachmentDecider.makeAttachmentDecision(results);
    }

    private Collection<KEdge> edgeifyFoundAttachments(Collection<Pair<KNode, KGraphElement>> explicitAttachments, Collection<Pair<KNode, KGraphElement>> heuristicAttachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)(explicitAttachments.size() + heuristicAttachments.size()));
        createdEdges.addAll(this.edgeifyFoundAttachments(explicitAttachments));
        if (explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) {
            createdEdges.addAll(this.edgeifyFoundAttachments(heuristicAttachments));
        }
        return createdEdges;
    }

    private Collection<KEdge> edgeifyFoundAttachments(Collection<Pair<KNode, KGraphElement>> attachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Pair<KNode, KGraphElement> attachment : attachments) {
            if (!(attachment.getSecond() instanceof KNode)) continue;
            KNode comment = (KNode)attachment.getFirst();
            KNode target = (KNode)attachment.getSecond();
            KEdge edge = KimlUtil.createInitializedEdge();
            edge.setSource(comment);
            edge.setTarget(target);
            createdEdges.add(edge);
        }
        return createdEdges;
    }

    private void cleanup() {
        this.explicitAttachmentProvider.cleanup();
        this.boundsProvider.cleanup();
        this.targetProvider.cleanup();
        this.eligibilityFilters.stream().forEach(f -> f.cleanup());
        this.heuristics.stream().forEach(h -> h.cleanup());
    }

    public static boolean isComment(KNode node) {
        KLayoutData layoutData = (KLayoutData)node.getData(KLayoutData.class);
        return (Boolean)layoutData.getProperty(LayoutOptions.COMMENT_BOX);
    }
}

