/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.kgraph.KNode;
import java.awt.geom.Rectangle2D;
import java.util.Map;

@FunctionalInterface
public interface IBoundsProvider {
    public Rectangle2D.Double boundsFor(KNode var1);

    default public void preprocess(KNode graph, boolean includeHierarchy) {
    }

    default public void cleanup() {
    }

    default public IBoundsProvider cached() {
        return new IBoundsProvider(){
            private final Map<KNode, Rectangle2D.Double> boundsCache = Maps.newHashMap();

            @Override
            public Rectangle2D.Double boundsFor(KNode node) {
                if (this.boundsCache.containsKey(node)) {
                    return this.boundsCache.get(node);
                }
                Rectangle2D.Double bounds = IBoundsProvider.this.boundsFor(node);
                this.boundsCache.put(node, bounds);
                return bounds;
            }

            @Override
            public void preprocess(KNode graph, boolean includeHierarchy) {
                IBoundsProvider.this.preprocess(graph, includeHierarchy);
            }

            @Override
            public void cleanup() {
                this.boundsCache.clear();
                IBoundsProvider.this.cleanup();
            }
        };
    }
}

