/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.comments.CommentAttacher;
import de.cau.cs.kieler.kiml.comments.DistanceHeuristic;
import de.cau.cs.kieler.kiml.comments.IBoundsProvider;
import de.cau.cs.kieler.kiml.comments.IHeuristic;
import de.cau.cs.kieler.kiml.comments.ShapeLayoutBoundsProvider;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeReferenceHeuristic
implements IHeuristic {
    private Function<KNode, String> commentTextFunction = null;
    private Function<KNode, String> nodeNameFunction = null;
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private double maxDistance = -1.0;
    private boolean fuzzy = false;
    private Map<KNode, KNode> foundAttachments = Maps.newHashMap();

    public NodeReferenceHeuristic withCommentTextProvider(Function<KNode, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("Comment text function cannot be null.");
        }
        this.commentTextFunction = f;
        return this;
    }

    public NodeReferenceHeuristic withNodeNameProvider(Function<KNode, String> f) {
        if (f == null) {
            throw new IllegalArgumentException("Node name function cannot be null.");
        }
        this.nodeNameFunction = f;
        return this;
    }

    public NodeReferenceHeuristic withFuzzyMatching() {
        this.fuzzy = true;
        return this;
    }

    public NodeReferenceHeuristic withMaximumAttachmentDistance(double distance) {
        this.maxDistance = distance;
        return this;
    }

    public NodeReferenceHeuristic withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    private void checkConfiguration() {
        if (this.commentTextFunction == null) {
            throw new IllegalStateException("A comment text function is required.");
        }
        if (this.nodeNameFunction == null) {
            throw new IllegalStateException("A node name function is required.");
        }
    }

    @Override
    public void preprocess(KNode graph, boolean includeHierarchy) {
        this.checkConfiguration();
        ArrayList commentTexts = Lists.newArrayList();
        ArrayList nodeNames = Lists.newArrayList();
        for (KNode node : graph.getChildren()) {
            if (CommentAttacher.isComment(node)) {
                String commentText = this.commentTextFunction.apply(node);
                if (Strings.isNullOrEmpty((String)commentText)) continue;
                commentTexts.add(Pair.of((Object)node, (Object)commentText));
                continue;
            }
            String nodeName = this.nodeNameFunction.apply(node);
            if (!Strings.isNullOrEmpty((String)nodeName)) {
                nodeNames.add(Pair.of((Object)node, (Object)nodeName));
            }
            if (!includeHierarchy || node.getChildren().isEmpty()) continue;
            this.preprocess(node, true);
        }
        this.goFindMatches(commentTexts, nodeNames);
        commentTexts = null;
    }

    @Override
    public void cleanup() {
        this.foundAttachments.clear();
    }

    @Override
    public double raw(KNode comment, KGraphElement element) {
        return this.foundAttachments.get(comment) == element ? 1 : 0;
    }

    @Override
    public double normalized(KNode comment, KGraphElement element) {
        return this.raw(comment, element);
    }

    private void goFindMatches(List<Pair<KNode, String>> commentTexts, List<Pair<KNode, String>> nodeNames) {
        ArrayList nodeRegexps = Lists.newArrayListWithCapacity((int)nodeNames.size());
        for (Pair<KNode, String> nodeNamePair : nodeNames) {
            Pattern regexp = this.fuzzy ? NodeReferenceHeuristic.fuzzyRegexpFor((String)nodeNamePair.getSecond()) : NodeReferenceHeuristic.strictRegexpFor((String)nodeNamePair.getSecond());
            nodeRegexps.add(Pair.of((Object)((KNode)nodeNamePair.getFirst()), (Object)regexp));
        }
        for (Pair<KNode, String> commentTextPair : commentTexts) {
            Rectangle2D.Double nodeBounds;
            KNode foundNode = null;
            for (Pair nodeRegexpPair : nodeRegexps) {
                Matcher matcher = ((Pattern)nodeRegexpPair.getSecond()).matcher((CharSequence)commentTextPair.getSecond());
                if (!matcher.find()) continue;
                if (foundNode == null) {
                    foundNode = (KNode)nodeRegexpPair.getFirst();
                    continue;
                }
                foundNode = null;
                break;
            }
            if (foundNode == null) continue;
            if (this.maxDistance < 0.0) {
                this.foundAttachments.put((KNode)commentTextPair.getFirst(), foundNode);
                continue;
            }
            Rectangle2D.Double commentBounds = this.boundsProvider.boundsFor((KNode)commentTextPair.getFirst());
            if (!(DistanceHeuristic.distance(commentBounds, nodeBounds = this.boundsProvider.boundsFor(foundNode)) <= this.maxDistance)) continue;
            this.foundAttachments.put((KNode)commentTextPair.getFirst(), foundNode);
        }
    }

    private static Pattern fuzzyRegexpFor(String nodeName) {
        String trimmedNodeName = nodeName.trim();
        StringBuffer regexp = new StringBuffer(nodeName.length() * 2);
        StringBuffer currentSegment = new StringBuffer(nodeName.length());
        int i = 0;
        while (i < trimmedNodeName.length()) {
            char currC = trimmedNodeName.charAt(i);
            if (Character.isUpperCase(currC)) {
                if (i > 0 && Character.isLowerCase(trimmedNodeName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(nodeName.length());
                    regexp.append("[\\h\\v]*");
                }
                currentSegment.append(currC);
            } else if (Character.isWhitespace(currC)) {
                if (i > 0 && !Character.isWhitespace(trimmedNodeName.charAt(i - 1))) {
                    regexp.append(Pattern.quote(currentSegment.toString()));
                    currentSegment = new StringBuffer(nodeName.length());
                    regexp.append("[\\h\\v]*");
                }
            } else {
                currentSegment.append(currC);
            }
            ++i;
        }
        regexp.append(Pattern.quote(currentSegment.toString()));
        return Pattern.compile("\\b" + regexp.toString() + "\\b", 34);
    }

    private static Pattern strictRegexpFor(String nodeName) {
        return Pattern.compile("\\b" + Pattern.quote(nodeName) + "\\b", 32);
    }

    public Map<KNode, KNode> getAttachments() {
        return this.foundAttachments;
    }
}

