/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.comments;

import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.kiml.comments.IBoundsProvider;
import de.cau.cs.kieler.kiml.comments.IEligibilityFilter;
import de.cau.cs.kieler.kiml.comments.ShapeLayoutBoundsProvider;
import java.awt.geom.Rectangle2D;

public class SizeEligibilityFilter
implements IEligibilityFilter {
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private double maxArea = -1.0;

    public SizeEligibilityFilter withMaximumArea(double area) {
        if (area < 0.0) {
            throw new IllegalArgumentException("Maximum area must be >= 0.");
        }
        this.maxArea = area;
        return this;
    }

    public SizeEligibilityFilter withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    @Override
    public boolean eligibleForAttachment(KNode comment) {
        Rectangle2D.Double bounds = this.boundsProvider.boundsFor(comment);
        return bounds.height * bounds.width <= this.maxArea;
    }
}

