/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.DefaultLayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import java.util.Collection;
import java.util.EnumSet;

public abstract class AbstractMutableLayoutConfig
implements IMutableLayoutConfig {
    public static LayoutContext createContainerContext(LayoutContext context) {
        LayoutAlgorithmData algoData;
        String layoutHint;
        Object domainModel;
        Object diagramPart;
        LayoutContext containerContext = new LayoutContext();
        if (((Boolean)context.getProperty(LayoutContext.GLOBAL)).booleanValue()) {
            containerContext.setProperty(LayoutContext.GLOBAL, true);
        }
        if ((diagramPart = context.getProperty(LayoutContext.CONTAINER_DIAGRAM_PART)) != null) {
            containerContext.setProperty(LayoutContext.DIAGRAM_PART, diagramPart);
        }
        if ((domainModel = context.getProperty(LayoutContext.CONTAINER_DOMAIN_MODEL)) != null) {
            containerContext.setProperty(LayoutContext.DOMAIN_MODEL, domainModel);
        }
        if ((layoutHint = (String)context.getProperty(DefaultLayoutConfig.CONTAINER_HINT)) != null) {
            containerContext.setProperty(DefaultLayoutConfig.CONTENT_HINT, layoutHint);
        }
        String diagramType = (String)context.getProperty(DefaultLayoutConfig.CONTAINER_DIAGT);
        if (diagramPart != null) {
            containerContext.setProperty(DefaultLayoutConfig.CONTENT_DIAGT, diagramType);
        }
        if ((algoData = (LayoutAlgorithmData)context.getProperty(DefaultLayoutConfig.CONTAINER_ALGO)) != null) {
            containerContext.setProperty(DefaultLayoutConfig.CONTENT_ALGO, algoData);
        }
        containerContext.setProperty(LayoutContext.OPT_TARGETS, EnumSet.of(LayoutOptionData.Target.PARENTS));
        return containerContext;
    }

    @Override
    public Object getContextValue(IProperty<?> property, LayoutContext context) {
        LayoutOptionData diagTypeData;
        if (property.equals(DefaultLayoutConfig.CONTENT_HINT)) {
            LayoutOptionData algorithmData = LayoutMetaDataService.getInstance().getOptionData(LayoutOptions.ALGORITHM.getId());
            if (algorithmData != null) {
                return this.getOptionValue(algorithmData, context);
            }
        } else if (property.equals(DefaultLayoutConfig.CONTENT_DIAGT)) {
            LayoutOptionData diagTypeData2 = LayoutMetaDataService.getInstance().getOptionData(LayoutOptions.DIAGRAM_TYPE.getId());
            if (diagTypeData2 != null) {
                return this.getOptionValue(diagTypeData2, context);
            }
        } else if (property.equals(DefaultLayoutConfig.CONTAINER_HINT)) {
            LayoutOptionData algorithmData = LayoutMetaDataService.getInstance().getOptionData(LayoutOptions.ALGORITHM.getId());
            if (algorithmData != null) {
                return this.getOptionValue(algorithmData, AbstractMutableLayoutConfig.createContainerContext(context));
            }
        } else if (property.equals(DefaultLayoutConfig.CONTAINER_DIAGT) && (diagTypeData = LayoutMetaDataService.getInstance().getOptionData(LayoutOptions.DIAGRAM_TYPE.getId())) != null) {
            return this.getOptionValue(diagTypeData, AbstractMutableLayoutConfig.createContainerContext(context));
        }
        return null;
    }

    @Override
    public void clearOptionValues(LayoutContext context) {
        LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
        Collection<IProperty<?>> affectedOptions = this.getAffectedOptions(context);
        if (affectedOptions != null) {
            for (IProperty<?> property : affectedOptions) {
                LayoutOptionData optionData = property instanceof LayoutOptionData ? (LayoutOptionData)property : layoutDataService.getOptionData(property.getId());
                if (optionData == null) continue;
                this.setOptionValue(optionData, context, null);
            }
        }
    }

    @Override
    public boolean isSet(LayoutOptionData optionData, LayoutContext context) {
        return this.getOptionValue(optionData, context) != null;
    }
}

