/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.IMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;

public class CompoundLayoutConfig
implements IMutableLayoutConfig {
    private final LinkedList<ILayoutConfig> configs = new LinkedList();

    public static CompoundLayoutConfig of(ILayoutConfig ... confs) {
        CompoundLayoutConfig instance = new CompoundLayoutConfig();
        ILayoutConfig[] iLayoutConfigArray = confs;
        int n = confs.length;
        int n2 = 0;
        while (n2 < n) {
            ILayoutConfig conf = iLayoutConfigArray[n2];
            if (conf != null) {
                instance.add(conf);
            }
            ++n2;
        }
        return instance;
    }

    public CompoundLayoutConfig() {
    }

    public CompoundLayoutConfig(Collection<ILayoutConfig> confs) {
        for (ILayoutConfig conf : confs) {
            this.add(conf);
        }
    }

    public CompoundLayoutConfig(CompoundLayoutConfig compConf) {
        for (ILayoutConfig conf : compConf.configs) {
            this.add(conf);
        }
    }

    public void add(ILayoutConfig conf) {
        if (conf instanceof CompoundLayoutConfig) {
            CompoundLayoutConfig compConf = (CompoundLayoutConfig)conf;
            if (compConf != this) {
                for (ILayoutConfig c : compConf.configs) {
                    this.add(c);
                }
            }
        } else {
            ListIterator<ILayoutConfig> configIter = this.configs.listIterator();
            int prio = conf.getPriority();
            while (configIter.hasNext()) {
                ILayoutConfig nextConf = (ILayoutConfig)configIter.next();
                if (nextConf.getPriority() > prio) continue;
                configIter.previous();
                break;
            }
            configIter.add(conf);
        }
    }

    public void addAll(Collection<ILayoutConfig> confs) {
        for (ILayoutConfig conf : confs) {
            this.add(conf);
        }
    }

    public void remove(ILayoutConfig conf) {
        if (conf instanceof CompoundLayoutConfig) {
            CompoundLayoutConfig compConf = (CompoundLayoutConfig)conf;
            if (compConf == this) {
                this.configs.clear();
            } else {
                for (ILayoutConfig c : compConf.configs) {
                    this.remove(c);
                }
            }
        }
        this.configs.remove(conf);
    }

    public void removeAll(Collection<ILayoutConfig> confs) {
        for (ILayoutConfig conf : confs) {
            this.remove(conf);
        }
    }

    @Override
    public int getPriority() {
        if (this.configs.isEmpty()) {
            return 0;
        }
        return this.configs.getFirst().getPriority();
    }

    @Override
    public Object getContextValue(IProperty<?> property, LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            Object value = conf.getContextValue(property, context);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Object getOptionValue(LayoutOptionData optionData, LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            Object value = conf.getOptionValue(optionData, context);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public Collection<IProperty<?>> getAffectedOptions(LayoutContext context) {
        if (this.configs.size() == 1) {
            return this.configs.getFirst().getAffectedOptions(context);
        }
        if (this.configs.size() > 1) {
            HashSet collectedOptions = new HashSet();
            for (ILayoutConfig conf : this.configs) {
                collectedOptions.addAll(conf.getAffectedOptions(context));
            }
            return collectedOptions;
        }
        return Collections.emptyList();
    }

    @Override
    public void clearOptionValues(LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            if (!(conf instanceof IMutableLayoutConfig)) continue;
            IMutableLayoutConfig mlc = (IMutableLayoutConfig)conf;
            mlc.clearOptionValues(context);
        }
    }

    @Override
    public void setOptionValue(LayoutOptionData optionData, LayoutContext context, Object value) {
        for (ILayoutConfig conf : this.configs) {
            if (!(conf instanceof IMutableLayoutConfig)) continue;
            IMutableLayoutConfig mlc = (IMutableLayoutConfig)conf;
            mlc.setOptionValue(optionData, context, value);
            if (value == null || !mlc.isSet(optionData, context)) continue;
            return;
        }
    }

    @Override
    public boolean isSet(LayoutOptionData optionData, LayoutContext context) {
        for (ILayoutConfig conf : this.configs) {
            IMutableLayoutConfig mlc;
            if (!(conf instanceof IMutableLayoutConfig) || !(mlc = (IMutableLayoutConfig)conf).isSet(optionData, context)) continue;
            return true;
        }
        return false;
    }
}

