/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.kgraph.util.KGraphSwitch;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutAlgorithmData;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class DefaultLayoutConfig
implements ILayoutConfig {
    public static final int PRIORITY = 0;
    public static final IProperty<List<LayoutOptionData>> OPTIONS = new Property("context.options");
    public static final IProperty<String> CONTENT_HINT = new Property("context.contentHint");
    public static final IProperty<String> CONTENT_DIAGT = new Property("context.contentDiagramType");
    public static final IProperty<LayoutAlgorithmData> CONTENT_ALGO = new Property("context.contentAlgorithm");
    public static final IProperty<String> CONTAINER_HINT = new Property("context.containerHint");
    public static final IProperty<String> CONTAINER_DIAGT = new Property("context.containerDiagramType");
    public static final IProperty<LayoutAlgorithmData> CONTAINER_ALGO = new Property("context.containerAlgorithm");
    public static final IProperty<Boolean> HAS_PORTS = new Property("context.hasPorts", (Object)false);
    private OptionTargetSwitch kgraphSwitch = new OptionTargetSwitch();

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public Object getContextValue(IProperty<?> property, LayoutContext context) {
        if (property.equals(HAS_PORTS)) {
            KGraphElement graphElement = (KGraphElement)context.getProperty(LayoutContext.GRAPH_ELEM);
            if (graphElement instanceof KNode) {
                return !((KNode)graphElement).getPorts().isEmpty();
            }
        } else if (property.equals(LayoutContext.OPT_TARGETS)) {
            KGraphElement graphElement = (KGraphElement)context.getProperty(LayoutContext.GRAPH_ELEM);
            if (graphElement != null) {
                return this.kgraphSwitch.doSwitch((EObject)graphElement);
            }
        } else if (property.equals(CONTENT_ALGO)) {
            if (DefaultLayoutConfig.isParentElement(context)) {
                return DefaultLayoutConfig.getLayouterData((String)context.getProperty(CONTENT_HINT), (String)context.getProperty(CONTENT_DIAGT));
            }
        } else if (property.equals(CONTAINER_ALGO)) {
            if (DefaultLayoutConfig.isContainedElement(context)) {
                return DefaultLayoutConfig.getLayouterData((String)context.getProperty(CONTAINER_HINT), (String)context.getProperty(CONTAINER_DIAGT));
            }
        } else if (property.equals(OPTIONS)) {
            LayoutMetaDataService layoutDataService = LayoutMetaDataService.getInstance();
            LinkedList<LayoutOptionData> optionData = new LinkedList<LayoutOptionData>();
            LayoutAlgorithmData algoData = (LayoutAlgorithmData)context.getProperty(CONTENT_ALGO);
            if (algoData != null) {
                optionData.addAll(layoutDataService.getOptionData(algoData, LayoutOptionData.Target.PARENTS));
            }
            algoData = (LayoutAlgorithmData)context.getProperty(CONTAINER_ALGO);
            Set optionTargets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
            if (algoData != null && optionTargets != null) {
                for (LayoutOptionData.Target target : optionTargets) {
                    if (target == LayoutOptionData.Target.PARENTS) continue;
                    optionData.addAll(layoutDataService.getOptionData(algoData, target));
                }
            }
            return optionData;
        }
        return context.getProperty(property);
    }

    private static boolean isParentElement(LayoutContext context) {
        Set optionTargets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        return optionTargets != null && optionTargets.contains((Object)LayoutOptionData.Target.PARENTS);
    }

    private static boolean isContainedElement(LayoutContext context) {
        Set optionTargets = (Set)context.getProperty(LayoutContext.OPT_TARGETS);
        return optionTargets != null && (optionTargets.contains((Object)LayoutOptionData.Target.NODES) || optionTargets.contains((Object)LayoutOptionData.Target.EDGES) || optionTargets.contains((Object)LayoutOptionData.Target.PORTS) || optionTargets.contains((Object)LayoutOptionData.Target.LABELS));
    }

    @Override
    public Object getOptionValue(LayoutOptionData optionData, LayoutContext context) {
        Object result = null;
        LayoutAlgorithmData contentAlgoData = (LayoutAlgorithmData)context.getProperty(CONTENT_ALGO);
        if (contentAlgoData != null && optionData.getTargets().contains((Object)LayoutOptionData.Target.PARENTS) && (result = contentAlgoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        LayoutAlgorithmData containerAlgoData = (LayoutAlgorithmData)context.getProperty(CONTAINER_ALGO);
        if (containerAlgoData != null && (result = containerAlgoData.getDefaultValue(optionData)) != null) {
            return result;
        }
        result = optionData.getDefault();
        if (result != null) {
            return result;
        }
        return optionData.getDefaultDefault();
    }

    public static LayoutAlgorithmData getLayouterData(String theLayoutHint, String diagramType) {
        String layoutHint;
        String chDiagType = diagramType == null || diagramType.length() == 0 ? "de.cau.cs.kieler.layout.diagrams.general" : diagramType;
        LayoutMetaDataService layoutServices = LayoutMetaDataService.getInstance();
        LayoutAlgorithmData directHitData = layoutServices.getAlgorithmData(layoutHint = theLayoutHint);
        if (directHitData != null) {
            return directHitData;
        }
        LayoutAlgorithmData bestAlgo = null;
        int bestPrio = -536870912;
        boolean matchesLayoutType = false;
        boolean matchesDiagramType = false;
        boolean matchesGeneralDiagram = false;
        for (LayoutAlgorithmData currentAlgo : layoutServices.getAlgorithmData()) {
            int currentPrio = currentAlgo.getDiagramSupport(chDiagType);
            String layoutType = currentAlgo.getType();
            if (matchesLayoutType) {
                if (layoutType.length() <= 0 || !layoutType.equals(layoutHint)) continue;
                if (matchesDiagramType) {
                    if (currentPrio <= bestPrio) continue;
                    bestAlgo = currentAlgo;
                    bestPrio = currentPrio;
                    continue;
                }
                if (currentPrio > -536870912) {
                    bestAlgo = currentAlgo;
                    bestPrio = currentPrio;
                    matchesDiagramType = true;
                    matchesGeneralDiagram = false;
                    continue;
                }
                currentPrio = currentAlgo.getDiagramSupport("de.cau.cs.kieler.layout.diagrams.general");
                if (matchesGeneralDiagram) {
                    if (currentPrio <= bestPrio) continue;
                    bestAlgo = currentAlgo;
                    bestPrio = currentPrio;
                    continue;
                }
                if (currentPrio > -536870912) {
                    bestAlgo = currentAlgo;
                    bestPrio = currentPrio;
                    matchesGeneralDiagram = true;
                    continue;
                }
                if (bestAlgo != null) continue;
                bestAlgo = currentAlgo;
                continue;
            }
            if (layoutType.length() > 0 && layoutType.equals(layoutHint)) {
                bestAlgo = currentAlgo;
                matchesLayoutType = true;
                if (currentPrio > -536870912) {
                    bestPrio = currentPrio;
                    matchesDiagramType = true;
                    matchesGeneralDiagram = false;
                    continue;
                }
                matchesDiagramType = false;
                currentPrio = currentAlgo.getDiagramSupport("de.cau.cs.kieler.layout.diagrams.general");
                if (currentPrio > -536870912) {
                    bestPrio = currentPrio;
                    matchesGeneralDiagram = true;
                    continue;
                }
                matchesGeneralDiagram = false;
                continue;
            }
            if (matchesDiagramType) {
                if (currentPrio <= bestPrio) continue;
                bestAlgo = currentAlgo;
                bestPrio = currentPrio;
                continue;
            }
            if (currentPrio > -536870912) {
                bestAlgo = currentAlgo;
                bestPrio = currentPrio;
                matchesDiagramType = true;
                matchesGeneralDiagram = false;
                continue;
            }
            currentPrio = currentAlgo.getDiagramSupport("de.cau.cs.kieler.layout.diagrams.general");
            if (matchesGeneralDiagram) {
                if (currentPrio <= bestPrio) continue;
                bestAlgo = currentAlgo;
                bestPrio = currentPrio;
                continue;
            }
            if (currentPrio > -536870912) {
                bestAlgo = currentAlgo;
                bestPrio = currentPrio;
                matchesGeneralDiagram = true;
                continue;
            }
            if (bestAlgo != null) continue;
            bestAlgo = currentAlgo;
        }
        return bestAlgo;
    }

    @Override
    public Collection<IProperty<?>> getAffectedOptions(LayoutContext context) {
        return Collections.emptyList();
    }

    public static class OptionTargetSwitch
    extends KGraphSwitch<Set<LayoutOptionData.Target>> {
        public Set<LayoutOptionData.Target> caseKNode(KNode node) {
            EnumSet<LayoutOptionData.Target> targets = EnumSet.noneOf(LayoutOptionData.Target.class);
            if (node.getParent() != null) {
                targets.add(LayoutOptionData.Target.NODES);
            }
            if (node.getChildren().size() != 0) {
                targets.add(LayoutOptionData.Target.PARENTS);
            }
            return targets;
        }

        public Set<LayoutOptionData.Target> caseKEdge(KEdge edge) {
            return EnumSet.of(LayoutOptionData.Target.EDGES);
        }

        public Set<LayoutOptionData.Target> caseKPort(KPort port) {
            return EnumSet.of(LayoutOptionData.Target.PORTS);
        }

        public Set<LayoutOptionData.Target> caseKLabel(KLabel label) {
            return EnumSet.of(LayoutOptionData.Target.LABELS);
        }
    }
}

