/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.config;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.config.AbstractMutableLayoutConfig;
import de.cau.cs.kieler.kiml.config.LayoutContext;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class VolatileLayoutConfig
extends AbstractMutableLayoutConfig {
    public static final int DEFAULT_PRIORITY = 100;
    private final Map<Object, Map<IProperty<Object>, Object>> focusOptionMap = Maps.newHashMap();
    private final Set<IProperty<?>> contextKeys = new HashSet();
    private final Map<LayoutOptionData, Object> globalOptionMap = Maps.newHashMap();
    private int priority;

    public static VolatileLayoutConfig fromProperties(KNode graph, int priority) {
        VolatileLayoutConfig config = new VolatileLayoutConfig(priority);
        UnmodifiableIterator elementIter = Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class);
        while (elementIter.hasNext()) {
            KGraphElement element = (KGraphElement)elementIter.next();
            KLayoutData layoutData = (KLayoutData)element.getData(KLayoutData.class);
            if (layoutData == null) continue;
            for (Map.Entry entry : layoutData.getProperties()) {
                if (entry.getKey() == null || entry.getValue() == null) continue;
                config.setValue((IProperty)entry.getKey(), element, LayoutContext.GRAPH_ELEM, entry.getValue());
            }
        }
        return config;
    }

    public VolatileLayoutConfig() {
        this.priority = 100;
    }

    public VolatileLayoutConfig(int prio) {
        this.priority = prio;
    }

    public String toString() {
        return "VolatileLayoutConfig:" + this.focusOptionMap.toString() + this.globalOptionMap.toString();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void copyValues(VolatileLayoutConfig other) {
        this.contextKeys.addAll(other.contextKeys);
        this.focusOptionMap.putAll(other.focusOptionMap);
        this.globalOptionMap.putAll(other.globalOptionMap);
    }

    public Object getGlobalValue(IProperty<?> option) {
        return this.globalOptionMap.get(option);
    }

    public Map<LayoutOptionData, Object> getGlobalValues() {
        return Collections.unmodifiableMap(this.globalOptionMap);
    }

    @Override
    public Object getOptionValue(LayoutOptionData optionData, LayoutContext context) {
        for (IProperty<?> contextKey : this.contextKeys) {
            Object value;
            Object object = context.getProperty(contextKey);
            Map<IProperty<Object>, Object> contextOptions = this.focusOptionMap.get(object);
            if (contextOptions == null || (value = contextOptions.get(optionData)) == null) continue;
            return value;
        }
        Object value = this.globalOptionMap.get(optionData);
        if (value != null) {
            KGraphElement graphElem = (KGraphElement)context.getProperty(LayoutContext.GRAPH_ELEM);
            boolean isGlobal = (Boolean)context.getProperty(LayoutContext.GLOBAL);
            if (isGlobal || this.matchesTargetType(optionData, graphElem)) {
                return value;
            }
        }
        return null;
    }

    public <T, C> VolatileLayoutConfig setValue(IProperty<? super T> option, C contextObj, IProperty<? super C> contextKey, T value) {
        this.contextKeys.add(contextKey);
        Map<IProperty<Object>, Object> contextOptions = this.focusOptionMap.get(contextObj);
        if (contextOptions == null) {
            contextOptions = new HashMap<IProperty<Object>, Object>();
            this.focusOptionMap.put(contextObj, contextOptions);
        }
        if (value == null) {
            contextOptions.remove(option);
        } else {
            contextOptions.put(option, value);
        }
        return this;
    }

    public <T> VolatileLayoutConfig setValue(IProperty<? super T> option, T value) {
        if (option instanceof LayoutOptionData) {
            this.globalOptionMap.put((LayoutOptionData)option, value);
        } else {
            LayoutOptionData optionData = LayoutMetaDataService.getInstance().getOptionData(option.getId());
            if (optionData != null) {
                this.globalOptionMap.put(optionData, value);
            } else {
                throw new IllegalArgumentException("The given property is not registered as a layout option");
            }
        }
        return this;
    }

    @Override
    public Collection<IProperty<?>> getAffectedOptions(LayoutContext context) {
        LinkedList options = new LinkedList();
        KGraphElement graphElem = (KGraphElement)context.getProperty(LayoutContext.GRAPH_ELEM);
        boolean isGlobal = (Boolean)context.getProperty(LayoutContext.GLOBAL);
        for (LayoutOptionData layoutOptionData : this.globalOptionMap.keySet()) {
            if (!isGlobal && !this.matchesTargetType(layoutOptionData, graphElem)) continue;
            options.add(layoutOptionData);
        }
        for (IProperty iProperty : this.contextKeys) {
            Object object = context.getProperty(iProperty);
            Map<IProperty<Object>, Object> contextOptions = this.focusOptionMap.get(object);
            if (contextOptions == null) continue;
            options.addAll(contextOptions.keySet());
        }
        return options;
    }

    private boolean matchesTargetType(LayoutOptionData optionData, KGraphElement graphElem) {
        if (graphElem == null) {
            return false;
        }
        Set<LayoutOptionData.Target> optionTargets = optionData.getTargets();
        switch (graphElem.eClass().getClassifierID()) {
            case 3: {
                if (!optionTargets.contains((Object)LayoutOptionData.Target.NODES) && (((KNode)graphElem).getChildren().isEmpty() || !optionTargets.contains((Object)LayoutOptionData.Target.PARENTS))) break;
                return true;
            }
            case 4: {
                if (!optionTargets.contains((Object)LayoutOptionData.Target.EDGES)) break;
                return true;
            }
            case 5: {
                if (!optionTargets.contains((Object)LayoutOptionData.Target.PORTS)) break;
                return true;
            }
            case 6: {
                if (!optionTargets.contains((Object)LayoutOptionData.Target.LABELS)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setOptionValue(LayoutOptionData optionData, LayoutContext context, Object value) {
        KGraphElement graphElem = (KGraphElement)context.getProperty(LayoutContext.GRAPH_ELEM);
        if (((Boolean)context.getProperty(LayoutContext.GLOBAL)).booleanValue()) {
            if (this.matchesTargetType(optionData, graphElem)) {
                this.globalOptionMap.put(optionData, value);
            }
        } else {
            Object diagramPart = context.getProperty(LayoutContext.DIAGRAM_PART);
            Object domainModel = context.getProperty(LayoutContext.DOMAIN_MODEL);
            if (diagramPart != null) {
                this.setValue(optionData, diagramPart, LayoutContext.DIAGRAM_PART, value);
            } else if (domainModel != null) {
                this.setValue(optionData, domainModel, LayoutContext.DOMAIN_MODEL, value);
            } else if (graphElem != null) {
                this.setValue(optionData, graphElem, LayoutContext.GRAPH_ELEM, value);
            }
        }
    }

    @Override
    public void clearOptionValues(LayoutContext context) {
        if (((Boolean)context.getProperty(LayoutContext.GLOBAL)).booleanValue()) {
            this.globalOptionMap.clear();
        } else {
            for (IProperty<?> contextKey : this.contextKeys) {
                Object object = context.getProperty(contextKey);
                this.focusOptionMap.remove(object);
            }
        }
    }
}

