/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.EnumSet;

public class FixedLayoutProvider
extends AbstractLayoutProvider {
    public static final String ID = "de.cau.cs.kieler.fixed";
    private static final float DEF_BORDER_SPACING = 15.0f;

    @Override
    public void doLayout(KNode layoutNode, IKielerProgressMonitor progressMonitor) {
        float borderSpacing;
        progressMonitor.begin("Fixed Layout", 1.0f);
        KShapeLayout parentLayout = (KShapeLayout)layoutNode.getData(KShapeLayout.class);
        EdgeRouting edgeRouting = (EdgeRouting)((Object)parentLayout.getProperty(LayoutOptions.EDGE_ROUTING));
        float maxx = 0.0f;
        float maxy = 0.0f;
        for (KNode node : layoutNode.getChildren()) {
            KVector maxv;
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            Object pos = (KVector)nodeLayout.getProperty(LayoutOptions.POSITION);
            if (pos != null) {
                nodeLayout.applyVector((KVector)pos);
                if (((EnumSet)nodeLayout.getProperty(LayoutOptions.SIZE_CONSTRAINT)).contains((Object)SizeConstraint.MINIMUM_SIZE)) {
                    float width = ((Float)nodeLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue();
                    float height = ((Float)nodeLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue();
                    if (width > 0.0f && height > 0.0f) {
                        KimlUtil.resizeNode(node, width, height, true, true);
                    }
                }
            }
            maxx = Math.max(maxx, nodeLayout.getXpos() + nodeLayout.getWidth());
            maxy = Math.max(maxy, nodeLayout.getYpos() + nodeLayout.getHeight());
            for (KLabel label : node.getLabels()) {
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                pos = (KVector)labelLayout.getProperty(LayoutOptions.POSITION);
                if (pos != null) {
                    labelLayout.applyVector((KVector)pos);
                }
                maxx = Math.max(maxx, nodeLayout.getXpos() + labelLayout.getXpos() + labelLayout.getWidth());
                maxy = Math.max(maxy, nodeLayout.getYpos() + labelLayout.getYpos() + labelLayout.getHeight());
            }
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                pos = (KVector)portLayout.getProperty(LayoutOptions.POSITION);
                if (pos != null) {
                    portLayout.applyVector((KVector)pos);
                }
                float portx = nodeLayout.getXpos() + portLayout.getXpos();
                float porty = nodeLayout.getYpos() + portLayout.getYpos();
                maxx = Math.max(maxx, portx + portLayout.getWidth());
                maxy = Math.max(maxy, porty + portLayout.getHeight());
                for (KLabel label : port.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                    pos = (KVector)labelLayout.getProperty(LayoutOptions.POSITION);
                    if (pos != null) {
                        labelLayout.applyVector((KVector)pos);
                    }
                    maxx = Math.max(maxx, portx + labelLayout.getXpos() + labelLayout.getWidth());
                    maxy = Math.max(maxy, porty + labelLayout.getYpos() + labelLayout.getHeight());
                }
            }
            for (KEdge edge : node.getOutgoingEdges()) {
                maxv = this.processEdge(edge, edgeRouting);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
            for (KEdge edge : node.getIncomingEdges()) {
                if (edge.getSource().getParent() == layoutNode) continue;
                maxv = this.processEdge(edge, edgeRouting);
                maxx = Math.max(maxx, (float)maxv.x);
                maxy = Math.max(maxy, (float)maxv.y);
            }
        }
        if (edgeRouting == EdgeRouting.ORTHOGONAL) {
            for (KNode node : layoutNode.getChildren()) {
                for (KEdge edge : node.getOutgoingEdges()) {
                    this.generateJunctionPoints(edge);
                }
            }
        }
        if ((borderSpacing = ((Float)parentLayout.getProperty(LayoutOptions.BORDER_SPACING)).floatValue()) < 0.0f) {
            borderSpacing = 15.0f;
        }
        KInsets insets = parentLayout.getInsets();
        float newWidth = maxx + borderSpacing + insets.getLeft() + insets.getRight();
        float newHeight = maxy + borderSpacing + insets.getTop() + insets.getBottom();
        KimlUtil.resizeNode(layoutNode, newWidth, newHeight, true, true);
        progressMonitor.done();
    }

    private KVector processEdge(KEdge edge, EdgeRouting edgeRouting) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        boolean sameHierarchy = edge.getSource().getParent() == edge.getTarget().getParent();
        KVector maxv = new KVector();
        KVectorChain bendPoints = (KVectorChain)edgeLayout.getProperty(LayoutOptions.BEND_POINTS);
        if (bendPoints != null && bendPoints.size() >= 2) {
            edgeLayout.applyVectorChain(bendPoints);
        }
        if (sameHierarchy) {
            for (KPoint point : edgeLayout.getBendPoints()) {
                maxv.x = Math.max(maxv.x, (double)point.getX());
                maxv.y = Math.max(maxv.y, (double)point.getY());
            }
        }
        for (KLabel label : edge.getLabels()) {
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            KVector pos = (KVector)labelLayout.getProperty(LayoutOptions.POSITION);
            if (pos != null) {
                labelLayout.applyVector(pos);
            }
            if (!sameHierarchy) continue;
            maxv.x = Math.max(maxv.x, (double)(labelLayout.getXpos() + labelLayout.getWidth()));
            maxv.y = Math.max(maxv.y, (double)(labelLayout.getYpos() + labelLayout.getHeight()));
        }
        return maxv;
    }

    private void generateJunctionPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        KVectorChain junctionPoints = KimlUtil.determineJunctionPoints(edge);
        if (junctionPoints.isEmpty()) {
            edgeLayout.setProperty(LayoutOptions.JUNCTION_POINTS, null);
        } else {
            edgeLayout.setProperty(LayoutOptions.JUNCTION_POINTS, junctionPoints);
        }
    }
}

