/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import de.cau.cs.kieler.core.kgraph.EMapPropertyHolder;
import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KGraphFactory;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.kgraph.PersistentEntry;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.math.KVectorChain;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.IPropertyHolder;
import de.cau.cs.kieler.kiml.LayoutMetaDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutData;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.LayoutOptionProxy;
import de.cau.cs.kieler.kiml.util.selection.DefaultSelectionIterator;
import de.cau.cs.kieler.kiml.util.selection.SelectionIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;

public final class KimlUtil {
    public static final float DEFAULT_MIN_WIDTH = 20.0f;
    public static final float DEFAULT_MIN_HEIGHT = 20.0f;
    public static final Predicate<EMapPropertyHolder> PREDICATE_IS_KLAYOUTDATA = new Predicate<EMapPropertyHolder>(){

        public boolean apply(EMapPropertyHolder input) {
            return input instanceof KLayoutData;
        }
    };

    private KimlUtil() {
    }

    public static KNode createInitializedNode() {
        KNode layoutNode = KGraphFactory.eINSTANCE.createKNode();
        KShapeLayout layout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        layout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        layoutNode.getData().add((Object)layout);
        return layoutNode;
    }

    public static KEdge createInitializedEdge() {
        KEdge edge = KGraphFactory.eINSTANCE.createKEdge();
        KEdgeLayout edgeLayout = KLayoutDataFactory.eINSTANCE.createKEdgeLayout();
        edgeLayout.setSourcePoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edgeLayout.setTargetPoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edge.getData().add((Object)edgeLayout);
        return edge;
    }

    public static KPort createInitializedPort() {
        KPort port = KGraphFactory.eINSTANCE.createKPort();
        KShapeLayout portLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        portLayout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        port.getData().add((Object)portLayout);
        return port;
    }

    public static KLabel createInitializedLabel(KLabeledGraphElement element) {
        KLabel label = KGraphFactory.eINSTANCE.createKLabel();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        label.getData().add((Object)labelLayout);
        label.setText("");
        label.setParent(element);
        return label;
    }

    public static void validate(KNode graph) {
        KLayoutDataFactory layoutFactory = KLayoutDataFactory.eINSTANCE;
        Iterator contentIter = Iterators.concat(Lists.newArrayList((Object[])new KNode[]{graph}).iterator(), (Iterator)Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class));
        while (contentIter.hasNext()) {
            KPort targetPort;
            KPort sourcePort;
            EObject element = (EObject)contentIter.next();
            if (element instanceof KNode) {
                KNode node = (KNode)element;
                KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
                if (nodeLayout == null) {
                    nodeLayout = layoutFactory.createKShapeLayout();
                    node.getData().add((Object)nodeLayout);
                }
                if (nodeLayout.getInsets() != null) continue;
                nodeLayout.setInsets(layoutFactory.createKInsets());
                continue;
            }
            if (element instanceof KPort) {
                KPort port = (KPort)element;
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                if (portLayout != null) continue;
                port.getData().add((Object)layoutFactory.createKShapeLayout());
                continue;
            }
            if (element instanceof KLabel) {
                KLabel label = (KLabel)element;
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                if (labelLayout == null) {
                    label.getData().add((Object)layoutFactory.createKShapeLayout());
                }
                if (label.getText() != null) continue;
                label.setText("");
                continue;
            }
            if (!(element instanceof KEdge)) continue;
            KEdge edge = (KEdge)element;
            KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
            if (edgeLayout == null) {
                edgeLayout = layoutFactory.createKEdgeLayout();
                edge.getData().add((Object)edgeLayout);
            }
            if (edgeLayout.getSourcePoint() == null) {
                edgeLayout.setSourcePoint(layoutFactory.createKPoint());
            }
            if (edgeLayout.getTargetPoint() == null) {
                edgeLayout.setTargetPoint(layoutFactory.createKPoint());
            }
            if ((sourcePort = edge.getSourcePort()) != null && !sourcePort.getEdges().contains((Object)edge)) {
                sourcePort.getEdges().add((Object)edge);
            }
            if ((targetPort = edge.getTargetPort()) == null || targetPort.getEdges().contains((Object)edge)) continue;
            targetPort.getEdges().add((Object)edge);
        }
    }

    public static void createIdentifier(KGraphElement element) {
        KIdentifier identifier = (KIdentifier)element.getData(KIdentifier.class);
        if (identifier == null) {
            identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
            element.getData().add((Object)identifier);
        }
        identifier.setId(Integer.toString(element.hashCode()));
    }

    public static PortSide calcPortSide(KPort port, Direction direction) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        float nodeWidth = nodeLayout.getWidth();
        float nodeHeight = nodeLayout.getHeight();
        if (nodeWidth <= 0.0f && nodeHeight <= 0.0f) {
            return PortSide.UNDEFINED;
        }
        float xpos = portLayout.getXpos();
        float ypos = portLayout.getYpos();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0f) {
                    return PortSide.WEST;
                }
                if (!(xpos + portLayout.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0f) {
                    return PortSide.NORTH;
                }
                if (!(ypos + portLayout.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        float widthPercent = (xpos + portLayout.getWidth() / 2.0f) / nodeWidth;
        float heightPercent = (ypos + portLayout.getHeight() / 2.0f) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0f && widthPercent - heightPercent <= 0.0f) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0f && widthPercent - heightPercent >= 0.0f) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5f) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static float calcPortOffset(KPort port, PortSide side) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        switch (side) {
            case NORTH: {
                return -(portLayout.getYpos() + portLayout.getHeight());
            }
            case EAST: {
                return portLayout.getXpos() - nodeLayout.getWidth();
            }
            case SOUTH: {
                return portLayout.getYpos() - nodeLayout.getHeight();
            }
            case WEST: {
                return -(portLayout.getXpos() + portLayout.getWidth());
            }
        }
        return 0.0f;
    }

    public static KVector resizeNode(KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        Set sizeConstraint = (Set)nodeLayout.getProperty(LayoutOptions.SIZE_CONSTRAINT);
        if (sizeConstraint.isEmpty()) {
            return null;
        }
        float newWidth = 0.0f;
        float newHeight = 0.0f;
        if (sizeConstraint.contains((Object)SizeConstraint.PORTS)) {
            PortConstraints portConstraints = (PortConstraints)((Object)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS));
            float minNorth = 2.0f;
            float minEast = 2.0f;
            float minSouth = 2.0f;
            float minWest = 2.0f;
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(LayoutOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.DIRECTION));
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(LayoutOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide(port, direction);
                    portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                }
                if (portConstraints == PortConstraints.FIXED_POS) {
                    switch (portSide) {
                        case NORTH: {
                            minNorth = Math.max(minNorth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case EAST: {
                            minEast = Math.max(minEast, portLayout.getYpos() + portLayout.getHeight());
                            break;
                        }
                        case SOUTH: {
                            minSouth = Math.max(minSouth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case WEST: {
                            minWest = Math.max(minWest, portLayout.getYpos() + portLayout.getHeight());
                        }
                    }
                    continue;
                }
                switch (portSide) {
                    case NORTH: {
                        minNorth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case EAST: {
                        minEast += portLayout.getHeight() + 2.0f;
                        break;
                    }
                    case SOUTH: {
                        minSouth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case WEST: {
                        minWest += portLayout.getHeight() + 2.0f;
                    }
                }
            }
            newWidth = Math.max(minNorth, minSouth);
            newHeight = Math.max(minEast, minWest);
        }
        return KimlUtil.resizeNode(node, newWidth, newHeight, true, true);
    }

    public static KVector resizeNode(KNode node, float newWidth, float newHeight, boolean movePorts, boolean moveLabels) {
        KVector newSize;
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        Set sizeConstraint = (Set)nodeLayout.getProperty(LayoutOptions.SIZE_CONSTRAINT);
        KVector oldSize = new KVector((double)nodeLayout.getWidth(), (double)nodeLayout.getHeight());
        if (sizeConstraint.contains((Object)SizeConstraint.MINIMUM_SIZE)) {
            Set sizeOptions = (Set)nodeLayout.getProperty(LayoutOptions.SIZE_OPTIONS);
            float minWidth = ((Float)nodeLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue();
            float minHeight = ((Float)nodeLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue();
            if (sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minWidth <= 0.0f) {
                    minWidth = 20.0f;
                }
                if (minHeight <= 0.0f) {
                    minHeight = 20.0f;
                }
            }
            newSize = new KVector((double)Math.max(newWidth, minWidth), (double)Math.max(newHeight, minHeight));
        } else {
            newSize = new KVector((double)newWidth, (double)newHeight);
        }
        float widthRatio = (float)(newSize.x / oldSize.x);
        float heightRatio = (float)(newSize.y / oldSize.y);
        float widthDiff = (float)(newSize.x - oldSize.x);
        float heightDiff = (float)(newSize.y - oldSize.y);
        if (movePorts) {
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(LayoutOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.DIRECTION));
            boolean fixedPorts = nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(LayoutOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide(port, direction);
                    portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                }
                switch (portSide) {
                    case NORTH: {
                        if (fixedPorts) break;
                        portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        break;
                    }
                    case EAST: {
                        portLayout.setXpos(portLayout.getXpos() + widthDiff);
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        }
                        portLayout.setYpos(portLayout.getYpos() + heightDiff);
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                    }
                }
            }
        }
        nodeLayout.setSize((float)newSize.x, (float)newSize.y);
        if (moveLabels) {
            for (KLabel label : node.getLabels()) {
                float midy;
                float heightPercent;
                KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
                float midx = labelLayout.getXpos() + labelLayout.getWidth() / 2.0f;
                float widthPercent = midx / (float)oldSize.x;
                if (!(widthPercent + (heightPercent = (midy = labelLayout.getYpos() + labelLayout.getHeight() / 2.0f) / (float)oldSize.y) >= 1.0f)) continue;
                if (widthPercent - heightPercent > 0.0f && midy >= 0.0f) {
                    labelLayout.setXpos(labelLayout.getXpos() + widthDiff);
                    labelLayout.setYpos(labelLayout.getYpos() + heightDiff * heightPercent);
                    continue;
                }
                if (!(widthPercent - heightPercent < 0.0f) || !(midx >= 0.0f)) continue;
                labelLayout.setXpos(labelLayout.getXpos() + widthDiff * widthPercent);
                labelLayout.setYpos(labelLayout.getYpos() + heightDiff);
            }
        }
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, SizeConstraint.fixed());
        return new KVector((double)widthRatio, (double)heightRatio);
    }

    public static void applyConfiguredNodeScaling(KNode node) {
        KShapeLayout shapeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        float scalingFactor = ((Float)shapeLayout.getProperty(LayoutOptions.SCALE_FACTOR)).floatValue();
        if (scalingFactor == 1.0f) {
            return;
        }
        shapeLayout.setSize(scalingFactor * shapeLayout.getWidth(), scalingFactor * shapeLayout.getHeight());
        for (KGraphElement kge : Iterables.concat((Iterable)node.getPorts(), (Iterable)node.getLabels())) {
            KShapeLayout kgeLayout = (KShapeLayout)kge.getData(KShapeLayout.class);
            kgeLayout.setPos(scalingFactor * kgeLayout.getXpos(), scalingFactor * kgeLayout.getYpos());
            kgeLayout.setSize(scalingFactor * kgeLayout.getWidth(), scalingFactor * kgeLayout.getHeight());
            KVector anchor = (KVector)kgeLayout.getProperty(LayoutOptions.PORT_ANCHOR);
            if (anchor == null) continue;
            anchor.x *= (double)scalingFactor;
            anchor.y *= (double)scalingFactor;
        }
    }

    public static boolean isDescendant(KNode child, KNode parent) {
        KNode current = child;
        while (current.getParent() != null) {
            if ((current = current.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    public static KVector toAbsolute(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.add((double)(nodeLayout.getXpos() + insets.getLeft()), (double)(nodeLayout.getYpos() + insets.getTop()));
            node = node.getParent();
        }
        return point;
    }

    public static KVector toRelative(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.add((double)(-nodeLayout.getXpos() - insets.getLeft()), (double)(-nodeLayout.getYpos() - insets.getTop()));
            node = node.getParent();
        }
        return point;
    }

    public static void translate(KNode parent, float xoffset, float yoffset) {
        for (KNode child : parent.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)child.getData(KShapeLayout.class);
            nodeLayout.setXpos(nodeLayout.getXpos() + xoffset);
            nodeLayout.setYpos(nodeLayout.getYpos() + yoffset);
            for (KEdge edge : child.getOutgoingEdges()) {
                if (KimlUtil.isDescendant(edge.getTarget(), child)) continue;
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                KimlUtil.translate(edgeLayout.getSourcePoint(), xoffset, yoffset);
                for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                    KimlUtil.translate(bendPoint, xoffset, yoffset);
                }
                KimlUtil.translate(edgeLayout.getTargetPoint(), xoffset, yoffset);
                for (KLabel edgeLabel : edge.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)edgeLabel.getData(KShapeLayout.class);
                    labelLayout.setXpos(labelLayout.getXpos() + xoffset);
                    labelLayout.setYpos(labelLayout.getYpos() + yoffset);
                }
            }
        }
    }

    public static void translate(KPoint point, float xoffset, float yoffset) {
        point.setX(point.getX() + xoffset);
        point.setY(point.getY() + yoffset);
    }

    public static void setOption(KGraphData graphData, String id, String value) {
        Object obj;
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        LayoutOptionData optionData = dataService.getOptionData(id);
        if (optionData != null && (obj = optionData.parseValue(value)) != null) {
            graphData.setProperty((IProperty)optionData, obj);
        }
    }

    public static void persistDataElements(KNode graph) {
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof KGraphData)) continue;
            ((KGraphData)eObject).makePersistent();
        }
    }

    public static void loadDataElements(KNode graph, IProperty<?> ... knownProps) {
        KimlUtil.loadDataElements(graph, PREDICATE_IS_KLAYOUTDATA, false, knownProps);
    }

    public static void loadDataElements(KNode graph, boolean clearProperties, IProperty<?> ... knownProps) {
        KimlUtil.loadDataElements(graph, PREDICATE_IS_KLAYOUTDATA, clearProperties, knownProps);
    }

    public static KNode loadDataElements(KNode graph, Predicate<EMapPropertyHolder> handledTypes, IProperty<?> ... knownProps) {
        return KimlUtil.loadDataElements(graph, handledTypes, false, knownProps);
    }

    public static KNode loadDataElements(KNode graph, Predicate<EMapPropertyHolder> handledTypes, boolean clearProperties, IProperty<?> ... knownProps) {
        HashMap knowPropsMap = Maps.newHashMap();
        IProperty<?>[] iPropertyArray = knownProps;
        int n = knownProps.length;
        int n2 = 0;
        while (n2 < n) {
            IProperty<?> p = iPropertyArray[n2];
            knowPropsMap.put(p.getId(), p);
            ++n2;
        }
        LayoutMetaDataService dataService = LayoutMetaDataService.getInstance();
        PropertiesSkippingTreeIterator iterator = new PropertiesSkippingTreeIterator(graph, false);
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof EMapPropertyHolder) || !handledTypes.apply((Object)((EMapPropertyHolder)eObject))) continue;
            EMapPropertyHolder holder = (EMapPropertyHolder)eObject;
            if (clearProperties && holder.getProperties() != null) {
                holder.getProperties().clear();
            }
            for (PersistentEntry persistentEntry : holder.getPersistentEntries()) {
                KimlUtil.loadDataElement(dataService, (IPropertyHolder)holder, persistentEntry.getKey(), persistentEntry.getValue(), knowPropsMap);
            }
        }
        return graph;
    }

    public static void loadDataElement(LayoutMetaDataService dataService, IPropertyHolder propertyHolder, String id, String value) {
        Map empty = Collections.emptyMap();
        KimlUtil.loadDataElement(dataService, propertyHolder, id, value, empty);
    }

    public static void loadDataElement(LayoutMetaDataService dataService, IPropertyHolder propertyHolder, String id, String value, Map<String, ? extends IProperty<?>> knownProps) {
        if (id != null && value != null) {
            LayoutOptionData layoutOptionData = dataService.getOptionDataBySuffix(id);
            if (layoutOptionData != null) {
                Object layoutOptionValue = layoutOptionData.parseValue(value);
                if (layoutOptionValue != null) {
                    propertyHolder.setProperty((IProperty)layoutOptionData, layoutOptionValue);
                }
            } else if (knownProps.containsKey(id)) {
                Object parsed = KimlUtil.parseSimpleDatatypes(value);
                IProperty<?> unchecked = knownProps.get(id);
                propertyHolder.setProperty(unchecked, parsed);
            } else {
                LayoutOptionProxy.setProxyValue(propertyHolder, id, value);
            }
        }
    }

    private static Object parseSimpleDatatypes(String value) {
        try {
            return Float.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException2) {
                if (value.toLowerCase().equals(Boolean.FALSE.toString())) {
                    return false;
                }
                if (value.toLowerCase().equals(Boolean.TRUE.toString())) {
                    return true;
                }
                return value;
            }
        }
    }

    public static KVectorChain determineJunctionPoints(KEdge edge) {
        KVectorChain junctionPoints = new KVectorChain();
        HashMap pointsMap = Maps.newHashMap();
        pointsMap.put(edge, KimlUtil.getPoints(edge));
        ArrayList connectedPorts = Lists.newArrayListWithCapacity((int)2);
        if (edge.getSourcePort() != null) {
            connectedPorts.add(edge.getSourcePort());
        }
        if (edge.getTargetPort() != null) {
            connectedPorts.add(edge.getTargetPort());
        }
        for (KPort p : connectedPorts) {
            boolean reverse;
            KVector p1;
            LinkedList allConnectedEdges = Lists.newLinkedList();
            allConnectedEdges.addAll(p.getEdges());
            allConnectedEdges.remove(edge);
            if (allConnectedEdges.isEmpty()) continue;
            KVector[] thisPoints = (KVector[])pointsMap.get(edge);
            if (p == edge.getTargetPort()) {
                p1 = thisPoints[thisPoints.length - 1];
                reverse = true;
            } else {
                p1 = thisPoints[0];
                reverse = false;
            }
            int i = 1;
            while (i < thisPoints.length) {
                KVector p2 = reverse ? thisPoints[thisPoints.length - 1 - i] : thisPoints[i];
                Iterator allEdgeIter = allConnectedEdges.iterator();
                while (allEdgeIter.hasNext()) {
                    KEdge otherEdge = (KEdge)allEdgeIter.next();
                    KVector[] otherPoints = (KVector[])pointsMap.get(otherEdge);
                    if (otherPoints == null) {
                        otherPoints = KimlUtil.getPoints(otherEdge);
                        pointsMap.put(otherEdge, otherPoints);
                    }
                    if (otherPoints.length <= i) {
                        allEdgeIter.remove();
                        continue;
                    }
                    KVector p3 = reverse ? otherPoints[otherPoints.length - 1 - i] : otherPoints[i];
                    if (p2.x == p3.x && p2.y == p3.y) continue;
                    double dx3 = p3.x - p1.x;
                    double dy2 = p2.y - p1.y;
                    double dy3 = p3.y - p1.y;
                    double dx2 = p2.x - p1.x;
                    if (dx3 * dy2 == dy3 * dx2 && KimlUtil.signum(dx2) == KimlUtil.signum(dx3) && KimlUtil.signum(dy2) == KimlUtil.signum(dy3)) {
                        if (Math.abs(dx2) < Math.abs(dx3) || Math.abs(dy2) < Math.abs(dy3)) {
                            junctionPoints.add((Object)p2);
                        }
                    } else if (i > 1) {
                        junctionPoints.add((Object)p1);
                    }
                    allEdgeIter.remove();
                }
                p1 = p2;
                ++i;
            }
        }
        return junctionPoints;
    }

    private static int signum(double x) {
        if (x < 0.0) {
            return -1;
        }
        if (x > 0.0) {
            return 1;
        }
        return 0;
    }

    private static KVector[] getPoints(KEdge edge) {
        KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
        int n = edgeLayout.getBendPoints().size() + 2;
        KVector[] points = new KVector[n];
        points[0] = edgeLayout.getSourcePoint().createVector();
        ListIterator pointIter = edgeLayout.getBendPoints().listIterator();
        while (pointIter.hasNext()) {
            KPoint bendPoint = (KPoint)pointIter.next();
            points[pointIter.nextIndex()] = bendPoint.createVector();
        }
        points[n - 1] = edgeLayout.getTargetPoint().createVector();
        return points;
    }

    public static Iterator<KEdge> getConnectedEdges(Iterable<KEdge> kedges) {
        return Iterators.concat((Iterator)Iterators.transform(kedges.iterator(), (Function)new Function<KEdge, Iterator<KEdge>>(){

            public Iterator<KEdge> apply(KEdge kedge) {
                return KimlUtil.getConnectedEdges(kedge);
            }
        }));
    }

    public static Iterator<KEdge> getConnectedEdges(KEdge kedge) {
        return Iterators.filter(KimlUtil.getConnectedElements(kedge, false), KEdge.class);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge kedge, boolean addPorts) {
        DefaultSelectionIterator sourceSideIt = new DefaultSelectionIterator(kedge, addPorts, false);
        DefaultSelectionIterator targetSideIt = new DefaultSelectionIterator(kedge, addPorts, true);
        return KimlUtil.getConnectedElements(kedge, sourceSideIt, targetSideIt);
    }

    public static Iterator<KGraphElement> getConnectedElements(KEdge kedge, SelectionIterator sourceIterator, SelectionIterator targetIterator) {
        SelectionIterator targetSideIt;
        SelectionIterator sourceSideIt;
        UnmodifiableIterator kedgeIt = Iterators.singletonIterator((Object)kedge);
        HashSet visited = Sets.newHashSet();
        SelectionIterator selectionIterator = sourceSideIt = kedge.getSourcePort() == null ? null : sourceIterator;
        if (sourceSideIt != null) {
            sourceSideIt.attachVisitedSet(visited);
        }
        SelectionIterator selectionIterator2 = targetSideIt = kedge.getTargetPort() == null ? null : targetIterator;
        if (targetSideIt != null) {
            targetSideIt.attachVisitedSet(visited);
        }
        SelectionIterator connectedEdges = sourceSideIt == null ? targetSideIt : (targetSideIt == null ? sourceSideIt : Iterators.concat((Iterator)((Object)sourceSideIt), (Iterator)((Object)targetSideIt)));
        return connectedEdges == null ? kedgeIt : Iterators.concat((Iterator)kedgeIt, (Iterator)((Object)connectedEdges));
    }

    public static void configureDefaultsRecursively(KNode graph) {
        UnmodifiableIterator kgeIt = Iterators.filter((Iterator)graph.eAllContents(), KGraphElement.class);
        while (kgeIt.hasNext()) {
            KGraphElement kge = (KGraphElement)kgeIt.next();
            if (kge instanceof KNode) {
                KimlUtil.configureWithDefaultValues((KNode)kge);
                continue;
            }
            if (kge instanceof KPort) {
                KimlUtil.configureWithDefaultValues((KPort)kge);
                continue;
            }
            if (!(kge instanceof KEdge)) continue;
            KimlUtil.configureWithDefaultValues((KEdge)kge);
        }
    }

    public static void configureWithDefaultValues(KNode node) {
        Set nlp;
        Set sc;
        KShapeLayout sl = (KShapeLayout)node.getData(KShapeLayout.class);
        if (sl != null && (sc = (Set)sl.getProperty(LayoutOptions.SIZE_CONSTRAINT)).equals(SizeConstraint.fixed()) && sl.getWidth() == 0.0f && sl.getHeight() == 0.0f) {
            sl.setWidth(80.0f);
            sl.setHeight(80.0f);
        }
        KimlUtil.ensureLabel((KLabeledGraphElement)node);
        if (sl != null && (nlp = (Set)sl.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT)).equals(NodeLabelPlacement.fixed())) {
            sl.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, NodeLabelPlacement.insideCenter());
        }
    }

    public static void configureWithDefaultValues(KPort port) {
        KShapeLayout sl = (KShapeLayout)port.getData(KShapeLayout.class);
        if (sl != null && sl.getWidth() == 0.0f && sl.getHeight() == 0.0f) {
            sl.setWidth(5.0f);
            sl.setHeight(5.0f);
        }
        KimlUtil.ensureLabel((KLabeledGraphElement)port);
    }

    public static void configureWithDefaultValues(KEdge edge) {
        EdgeLabelPlacement elp;
        KLayoutData ld = (KLayoutData)edge.getData(KLayoutData.class);
        if (ld != null && (elp = (EdgeLabelPlacement)((Object)ld.getProperty(LayoutOptions.EDGE_LABEL_PLACEMENT))) == EdgeLabelPlacement.UNDEFINED) {
            ld.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
        }
    }

    private static void ensureLabel(KLabeledGraphElement klge) {
        KIdentifier id;
        if (klge.getLabels().isEmpty() && (id = (KIdentifier)klge.getData(KIdentifier.class)) != null && !Strings.isNullOrEmpty((String)id.getId())) {
            KLabel label = KimlUtil.createInitializedLabel(klge);
            label.setText(id.getId());
        }
    }

    private static class PropertiesSkippingTreeIterator
    extends AbstractTreeIterator<EObject> {
        private static final long serialVersionUID = 1L;

        public PropertiesSkippingTreeIterator(Object object, boolean includeRoot) {
            super(object, includeRoot);
        }

        protected Iterator<? extends EObject> getChildren(Object object) {
            Iterator iterator = ((EObject)object).eContents().iterator();
            if (iterator instanceof EContentsEList.FeatureIteratorImpl) {
                ((EContentsEList.FeatureIteratorImpl)iterator).filter(new EContentsEList.FeatureFilter(){

                    public boolean isIncluded(EStructuralFeature eStructuralFeature) {
                        if (eStructuralFeature.getContainerClass().equals(EMapPropertyHolder.class)) {
                            return eStructuralFeature.getFeatureID() != 0;
                        }
                        return true;
                    }
                });
            }
            return iterator;
        }
    }
}

