/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util.labelspacing;

import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.util.adapters.GraphAdapters;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelGroup;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelLocation;
import de.cau.cs.kieler.kiml.util.nodespacing.Rectangle;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import java.util.HashMap;
import java.util.Map;

public final class LabelSpaceCalculation {
    private LabelSpaceCalculation() {
    }

    public static Spacing.Insets calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing) {
        return LabelSpaceCalculation.calculateRequiredNodeLabelSpace(node, labelSpacing, new HashMap<LabelLocation, LabelGroup>(), new Spacing.Insets(node.getInsets()));
    }

    public static Spacing.Insets calculateRequiredNodeLabelSpace(GraphAdapters.NodeAdapter<?> node, double labelSpacing, Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, Spacing.Insets insets) {
        if (!node.getLabels().iterator().hasNext()) {
            return insets;
        }
        LabelLocation nodeLabelPlacement = LabelLocation.fromNodeLabelPlacement(node.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT));
        for (GraphAdapters.LabelAdapter<?> labelAdapter : node.getLabels()) {
            LabelLocation labelPlacement = LabelLocation.fromNodeLabelPlacement(labelAdapter.getProperty(LayoutOptions.NODE_LABEL_PLACEMENT));
            if (labelPlacement == LabelLocation.UNDEFINED) {
                labelPlacement = nodeLabelPlacement;
            }
            labelAdapter.setVolatileId(labelPlacement.ordinal());
            Rectangle boundingBox = LabelSpaceCalculation.retrieveLabelGroupsBoundingBox(labelGroupsBoundingBoxes, labelPlacement);
            boundingBox.width = Math.max(boundingBox.width, labelAdapter.getSize().x);
            boundingBox.height += labelAdapter.getSize().y + labelSpacing;
        }
        for (Map.Entry entry : labelGroupsBoundingBoxes.entrySet()) {
            Rectangle boundingBox = (Rectangle)entry.getValue();
            boundingBox.height -= labelSpacing;
            switch ((LabelLocation)((Object)entry.getKey())) {
                case IN_T_L: 
                case IN_T_C: 
                case IN_T_R: {
                    insets.top = Math.max(insets.top, boundingBox.height + labelSpacing);
                    break;
                }
                case IN_C_L: {
                    insets.left = Math.max(insets.left, boundingBox.width + labelSpacing);
                    break;
                }
                case IN_C_R: {
                    insets.right = Math.max(insets.right, boundingBox.width + labelSpacing);
                    break;
                }
                case IN_B_L: 
                case IN_B_C: 
                case IN_B_R: {
                    insets.bottom = Math.max(insets.bottom, boundingBox.height + labelSpacing);
                }
            }
        }
        return insets;
    }

    private static Rectangle retrieveLabelGroupsBoundingBox(Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes, LabelLocation location) {
        if (!labelGroupsBoundingBoxes.containsKey((Object)location)) {
            LabelGroup boundingBox = new LabelGroup();
            labelGroupsBoundingBoxes.put(location, boundingBox);
            return boundingBox;
        }
        return labelGroupsBoundingBoxes.get((Object)location);
    }
}

