/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util.nodespacing;

import com.google.common.collect.ImmutableList;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortAlignment;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.adapters.GraphAdapters;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelGroup;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelLocation;
import de.cau.cs.kieler.kiml.util.labelspacing.LabelSpaceCalculation;
import de.cau.cs.kieler.kiml.util.labelspacing.TextAlignment;
import de.cau.cs.kieler.kiml.util.nodespacing.LabelSide;
import de.cau.cs.kieler.kiml.util.nodespacing.Rectangle;
import de.cau.cs.kieler.kiml.util.nodespacing.Spacing;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;

public class LabelAndNodeSizeProcessor {
    public static final IProperty<Double> PORT_RATIO_OR_POSITION = new Property("portRatioOrPosition", (Object)0.0);

    public void process(GraphAdapters.GraphAdapter<?> layeredGraph) {
        double labelSpacing = layeredGraph.getProperty(LayoutOptions.LABEL_SPACING).doubleValue();
        for (GraphAdapters.NodeAdapter<?> node : layeredGraph.getNodes()) {
            NodeData data = new NodeData(node);
            data.labelSpacing = labelSpacing;
            data.portSpacing = node.getProperty(LayoutOptions.PORT_SPACING).doubleValue();
            PortLabelPlacement labelPlacement = node.getProperty(LayoutOptions.PORT_LABEL_PLACEMENT);
            boolean compoundNodeMode = node.isCompoundNode();
            for (GraphAdapters.PortAdapter<?> port : node.getPorts()) {
                this.placePortLabels(port, labelPlacement, compoundNodeMode, labelSpacing);
                this.calculateAndSetPortMargins(port);
            }
            this.calculatePortInformation(data, node.getProperty(LayoutOptions.SIZE_CONSTRAINT).contains((Object)SizeConstraint.PORT_LABELS));
            this.calculateRequiredPortLabelSpace(data);
            this.calculateRequiredNodeLabelSpace(data);
            this.resizeNode(data);
            this.placePorts(data);
            this.placeNodeLabels(data);
            Spacing.Insets nodeInsets = new Spacing.Insets(node.getInsets());
            nodeInsets.left = data.requiredNodeLabelSpace.left + data.requiredPortLabelSpace.left;
            nodeInsets.right = data.requiredNodeLabelSpace.right + data.requiredPortLabelSpace.right;
            nodeInsets.top = data.requiredNodeLabelSpace.top + data.requiredPortLabelSpace.top;
            nodeInsets.bottom = data.requiredNodeLabelSpace.bottom + data.requiredPortLabelSpace.bottom;
            node.setInsets(nodeInsets);
        }
    }

    private void placePortLabels(GraphAdapters.PortAdapter<?> port, PortLabelPlacement placement, boolean compoundNodeMode, double labelSpacing) {
        if (placement.equals((Object)PortLabelPlacement.INSIDE)) {
            this.placePortLabelsInside(port, compoundNodeMode, labelSpacing);
        } else if (placement.equals((Object)PortLabelPlacement.OUTSIDE)) {
            this.placePortLabelsOutside(port, labelSpacing);
        }
    }

    private void placePortLabelsInside(GraphAdapters.PortAdapter<?> port, boolean compoundNodeMode, double labelSpacing) {
        ImmutableList labels = ImmutableList.copyOf(port.getLabels());
        if (labels.isEmpty()) {
            return;
        }
        double y = 0.0;
        switch (port.getSide()) {
            case EAST: 
            case WEST: {
                y = compoundNodeMode && port.hasCompoundConnections() ? port.getSize().y : (port.getSize().y - ((GraphAdapters.LabelAdapter)labels.get((int)0)).getSize().y) / 2.0 - labelSpacing;
                break;
            }
            case NORTH: {
                y = port.getSize().y;
                break;
            }
            case SOUTH: {
                y = 0.0;
            }
        }
        if (port.getSide() == PortSide.SOUTH) {
            labels = labels.reverse();
        }
        for (GraphAdapters.LabelAdapter<?> label : port.getLabels()) {
            KVector position = new KVector(port.getPosition());
            switch (port.getSide()) {
                case WEST: {
                    position.x = port.getSize().x + labelSpacing;
                    position.y = y + labelSpacing;
                    y += labelSpacing + label.getSize().y;
                    break;
                }
                case EAST: {
                    position.x = -label.getSize().x - labelSpacing;
                    position.y = y + labelSpacing;
                    y += labelSpacing + label.getSize().y;
                    break;
                }
                case NORTH: {
                    position.x = (port.getSize().x - label.getSize().x) / 2.0;
                    position.y = y + labelSpacing;
                    y += labelSpacing + label.getSize().y;
                    break;
                }
                case SOUTH: {
                    position.x = (port.getSize().x - label.getSize().x) / 2.0;
                    position.y = y - labelSpacing - label.getSize().y;
                    y -= labelSpacing + label.getSize().y;
                }
            }
            label.setPosition(position);
        }
    }

    private void placePortLabelsOutside(GraphAdapters.PortAdapter<?> port, double labelSpacing) {
        ImmutableList labels = ImmutableList.copyOf(port.getLabels());
        if (labels.isEmpty()) {
            return;
        }
        LabelSide labelSide = ((GraphAdapters.LabelAdapter)labels.get(0)).getSide();
        labelSide = labelSide == LabelSide.UNKNOWN ? LabelSide.BELOW : labelSide;
        double y = 0.0;
        switch (port.getSide()) {
            case EAST: 
            case WEST: {
                if (labelSide != LabelSide.BELOW) break;
                y = port.getSize().y;
                break;
            }
            case SOUTH: {
                y = port.getSize().y;
            }
        }
        if (port.getSide() == PortSide.NORTH || labelSide == LabelSide.ABOVE) {
            labels = labels.reverse();
        }
        for (GraphAdapters.LabelAdapter label : labels) {
            KVector position = new KVector(label.getPosition());
            if (labelSide == LabelSide.ABOVE) {
                switch (port.getSide()) {
                    case WEST: {
                        position.x = -label.getSize().x - labelSpacing;
                        position.y = y - labelSpacing - label.getSize().y;
                        y -= labelSpacing + label.getSize().y;
                        break;
                    }
                    case EAST: {
                        position.x = port.getSize().x + labelSpacing;
                        position.y = y - labelSpacing - label.getSize().y;
                        y -= labelSpacing + label.getSize().y;
                        break;
                    }
                    case NORTH: {
                        position.x = -label.getSize().x - labelSpacing;
                        position.y = y - labelSpacing - label.getSize().y;
                        y -= labelSpacing + label.getSize().y;
                        break;
                    }
                    case SOUTH: {
                        position.x = -label.getSize().x - labelSpacing;
                        position.y = y + labelSpacing;
                        y += labelSpacing + label.getSize().y;
                    }
                }
            } else {
                switch (port.getSide()) {
                    case WEST: {
                        position.x = -label.getSize().x - labelSpacing;
                        position.y = y + labelSpacing;
                        y += labelSpacing + label.getSize().y;
                        break;
                    }
                    case EAST: {
                        position.x = port.getSize().x + labelSpacing;
                        position.y = y + labelSpacing;
                        y += labelSpacing + label.getSize().y;
                        break;
                    }
                    case NORTH: {
                        position.x = port.getSize().x + labelSpacing;
                        position.y = y - labelSpacing - label.getSize().y;
                        y -= labelSpacing + label.getSize().y;
                        break;
                    }
                    case SOUTH: {
                        position.x = port.getSize().x + labelSpacing;
                        position.y = y + labelSpacing;
                        y += labelSpacing + label.getSize().y;
                    }
                }
            }
            label.setPosition(position);
        }
    }

    private void calculateAndSetPortMargins(GraphAdapters.PortAdapter<?> port) {
        Iterable<GraphAdapters.LabelAdapter<?>> labels = port.getLabels();
        if (labels.iterator().hasNext()) {
            Rectangle portBox = new Rectangle(0.0, 0.0, port.getSize().x, port.getSize().y);
            for (GraphAdapters.LabelAdapter<?> label : labels) {
                Rectangle labelBox = new Rectangle(label.getPosition().x, label.getPosition().y, label.getSize().x, label.getSize().y);
                portBox.union(labelBox);
            }
            Spacing.Margins margin = new Spacing.Margins(port.getMargin());
            margin.top = -portBox.y;
            margin.bottom = portBox.y + portBox.height - port.getSize().y;
            margin.left = -portBox.x;
            margin.right = portBox.x + portBox.width - port.getSize().x;
            port.setMargin(margin);
        }
    }

    private void calculatePortInformation(NodeData data, boolean accountForLabels) {
        PortSide side;
        if (!data.node.getPorts().iterator().hasNext()) {
            return;
        }
        for (GraphAdapters.PortAdapter<?> port : data.node.getPorts()) {
            int side2;
            int n = side2 = port.getSide().ordinal();
            data.portsCount[n] = data.portsCount[n] + 1;
            switch (port.getSide()) {
                case EAST: 
                case WEST: {
                    int n2 = side2;
                    data.portUsedSpace[n2] = data.portUsedSpace[n2] + (port.getSize().y + (accountForLabels ? port.getMargin().bottom + port.getMargin().top : 0.0));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    int n3 = side2;
                    data.portUsedSpace[n3] = data.portUsedSpace[n3] + (port.getSize().x + (accountForLabels ? port.getMargin().left + port.getMargin().right : 0.0));
                }
            }
        }
        PortAlignment portAlignment = data.node.getProperty(LayoutOptions.PORT_ALIGNMENT);
        portAlignment = portAlignment == PortAlignment.UNDEFINED ? PortAlignment.JUSTIFIED : portAlignment;
        data.portAlignment[PortSide.NORTH.ordinal()] = data.node.getProperty(LayoutOptions.PORT_ALIGNMENT_NORTH);
        data.portAlignment[PortSide.SOUTH.ordinal()] = data.node.getProperty(LayoutOptions.PORT_ALIGNMENT_SOUTH);
        data.portAlignment[PortSide.WEST.ordinal()] = data.node.getProperty(LayoutOptions.PORT_ALIGNMENT_WEST);
        data.portAlignment[PortSide.EAST.ordinal()] = data.node.getProperty(LayoutOptions.PORT_ALIGNMENT_EAST);
        PortSide[] portSideArray = PortSide.values();
        int n = portSideArray.length;
        int n4 = 0;
        while (n4 < n) {
            side = portSideArray[n4];
            data.portAlignment[side.ordinal()] = data.portAlignment[side.ordinal()] == PortAlignment.UNDEFINED ? portAlignment : data.portAlignment[side.ordinal()];
            ++n4;
        }
        data.hasAdditionalPortSpace = data.node.getProperty(LayoutOptions.ADDITIONAL_PORT_SPACE) != null;
        portSideArray = PortSide.values();
        n = portSideArray.length;
        n4 = 0;
        while (n4 < n) {
            side = portSideArray[n4];
            data.portGapsCount[side.ordinal()] = data.portsCount[side.ordinal()] == 1 ? 2 : (!data.hasAdditionalPortSpace && data.portAlignment[side.ordinal()] == PortAlignment.JUSTIFIED ? data.portsCount[side.ordinal()] + 1 : data.portsCount[side.ordinal()] - 1);
            ++n4;
        }
    }

    private void calculateRequiredPortLabelSpace(NodeData data) {
        for (GraphAdapters.PortAdapter<?> port : data.node.getPorts()) {
            switch (port.getSide()) {
                case WEST: {
                    data.requiredPortLabelSpace.left = Math.max(data.requiredPortLabelSpace.left, port.getMargin().right);
                    break;
                }
                case EAST: {
                    data.requiredPortLabelSpace.right = Math.max(data.requiredPortLabelSpace.right, port.getMargin().left);
                    break;
                }
                case NORTH: {
                    data.requiredPortLabelSpace.top = Math.max(data.requiredPortLabelSpace.top, port.getMargin().bottom);
                    break;
                }
                case SOUTH: {
                    data.requiredPortLabelSpace.bottom = Math.max(data.requiredPortLabelSpace.bottom, port.getMargin().top);
                }
            }
        }
    }

    private void resizeNode(NodeData data) {
        KVector nodeSize = data.node.getSize();
        KVector originalNodeSize = new KVector(nodeSize);
        EnumSet<SizeConstraint> sizeConstraint = data.node.getProperty(LayoutOptions.SIZE_CONSTRAINT);
        EnumSet<SizeOptions> sizeOptions = data.node.getProperty(LayoutOptions.SIZE_OPTIONS);
        PortConstraints portConstraints = data.node.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        boolean accountForLabels = sizeConstraint.contains((Object)SizeConstraint.PORT_LABELS);
        if (sizeConstraint.isEmpty()) {
            return;
        }
        nodeSize.x = 0.0;
        nodeSize.y = 0.0;
        KVector minSizeForPorts = null;
        switch (portConstraints) {
            case FREE: 
            case FIXED_SIDE: 
            case FIXED_ORDER: {
                minSizeForPorts = this.calculatePortSpaceRequirements(data, data.portSpacing, accountForLabels);
                break;
            }
            case FIXED_RATIO: {
                minSizeForPorts = new KVector(originalNodeSize);
                break;
            }
            case FIXED_POS: {
                minSizeForPorts = this.calculateMinNodeSizeForFixedPorts(data.node, accountForLabels);
            }
        }
        if (sizeConstraint.contains((Object)SizeConstraint.PORTS)) {
            if (minSizeForPorts != null) {
                nodeSize.x = Math.max(nodeSize.x, minSizeForPorts.x);
                nodeSize.y = Math.max(nodeSize.y, minSizeForPorts.y);
            }
            if (accountForLabels) {
                nodeSize.x = Math.max(nodeSize.x, data.requiredPortLabelSpace.left + data.requiredPortLabelSpace.right + data.portSpacing);
                nodeSize.y = Math.max(nodeSize.y, data.requiredPortLabelSpace.top + data.requiredPortLabelSpace.bottom + data.portSpacing);
            }
        }
        if (sizeConstraint.contains((Object)SizeConstraint.NODE_LABELS) && data.node.getLabels().iterator().hasNext()) {
            this.enlargeNodeSizeForLabels(data, data.labelSpacing, nodeSize);
        }
        if (sizeConstraint.contains((Object)SizeConstraint.MINIMUM_SIZE)) {
            double minWidth = data.node.getProperty(LayoutOptions.MIN_WIDTH).doubleValue();
            double minHeight = data.node.getProperty(LayoutOptions.MIN_HEIGHT).doubleValue();
            if (sizeOptions.contains((Object)SizeOptions.DEFAULT_MINIMUM_SIZE)) {
                if (minWidth <= 0.0) {
                    minWidth = 20.0;
                }
                if (minHeight <= 0.0) {
                    minHeight = 20.0;
                }
            }
            if (sizeOptions.contains((Object)SizeOptions.MINIMUM_SIZE_ACCOUNTS_FOR_INSETS)) {
                if (minWidth > 0.0) {
                    nodeSize.x = Math.max(nodeSize.x, minWidth + data.requiredPortLabelSpace.left + data.requiredPortLabelSpace.right);
                }
                if (minHeight > 0.0) {
                    nodeSize.y = Math.max(nodeSize.y, minHeight + data.requiredPortLabelSpace.top + data.requiredPortLabelSpace.bottom);
                }
            } else {
                if (minWidth > 0.0) {
                    nodeSize.x = Math.max(nodeSize.x, minWidth);
                }
                if (minHeight > 0.0) {
                    nodeSize.y = Math.max(nodeSize.y, minHeight);
                }
            }
        }
        data.node.setSize(nodeSize);
    }

    private void enlargeNodeSizeForLabels(NodeData data, double labelSpacing, KVector nodeSize) {
        double sumHeightOusideLeft = 0.0;
        double sumHeightOusideRight = 0.0;
        double sumWidthOutsideTop = 0.0;
        double sumWidthOutsideBottom = 0.0;
        double maxHeightInsideCenter = 0.0;
        double sumWidthInsideTop = 0.0;
        double sumWidthInsideCenter = 0.0;
        double sumWidthInsideBottom = 0.0;
        for (Map.Entry<LabelLocation, LabelGroup> entry : data.labelGroupsBoundingBoxes.entrySet()) {
            Rectangle boundingBox = entry.getValue();
            switch (entry.getKey()) {
                case IN_T_L: 
                case IN_T_C: 
                case IN_T_R: {
                    sumWidthInsideTop += boundingBox.width + labelSpacing;
                    break;
                }
                case IN_C_L: 
                case IN_C_C: 
                case IN_C_R: {
                    sumWidthInsideCenter += boundingBox.width + labelSpacing;
                    maxHeightInsideCenter = Math.max(maxHeightInsideCenter, boundingBox.height + labelSpacing);
                    break;
                }
                case IN_B_L: 
                case IN_B_C: 
                case IN_B_R: {
                    sumWidthInsideBottom += boundingBox.width + labelSpacing;
                    break;
                }
                case OUT_T_L: 
                case OUT_T_C: 
                case OUT_T_R: {
                    sumWidthOutsideTop += boundingBox.width + labelSpacing;
                    break;
                }
                case OUT_B_L: 
                case OUT_B_C: 
                case OUT_B_R: {
                    sumWidthOutsideBottom += boundingBox.width + labelSpacing;
                    break;
                }
                case OUT_L_T: 
                case OUT_L_C: 
                case OUT_L_B: {
                    sumHeightOusideLeft += boundingBox.height + labelSpacing;
                    break;
                }
                case OUT_R_T: 
                case OUT_R_C: 
                case OUT_R_B: {
                    sumHeightOusideRight += boundingBox.height + labelSpacing;
                }
            }
        }
        sumHeightOusideLeft -= labelSpacing;
        sumHeightOusideRight -= labelSpacing;
        sumWidthOutsideTop -= labelSpacing;
        sumWidthOutsideBottom -= labelSpacing;
        sumWidthInsideTop += sumWidthInsideTop != 0.0 ? labelSpacing : 0.0;
        sumWidthInsideCenter += sumWidthInsideCenter != 0.0 ? labelSpacing : 0.0;
        sumWidthInsideBottom += sumWidthInsideBottom != 0.0 ? labelSpacing : 0.0;
        double minHeightInside = data.requiredNodeLabelSpace.top + maxHeightInsideCenter + data.requiredNodeLabelSpace.bottom;
        minHeightInside += minHeightInside != 0.0 ? labelSpacing : 0.0;
        nodeSize.x = Math.max(nodeSize.x, sumWidthOutsideTop);
        nodeSize.x = Math.max(nodeSize.x, sumWidthInsideTop);
        nodeSize.x = Math.max(nodeSize.x, sumWidthInsideCenter);
        nodeSize.x = Math.max(nodeSize.x, sumWidthInsideBottom);
        nodeSize.x = Math.max(nodeSize.x, sumWidthOutsideBottom);
        nodeSize.y = Math.max(nodeSize.y, sumHeightOusideLeft);
        nodeSize.y = Math.max(nodeSize.y, minHeightInside);
        nodeSize.y = Math.max(nodeSize.y, sumHeightOusideRight);
    }

    private KVector calculatePortSpaceRequirements(NodeData data, double portSpacing, boolean accountForLabels) {
        double additionalHeight;
        double additionalWidth;
        if (data.hasAdditionalPortSpace) {
            Spacing.Margins additionalPortSpace = data.node.getProperty(LayoutOptions.ADDITIONAL_PORT_SPACE);
            additionalWidth = additionalPortSpace.left + additionalPortSpace.right;
            additionalHeight = additionalPortSpace.top + additionalPortSpace.bottom;
        } else {
            additionalWidth = portSpacing * 2.0;
            additionalHeight = portSpacing * 2.0;
        }
        double requiredWidth = Math.max(data.portsCount[PortSide.NORTH.ordinal()] > 0 ? additionalWidth + (double)data.portGapsCount[PortSide.NORTH.ordinal()] * portSpacing + data.portUsedSpace[PortSide.NORTH.ordinal()] : 0.0, data.portsCount[PortSide.SOUTH.ordinal()] > 0 ? additionalWidth + (double)data.portGapsCount[PortSide.SOUTH.ordinal()] * portSpacing + data.portUsedSpace[PortSide.SOUTH.ordinal()] : 0.0);
        double requiredHeight = Math.max(data.portsCount[PortSide.WEST.ordinal()] > 0 ? additionalHeight + (double)data.portGapsCount[PortSide.WEST.ordinal()] * portSpacing + data.portUsedSpace[PortSide.WEST.ordinal()] : 0.0, data.portsCount[PortSide.EAST.ordinal()] > 0 ? additionalHeight + (double)data.portGapsCount[PortSide.EAST.ordinal()] * portSpacing + data.portUsedSpace[PortSide.EAST.ordinal()] : 0.0);
        return new KVector(requiredWidth, requiredHeight);
    }

    private KVector calculateMinNodeSizeForFixedPorts(GraphAdapters.NodeAdapter<?> node, boolean accountForLabels) {
        assert (node.getProperty(LayoutOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS);
        KVector result = new KVector();
        for (GraphAdapters.PortAdapter<?> port : node.getPorts()) {
            switch (port.getSide()) {
                case EAST: 
                case WEST: {
                    result.y = Math.max(result.y, port.getPosition().y + port.getSize().y + (accountForLabels ? port.getMargin().bottom : 0.0));
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    result.x = Math.max(result.x, port.getPosition().x + port.getSize().x + (accountForLabels ? port.getMargin().right : 0.0));
                }
            }
        }
        return result;
    }

    private void placePorts(NodeData data) {
        if (!data.node.getPorts().iterator().hasNext()) {
            return;
        }
        PortConstraints portConstraints = data.node.getProperty(LayoutOptions.PORT_CONSTRAINTS);
        if (portConstraints == PortConstraints.FIXED_POS) {
            this.placeFixedPosNodePorts(data.node);
        } else if (portConstraints == PortConstraints.FIXED_RATIO) {
            this.placeFixedRatioNodePorts(data.node);
        } else if (data.node.getProperty(LayoutOptions.HYPERNODE).booleanValue() || data.node.getSize().x == 0.0 && data.node.getSize().y == 0.0) {
            this.placeHypernodePorts(data.node);
        } else {
            this.placeNodePorts(data);
        }
    }

    private void placeFixedPosNodePorts(GraphAdapters.NodeAdapter<?> node) {
        KVector nodeSize = node.getSize();
        for (GraphAdapters.PortAdapter<?> port : node.getPorts()) {
            Float portOffset = port.getProperty(LayoutOptions.OFFSET);
            if (portOffset == null) {
                portOffset = Float.valueOf(0.0f);
            }
            KVector position = new KVector(port.getPosition());
            switch (port.getSide()) {
                case WEST: {
                    position.x = -port.getSize().x - (double)portOffset.floatValue();
                    break;
                }
                case EAST: {
                    position.x = nodeSize.x + (double)portOffset.floatValue();
                    break;
                }
                case NORTH: {
                    position.y = -port.getSize().y - (double)portOffset.floatValue();
                    break;
                }
                case SOUTH: {
                    position.y = nodeSize.y + (double)portOffset.floatValue();
                }
            }
            port.setPosition(position);
        }
    }

    private void placeFixedRatioNodePorts(GraphAdapters.NodeAdapter<?> node) {
        KVector nodeSize = node.getSize();
        for (GraphAdapters.PortAdapter<?> port : node.getPorts()) {
            Float portOffset = port.getProperty(LayoutOptions.OFFSET);
            if (portOffset == null) {
                portOffset = Float.valueOf(0.0f);
            }
            switch (port.getSide()) {
                case WEST: {
                    port.getPosition().y = nodeSize.y * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().x = -port.getSize().x - (double)portOffset.floatValue();
                    break;
                }
                case EAST: {
                    port.getPosition().y = nodeSize.y * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().x = nodeSize.x + (double)portOffset.floatValue();
                    break;
                }
                case NORTH: {
                    port.getPosition().x = nodeSize.x * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().y = -port.getSize().y - (double)portOffset.floatValue();
                    break;
                }
                case SOUTH: {
                    port.getPosition().x = nodeSize.x * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().y = nodeSize.y + (double)portOffset.floatValue();
                }
            }
            switch (port.getSide()) {
                case WEST: {
                    port.getPosition().y = nodeSize.y * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().x = -port.getSize().x - (double)portOffset.floatValue();
                    break;
                }
                case EAST: {
                    port.getPosition().y = nodeSize.y * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().x = nodeSize.x + (double)portOffset.floatValue();
                    break;
                }
                case NORTH: {
                    port.getPosition().x = nodeSize.x * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().y = -port.getSize().y - (double)portOffset.floatValue();
                    break;
                }
                case SOUTH: {
                    port.getPosition().x = nodeSize.x * port.getProperty(PORT_RATIO_OR_POSITION);
                    port.getPosition().y = nodeSize.y + (double)portOffset.floatValue();
                }
            }
        }
    }

    private void placeNodePorts(NodeData data) {
        KVector nodeSize = data.node.getSize();
        boolean accountForLabels = data.node.getProperty(LayoutOptions.SIZE_CONSTRAINT).contains((Object)SizeConstraint.PORT_LABELS);
        this.computePortPlacementData(data);
        for (GraphAdapters.PortAdapter<?> port : data.node.getPorts()) {
            Float portOffset = port.getProperty(LayoutOptions.OFFSET);
            if (portOffset == null) {
                portOffset = Float.valueOf(0.0f);
            }
            KVector portSize = port.getSize();
            Spacing.Margins portMargins = port.getMargin();
            KVector position = new KVector(port.getPosition());
            switch (port.getSide()) {
                case WEST: {
                    position.x = -portSize.x - (double)portOffset.floatValue();
                    position.y = data.westY - portSize.y - (accountForLabels ? portMargins.bottom : 0.0);
                    data.westY = data.westY - (data.getPortGapsSize(PortSide.WEST) + portSize.y + (accountForLabels ? portMargins.top + portMargins.bottom : 0.0));
                    break;
                }
                case EAST: {
                    position.x = nodeSize.x + (double)portOffset.floatValue();
                    position.y = data.eastY + (accountForLabels ? portMargins.top : 0.0);
                    data.eastY = data.eastY + (data.getPortGapsSize(PortSide.EAST) + portSize.y + (accountForLabels ? portMargins.top + portMargins.bottom : 0.0));
                    break;
                }
                case NORTH: {
                    position.x = data.northX + (accountForLabels ? portMargins.left : 0.0);
                    position.y = -port.getSize().y - (double)portOffset.floatValue();
                    data.northX = data.northX + (data.getPortGapsSize(PortSide.NORTH) + portSize.x + (accountForLabels ? portMargins.left + portMargins.right : 0.0));
                    break;
                }
                case SOUTH: {
                    position.x = data.southX - portSize.x - (accountForLabels ? portMargins.right : 0.0);
                    position.y = nodeSize.y + (double)portOffset.floatValue();
                    data.southX = data.southX - (data.getPortGapsSize(PortSide.SOUTH) + portSize.x + (accountForLabels ? portMargins.left + portMargins.right : 0.0));
                }
            }
            port.setPosition(position);
        }
    }

    private void computePortPlacementData(NodeData data) {
        double usedPortSpace;
        KVector nodeSize = data.node.getSize();
        Spacing.Margins additionalPortSpace = data.hasAdditionalPortSpace ? data.node.getProperty(LayoutOptions.ADDITIONAL_PORT_SPACE) : new Spacing.Margins(data.portSpacing, data.portSpacing, data.portSpacing, data.portSpacing);
        double usableSpaceNorth = nodeSize.x;
        if (data.hasAdditionalPortSpace || data.portAlignment[PortSide.NORTH.ordinal()] != PortAlignment.JUSTIFIED) {
            usableSpaceNorth -= additionalPortSpace.left + additionalPortSpace.right;
        }
        double usableSpaceSouth = nodeSize.x;
        if (data.hasAdditionalPortSpace || data.portAlignment[PortSide.SOUTH.ordinal()] != PortAlignment.JUSTIFIED) {
            usableSpaceSouth -= additionalPortSpace.left + additionalPortSpace.right;
        }
        double usableSpaceWest = nodeSize.y;
        if (data.hasAdditionalPortSpace || data.portAlignment[PortSide.WEST.ordinal()] != PortAlignment.JUSTIFIED) {
            usableSpaceWest -= additionalPortSpace.top + additionalPortSpace.bottom;
        }
        double usableSpaceEast = nodeSize.y;
        if (data.hasAdditionalPortSpace || data.portAlignment[PortSide.EAST.ordinal()] != PortAlignment.JUSTIFIED) {
            usableSpaceEast -= additionalPortSpace.top + additionalPortSpace.bottom;
        }
        if (data.getPortAlignment(PortSide.NORTH) == PortAlignment.JUSTIFIED) {
            data.portGapsSize[PortSide.NORTH.ordinal()] = (usableSpaceNorth - data.getPortUsedSpace(PortSide.NORTH)) / (double)data.getPortGapsCount(PortSide.NORTH);
            data.northX = data.hasAdditionalPortSpace ? additionalPortSpace.left + (data.getPortsCount(PortSide.NORTH) == 1 ? data.portGapsSize[PortSide.NORTH.ordinal()] : 0.0) : data.portGapsSize[PortSide.NORTH.ordinal()];
        } else {
            data.portGapsSize[PortSide.NORTH.ordinal()] = data.portSpacing;
            usedPortSpace = data.getPortUsedSpace(PortSide.NORTH) + data.portGapsSize[PortSide.NORTH.ordinal()] * (double)(data.getPortsCount(PortSide.NORTH) - 1);
            switch (data.getPortAlignment(PortSide.NORTH)) {
                case BEGIN: {
                    data.northX = additionalPortSpace.left;
                    break;
                }
                case CENTER: {
                    data.northX = additionalPortSpace.left + (usableSpaceNorth - usedPortSpace) / 2.0;
                    break;
                }
                case END: {
                    data.northX = nodeSize.x - usedPortSpace - additionalPortSpace.right;
                }
            }
        }
        if (data.getPortAlignment(PortSide.SOUTH) == PortAlignment.JUSTIFIED) {
            data.portGapsSize[PortSide.SOUTH.ordinal()] = (usableSpaceSouth - data.getPortUsedSpace(PortSide.SOUTH)) / (double)data.getPortGapsCount(PortSide.SOUTH);
            data.southX = nodeSize.x - (data.hasAdditionalPortSpace ? additionalPortSpace.right + (data.getPortsCount(PortSide.SOUTH) == 1 ? data.portGapsSize[PortSide.SOUTH.ordinal()] : 0.0) : data.portGapsSize[PortSide.SOUTH.ordinal()]);
        } else {
            data.portGapsSize[PortSide.SOUTH.ordinal()] = data.portSpacing;
            usedPortSpace = data.getPortUsedSpace(PortSide.SOUTH) + data.portGapsSize[PortSide.SOUTH.ordinal()] * (double)(data.getPortsCount(PortSide.SOUTH) - 1);
            switch (data.getPortAlignment(PortSide.SOUTH)) {
                case BEGIN: {
                    data.southX = usedPortSpace + additionalPortSpace.left;
                    break;
                }
                case CENTER: {
                    data.southX = nodeSize.x - (usableSpaceSouth - usedPortSpace) / 2.0 - additionalPortSpace.right;
                    break;
                }
                case END: {
                    data.southX = nodeSize.x - additionalPortSpace.right;
                }
            }
        }
        if (data.getPortAlignment(PortSide.WEST) == PortAlignment.JUSTIFIED) {
            data.portGapsSize[PortSide.WEST.ordinal()] = (usableSpaceWest - data.getPortUsedSpace(PortSide.WEST)) / (double)data.getPortGapsCount(PortSide.WEST);
            data.westY = nodeSize.y - (data.hasAdditionalPortSpace ? additionalPortSpace.bottom + (data.getPortsCount(PortSide.WEST) == 1 ? data.portGapsSize[PortSide.WEST.ordinal()] : 0.0) : data.portGapsSize[PortSide.WEST.ordinal()]);
        } else {
            data.portGapsSize[PortSide.WEST.ordinal()] = data.portSpacing;
            usedPortSpace = data.getPortUsedSpace(PortSide.WEST) + data.portGapsSize[PortSide.WEST.ordinal()] * (double)(data.getPortsCount(PortSide.WEST) - 1);
            switch (data.getPortAlignment(PortSide.WEST)) {
                case BEGIN: {
                    data.westY = usedPortSpace + additionalPortSpace.top;
                    break;
                }
                case CENTER: {
                    data.westY = nodeSize.y - (usableSpaceWest - usedPortSpace) / 2.0 - additionalPortSpace.bottom;
                    break;
                }
                case END: {
                    data.westY = nodeSize.y - additionalPortSpace.bottom;
                }
            }
        }
        if (data.getPortAlignment(PortSide.EAST) == PortAlignment.JUSTIFIED) {
            data.portGapsSize[PortSide.EAST.ordinal()] = (usableSpaceEast - data.getPortUsedSpace(PortSide.EAST)) / (double)data.getPortGapsCount(PortSide.EAST);
            data.eastY = data.hasAdditionalPortSpace ? additionalPortSpace.top + (data.getPortsCount(PortSide.EAST) == 1 ? data.portGapsSize[PortSide.EAST.ordinal()] : 0.0) : data.portGapsSize[PortSide.EAST.ordinal()];
        } else {
            data.portGapsSize[PortSide.EAST.ordinal()] = data.portSpacing;
            usedPortSpace = data.getPortUsedSpace(PortSide.EAST) + data.portGapsSize[PortSide.EAST.ordinal()] * (double)(data.getPortsCount(PortSide.EAST) - 1);
            switch (data.getPortAlignment(PortSide.EAST)) {
                case BEGIN: {
                    data.eastY = additionalPortSpace.top;
                    break;
                }
                case CENTER: {
                    data.eastY = additionalPortSpace.top + (usableSpaceEast - usedPortSpace) / 2.0;
                    break;
                }
                case END: {
                    data.eastY = nodeSize.y - usedPortSpace - additionalPortSpace.bottom;
                }
            }
        }
    }

    private void placeHypernodePorts(GraphAdapters.NodeAdapter<?> node) {
        for (GraphAdapters.PortAdapter<?> port : node.getPorts()) {
            KVector position = new KVector(port.getPosition());
            switch (port.getSide()) {
                case WEST: {
                    position.x = 0.0;
                    position.y = node.getSize().y / 2.0;
                    break;
                }
                case EAST: {
                    position.x = node.getSize().x;
                    position.y = node.getSize().y / 2.0;
                    break;
                }
                case NORTH: {
                    position.x = node.getSize().x / 2.0;
                    position.y = 0.0;
                    break;
                }
                case SOUTH: {
                    position.x = node.getSize().x / 2.0;
                    position.y = node.getSize().y;
                }
            }
            port.setPosition(position);
        }
    }

    private void placeNodeLabels(NodeData data) {
        if (!data.node.getLabels().iterator().hasNext()) {
            return;
        }
        this.computeLabelGroupPositions(data);
        this.doPlaceNodeLabels(data);
    }

    private void computeLabelGroupPositions(NodeData data) {
        for (Map.Entry<LabelLocation, LabelGroup> entry : data.labelGroupsBoundingBoxes.entrySet()) {
            Rectangle boundingBox = entry.getValue();
            switch (entry.getKey()) {
                case OUT_T_L: {
                    boundingBox.x = 0.0;
                    boundingBox.y = -(boundingBox.height + data.labelSpacing);
                    break;
                }
                case OUT_T_C: {
                    boundingBox.x = (data.node.getSize().x - boundingBox.width) / 2.0;
                    boundingBox.y = -(boundingBox.height + data.labelSpacing);
                    break;
                }
                case OUT_T_R: {
                    boundingBox.x = data.node.getSize().x - boundingBox.width;
                    boundingBox.y = -(boundingBox.height + data.labelSpacing);
                    break;
                }
                case OUT_B_L: {
                    boundingBox.x = 0.0;
                    boundingBox.y = data.node.getSize().y + data.labelSpacing;
                    break;
                }
                case OUT_B_C: {
                    boundingBox.x = (data.node.getSize().x - boundingBox.width) / 2.0;
                    boundingBox.y = data.node.getSize().y + data.labelSpacing;
                    break;
                }
                case OUT_B_R: {
                    boundingBox.x = data.node.getSize().x - boundingBox.width;
                    boundingBox.y = data.node.getSize().y + data.labelSpacing;
                    break;
                }
                case OUT_L_T: {
                    boundingBox.x = -(boundingBox.width + data.labelSpacing);
                    boundingBox.y = 0.0;
                    break;
                }
                case OUT_L_C: {
                    boundingBox.x = -(boundingBox.width + data.labelSpacing);
                    boundingBox.y = (data.node.getSize().y - boundingBox.height) / 2.0;
                    break;
                }
                case OUT_L_B: {
                    boundingBox.x = -(boundingBox.width + data.labelSpacing);
                    boundingBox.y = data.node.getSize().y - boundingBox.height;
                    break;
                }
                case OUT_R_T: {
                    boundingBox.x = data.node.getSize().x + data.labelSpacing;
                    boundingBox.y = 0.0;
                    break;
                }
                case OUT_R_C: {
                    boundingBox.x = data.node.getSize().x + data.labelSpacing;
                    boundingBox.y = (data.node.getSize().y - boundingBox.height) / 2.0;
                    break;
                }
                case OUT_R_B: {
                    boundingBox.x = data.node.getSize().x + data.labelSpacing;
                    boundingBox.y = data.node.getSize().y - boundingBox.height;
                    break;
                }
                case IN_T_L: {
                    boundingBox.x = data.requiredPortLabelSpace.left + data.labelSpacing;
                    boundingBox.y = data.requiredPortLabelSpace.top + data.labelSpacing;
                    break;
                }
                case IN_T_C: {
                    boundingBox.x = (data.node.getSize().x - boundingBox.width) / 2.0;
                    boundingBox.y = data.requiredPortLabelSpace.top + data.labelSpacing;
                    break;
                }
                case IN_T_R: {
                    boundingBox.x = data.node.getSize().x - data.requiredPortLabelSpace.right - boundingBox.width - data.labelSpacing;
                    boundingBox.y = data.requiredPortLabelSpace.top + data.labelSpacing;
                    break;
                }
                case IN_C_L: {
                    boundingBox.x = data.requiredPortLabelSpace.left + data.labelSpacing;
                    boundingBox.y = (data.node.getSize().y - boundingBox.height) / 2.0;
                    break;
                }
                case IN_C_C: {
                    boundingBox.x = (data.node.getSize().x - boundingBox.width) / 2.0;
                    boundingBox.y = (data.node.getSize().y - boundingBox.height) / 2.0;
                    break;
                }
                case IN_C_R: {
                    boundingBox.x = data.node.getSize().x - data.requiredPortLabelSpace.right - boundingBox.width - data.labelSpacing;
                    boundingBox.y = (data.node.getSize().y - boundingBox.height) / 2.0;
                    break;
                }
                case IN_B_L: {
                    boundingBox.x = data.requiredPortLabelSpace.left + data.labelSpacing;
                    boundingBox.y = data.node.getSize().y - data.requiredPortLabelSpace.bottom - boundingBox.height - data.labelSpacing;
                    break;
                }
                case IN_B_C: {
                    boundingBox.x = (data.node.getSize().x - boundingBox.width) / 2.0;
                    boundingBox.y = data.node.getSize().y - data.requiredPortLabelSpace.bottom - boundingBox.height - data.labelSpacing;
                    break;
                }
                case IN_B_R: {
                    boundingBox.x = data.node.getSize().x - data.requiredPortLabelSpace.right - boundingBox.width - data.labelSpacing;
                    boundingBox.y = data.node.getSize().y - data.requiredPortLabelSpace.bottom - boundingBox.height - data.labelSpacing;
                }
            }
        }
    }

    private void doPlaceNodeLabels(NodeData data) {
        for (GraphAdapters.LabelAdapter<?> label : data.node.getLabels()) {
            KVector position = new KVector(label.getPosition());
            LabelLocation location = LabelLocation.values()[label.getVolatileId()];
            LabelGroup boundingBox = data.labelGroupsBoundingBoxes.get((Object)location);
            position.y = boundingBox.y + boundingBox.nextLabelYPos;
            if (location.getHorizontalAlignment() == TextAlignment.LEFT) {
                position.x = boundingBox.x;
            } else if (location.getHorizontalAlignment() == TextAlignment.CENTER) {
                position.x = boundingBox.x + (boundingBox.width - label.getSize().x) / 2.0;
            } else if (location.getHorizontalAlignment() == TextAlignment.RIGHT) {
                position.x = boundingBox.x + boundingBox.width - label.getSize().x;
            }
            label.setPosition(position);
            boundingBox.nextLabelYPos += label.getSize().y + data.labelSpacing;
        }
    }

    private void calculateRequiredNodeLabelSpace(NodeData data) {
        LabelSpaceCalculation.calculateRequiredNodeLabelSpace(data.node, data.labelSpacing, data.labelGroupsBoundingBoxes, data.requiredNodeLabelSpace);
    }

    private static final class NodeData {
        private final GraphAdapters.NodeAdapter<?> node;
        private double labelSpacing;
        private double portSpacing;
        private final Spacing.Insets requiredPortLabelSpace = new Spacing.Insets();
        private final Spacing.Insets requiredNodeLabelSpace = new Spacing.Insets();
        private boolean hasAdditionalPortSpace;
        private final int[] portsCount = new int[PortSide.values().length];
        private final int[] portGapsCount = new int[PortSide.values().length];
        private final double[] portGapsSize = new double[PortSide.values().length];
        private double westY;
        private double eastY;
        private double northX;
        private double southX;
        private final double[] portUsedSpace = new double[PortSide.values().length];
        private final PortAlignment[] portAlignment = new PortAlignment[PortSide.values().length];
        private final Map<LabelLocation, LabelGroup> labelGroupsBoundingBoxes = new EnumMap<LabelLocation, LabelGroup>(LabelLocation.class);

        private NodeData(GraphAdapters.NodeAdapter<?> node) {
            this.node = node;
            Arrays.fill(this.portsCount, 0);
            Arrays.fill(this.portGapsCount, 0);
            Arrays.fill(this.portUsedSpace, 0.0);
        }

        private int getPortsCount(PortSide side) {
            return this.portsCount[side.ordinal()];
        }

        private int getPortGapsCount(PortSide side) {
            return this.portGapsCount[side.ordinal()];
        }

        private double getPortGapsSize(PortSide side) {
            return this.portGapsSize[side.ordinal()];
        }

        private double getPortUsedSpace(PortSide side) {
            return this.portUsedSpace[side.ordinal()];
        }

        private PortAlignment getPortAlignment(PortSide side) {
            return this.portAlignment[side.ordinal()];
        }
    }
}

