/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util.nodespacing;

import de.cau.cs.kieler.core.util.IDataObject;

public abstract class Spacing
implements IDataObject,
Cloneable {
    private static final long serialVersionUID = 4358555478195088364L;
    public double top = 0.0;
    public double bottom = 0.0;
    public double left = 0.0;
    public double right = 0.0;

    protected Spacing() {
    }

    protected Spacing(double top, double left, double bottom, double right) {
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public void set(double newTop, double newLeft, double newBottom, double newRight) {
        this.top = newTop;
        this.left = newLeft;
        this.bottom = newBottom;
        this.right = newRight;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Spacing) {
            Spacing other = (Spacing)obj;
            return this.top == other.top && this.bottom == other.bottom && this.left == other.left && this.right == other.right;
        }
        return false;
    }

    public int hashCode() {
        int code1 = Double.valueOf(this.left).hashCode() << 16;
        int code2 = Double.valueOf(this.right).hashCode() << 16;
        return (code1 |= Double.valueOf(this.bottom).hashCode() & 0xFFFF) ^ (code2 |= Double.valueOf(this.top).hashCode() & 0xFFFF);
    }

    public String toString() {
        return "[top=" + this.top + ",left=" + this.left + ",bottom=" + this.bottom + ",right=" + this.right + "]";
    }

    public void parse(String string) {
        int start = 0;
        while (start < string.length() && Spacing.isdelim(string.charAt(start), "([{\"' \t\r\n")) {
            ++start;
        }
        int end = string.length();
        while (end > 0 && Spacing.isdelim(string.charAt(end - 1), ")]}\"' \t\r\n")) {
            --end;
        }
        if (start < end) {
            String[] tokens = string.substring(start, end).split(",|;");
            try {
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    String[] keyandvalue = token.split("=");
                    if (keyandvalue.length != 2) {
                        throw new IllegalArgumentException("Expecting a list of key-value pairs.");
                    }
                    String key = keyandvalue[0].trim();
                    double value = Double.parseDouble(keyandvalue[1].trim());
                    if (key.equals("top")) {
                        this.top = value;
                    } else if (key.equals("left")) {
                        this.left = value;
                    } else if (key.equals("bottom")) {
                        this.bottom = value;
                    } else if (key.equals("right")) {
                        this.right = value;
                    }
                    ++n2;
                }
            }
            catch (NumberFormatException exception) {
                throw new IllegalArgumentException("The given string contains parts that cannot be parsed as numbers." + exception);
            }
        }
    }

    private static boolean isdelim(char c, String delims) {
        int i = 0;
        while (i < delims.length()) {
            if (c == delims.charAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Spacing copy(Spacing other) {
        this.left = other.left;
        this.right = other.right;
        this.top = other.top;
        this.bottom = other.bottom;
        return this;
    }

    public Spacing clone() {
        try {
            return (Spacing)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError();
        }
    }

    public static final class Insets
    extends Spacing {
        private static final long serialVersionUID = -2159860709896900657L;

        public Insets() {
        }

        public Insets(Insets other) {
            super(other.top, other.left, other.bottom, other.right);
        }

        public Insets(double top, double left, double bottom, double right) {
            super(top, left, bottom, right);
        }
    }

    public static final class Margins
    extends Spacing {
        private static final long serialVersionUID = 7465583871643915474L;

        public Margins() {
        }

        public Margins(Margins other) {
            super(other.top, other.left, other.bottom, other.right);
        }

        public Margins(double top, double left, double bottom, double right) {
            super(top, left, bottom, right);
        }
    }
}

