/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.builders;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;

public class BuildProgressMonitoring {
    private static final String LABEL_PREFIX = "[PSS build] ";
    private IProgressMonitor fBuildMonitor;
    private int fTotalBuildWork;
    private int fCurrentInvocation;
    private List<InvocationProgressMonitor> fInvocationMonitors = new ArrayList<InvocationProgressMonitor>();

    public BuildProgressMonitoring(IProgressMonitor monitor, List<Invocation> invocations) {
        this.fBuildMonitor = monitor;
        this.makeMonitors(invocations);
        this.fBuildMonitor.beginTask(LABEL_PREFIX, this.fTotalBuildWork);
        this.fBuildMonitor.subTask(LABEL_PREFIX);
    }

    private void makeMonitors(List<Invocation> invocations) {
        int i = 0;
        while (i < invocations.size()) {
            ArrayList<String> topFiles = new ArrayList<String>();
            for (BuildConfigProperty p : invocations.get(i).getProperties()) {
                if (p.getKind() != 0) continue;
                topFiles.add(p.getValue());
            }
            InvocationProgressMonitor invocationProgressMonitor = new InvocationProgressMonitor(i, topFiles);
            this.fTotalBuildWork += invocationProgressMonitor.fNofTopFiles;
            this.fInvocationMonitors.add(invocationProgressMonitor);
            ++i;
        }
    }

    public void fileStarted(String path) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).topBegin(path);
    }

    public void fileDone(String path) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).topDone(path);
    }

    public void invocBegin(int invocNumber) {
        this.fCurrentInvocation = invocNumber;
        this.fInvocationMonitors.get(this.fCurrentInvocation).invocBegin();
    }

    public void invocDone(int invocNumber) {
        this.fInvocationMonitors.get(this.fCurrentInvocation).invocDone();
    }

    class InvocationProgressMonitor {
        int fTopFileNo;
        Set<String> fTopFilesSet;
        int fNofTopFiles;
        int fInvocationNumber;
        IProgressMonitor fInvocationMonitor;
        IProgressMonitor fTopFilesMonitor;

        public InvocationProgressMonitor(int invocationNumber, List<String> topFiles) {
            this.fInvocationNumber = invocationNumber;
            this.fTopFilesSet = new HashSet<String>(topFiles);
            this.fNofTopFiles = topFiles.size();
            this.fInvocationMonitor = new SubProgressMonitor(BuildProgressMonitoring.this.fBuildMonitor, this.fNofTopFiles, 4);
            this.fTopFilesMonitor = new SubProgressMonitor(this.fInvocationMonitor, this.fNofTopFiles, 4);
        }

        public void topBegin(String top) {
            if (this.fTopFilesSet.contains(top)) {
                ++this.fTopFileNo;
                this.fTopFilesMonitor.subTask("(" + this.fTopFileNo + "/" + this.fNofTopFiles + ") " + top);
            }
        }

        public void topDone(String top) {
            if (!this.fTopFilesSet.contains(top)) {
                return;
            }
            this.fTopFilesMonitor.worked(1);
            this.fTopFilesSet.remove(top);
            if (this.fTopFilesSet.isEmpty()) {
                this.fTopFilesMonitor.done();
            }
        }

        public void invocBegin() {
            this.fInvocationMonitor.beginTask("[PSS build] [Invocation #" + (this.fInvocationNumber + 1) + "/" + BuildProgressMonitoring.this.fInvocationMonitors.size() + "] ", this.fNofTopFiles);
            this.fTopFilesMonitor.beginTask("Loading top ", this.fNofTopFiles);
        }

        public void invocDone() {
            this.fInvocationMonitor.done();
        }
    }
}

