/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.builders;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTypeAlias;
import ro.amiq.pssdt.model.reflection.csv.SLNTableDataCSV;
import ro.amiq.pssdt.model.reflection.csv.SLNTableRow;
import ro.amiq.pssdt.model.reflection.csv.SLNTablesFromCSVFile;
import ro.amiq.pssdt.model.reflection.predefined.corelib.RfPredefinedCodeLoader;
import ro.amiq.pssdt.parser.PSSCompiler;
import ro.amiq.pssdt.ui.persistenttask.PersistentTaskManager;

public class PSSBuilderUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean internalFullBuild(IBuildStatusProvider buildStatusProvider, PSSCompiler pssParser, RfProject rfProject, List<CustomPragma> customPragmas, DVTCodeCommentsPreferences commentsPreferences, int maxIssuesKindNumber) {
        try {
            IProject project = rfProject.getProject();
            if (project == null) {
                return false;
            }
            List invocations = BuildConfigManager.getInvocations((IProject)project);
            if (invocations == null) return false;
            if (invocations.isEmpty()) {
                return false;
            }
            Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
            boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
            boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
            int invocOffset = 0;
            int fileIndex = 0;
            int invocNumber = 0;
            while (invocNumber < invocations.size()) {
                block21: {
                    Invocation invocation = (Invocation)invocations.get(invocNumber);
                    buildStatusProvider.beginInvocation(invocNumber);
                    List buildTopFiles = BuildConfigManager.getTopFiles((Invocation)invocation, (LanguageKind)LanguageKind.PSS);
                    List<IPath> predefinedFilePaths = RfPredefinedCodeLoader.getPredefinedFilePaths(project);
                    SkipCompileFilter skipCompileFilter = BuildConfigManager.getSkipCompileFilter((IProject)project, (Invocation)invocation);
                    if (buildTopFiles.isEmpty()) break block21;
                    ArrayList<BuildConfigProperty> topFiles = new ArrayList<BuildConfigProperty>(buildTopFiles.size() + predefinedFilePaths.size());
                    for (IPath predefinedFilePath : predefinedFilePaths) {
                        topFiles.add(new BuildConfigProperty(0, predefinedFilePath.toOSString()));
                    }
                    topFiles.addAll(buildTopFiles);
                    buildStatusProvider.consolePrint("*** Loading top files ***");
                    int i = -1;
                    while (i < topFiles.size()) {
                        block24: {
                            IBuildConfigParserConstants.LanguageSyntax languageSyntax;
                            String pathValue;
                            block23: {
                                block22: {
                                    pathValue = null;
                                    languageSyntax = IBuildConfigParserConstants.LanguageSyntax.PSS;
                                    if (i != -1) break block22;
                                    IPath topFilePath = PSSBuilderUtils.getPSSTopPath(project);
                                    pathValue = topFilePath.toOSString();
                                    String fileContent = PSSBuilderUtils.collectStaticConstOverride(project, invocation.getProperties());
                                    PSSBuilderUtils.writeFile(pathValue, fileContent);
                                    break block23;
                                }
                                BuildConfigProperty topFileProperty = (BuildConfigProperty)topFiles.get(i);
                                languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)topFileProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX");
                                if (languageSyntax == null) {
                                    languageSyntax = IBuildConfigParserConstants.LanguageSyntax.PSS;
                                }
                                if (topFileProperty.getKind() != 0) break block24;
                                if (buildStatusProvider.checkCancel()) {
                                    return false;
                                }
                                pathValue = topFileProperty.getValue();
                                pathValue = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(pathValue);
                                if ((pathValue = DVTUtilsCommon.INSTANCE.getFileSubstitute(project, pathValue)) == null) break block24;
                                Object csvSheet = topFileProperty.getAttribute("ATTRIBUTE_CSV_SHEET");
                                if (csvSheet instanceof String) {
                                    String fileContent = PSSBuilderUtils.readCSV(rfProject, pathValue, (String)csvSheet);
                                    pathValue = String.valueOf(pathValue) + ".pss";
                                    PSSBuilderUtils.writeFile(pathValue, fileContent);
                                }
                            }
                            PSSModelManager.getInstance().addTopFile(pathValue);
                            PSSCompiler pSSCompiler = pssParser;
                            synchronized (pSSCompiler) {
                                block19: {
                                    if (!pssParser.isInterrupted()) break block19;
                                    buildStatusProvider.stopCancelPoolingThread();
                                    return true;
                                }
                                try {
                                    try {
                                        buildStatusProvider.setTimestamp();
                                        buildStatusProvider.newCancelPoolingThread();
                                        buildStatusProvider.startCancelPoolingThread(pssParser, project, false);
                                        fileIndex = pssParser.parseFile(pathValue, invocation.getLibName(), languageSyntax, rfProject, null, false, fileIndex, invocNumber + invocOffset, maxIssuesKindNumber, customPragmas, commentsPreferences, taskNames, caseSensitiveTaskTags, hideTaskTags, skipCompileFilter);
                                    }
                                    catch (Exception e) {
                                        DVTLogger.INSTANCE.logError((Throwable)e);
                                        buildStatusProvider.stopCancelPoolingThread();
                                    }
                                }
                                catch (Throwable throwable) {
                                    buildStatusProvider.stopCancelPoolingThread();
                                    throw throwable;
                                }
                                buildStatusProvider.stopCancelPoolingThread();
                            }
                        }
                        ++i;
                    }
                }
                buildStatusProvider.endInvocation(invocNumber);
                ++invocNumber;
            }
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    private static String collectStaticConstOverride(IProject project, List<BuildConfigProperty> topFiles) {
        StringBuilder result = new StringBuilder();
        try {
            String activeBuildConfigName = BuildConfigManager.getActiveBuildConfigName((IProject)project);
            result.append("// see +define directives in '").append(activeBuildConfigName).append(".build' file:\n");
            result.append("__DVT__STATIC__CONST__OVERRIDE__ {\n");
            int i = 0;
            while (i < topFiles.size()) {
                Map definesMap;
                BuildConfigProperty property = topFiles.get(i);
                if (property.getKind() == 11 && property.getAttribute(IBuildConfigParserConstants.Directive.DVT_PSS_STATIC_CONST_OVERRIDE.toString()) != null && (definesMap = (Map)property.getAttribute(IBuildConfigParserConstants.Directive.DVT_PSS_STATIC_CONST_OVERRIDE.toString())) != null) {
                    for (Map.Entry definesEntry : definesMap.entrySet()) {
                        Object key = definesEntry.getKey();
                        Object value = definesEntry.getValue();
                        if (!(key instanceof String) || !(value instanceof String)) continue;
                        result.append("    ").append(key).append("    ").append(value).append(";\n");
                    }
                }
                ++i;
            }
            result.append("};\n\n");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result.toString();
    }

    private static String readCSV(RfProject rfProject, String csvFilePath, String sheetName) {
        StringBuilder result1 = new StringBuilder();
        try {
            SLNTablesFromCSVFile table = SLNTablesFromCSVFile.readTablesFromFile(csvFilePath, sheetName);
            for (String key : table.getTablesKeys()) {
                if (key == null || key.isEmpty()) continue;
                StringBuilder result2 = new StringBuilder();
                SLNTableDataCSV tableData = table.getTableData(key);
                List<SLNTableRow> lines = tableData.getLines();
                if (!tableData.hasDefinitions()) continue;
                RfStruct rfStruct = null;
                String packageName = tableData.getDefinition("package");
                String structName = tableData.getDefinition("struct");
                String sizeConstName = tableData.getDefinition("size_const");
                RfPackage rfPackage = rfProject.getPackage(packageName);
                rfStruct = rfPackage == null ? null : (RfStruct)rfPackage.getLocalMember(null, Collections.singleton(RfStruct.class), structName, false, null);
                result1.append("package ").append(packageName).append(" {\n\n");
                if (rfPackage == null || rfPackage.getMember(null, null, sizeConstName, false, true, Collections.singleton(RfField.class), null) == null) {
                    result1.append("    static const int ").append(sizeConstName).append(" = ").append(lines.size()).append(";\n\n");
                }
                result2.append("    function void ").append(key).append("_init(").append(structName).append(" ").append(key).append("[").append(sizeConstName).append("]) {\n");
                LinkedHashMap enumExtends = new LinkedHashMap();
                ArrayList<String> fieldNames = new ArrayList<String>();
                ArrayList<RfField> rfFields = new ArrayList<RfField>();
                if (!lines.isEmpty()) {
                    SLNTableRow line = lines.get(0);
                    int i = 0;
                    while (i < line.getNofColumns()) {
                        String columnName = line.getColumnName(i + 1);
                        if (columnName != null) {
                            fieldNames.add(columnName);
                            RfField rfField = rfStruct == null ? null : (RfField)rfStruct.getLocalMember(null, Collections.singleton(RfField.class), columnName, false, null);
                            rfFields.add(rfField);
                        }
                        ++i;
                    }
                }
                int i = 0;
                while (i < lines.size()) {
                    ArrayList<String> fieldValues = new ArrayList<String>();
                    SLNTableRow line = lines.get(i);
                    int j = 0;
                    while (j < line.getNofColumns()) {
                        String columnValue = line.getColumnValue(j + 1);
                        if (columnValue != null) {
                            columnValue = columnValue.trim();
                            fieldValues.add(columnValue);
                        }
                        ++j;
                    }
                    j = 0;
                    while (j < fieldNames.size()) {
                        RfField rfField = (RfField)rfFields.get(j);
                        String fieldName = (String)fieldNames.get(j);
                        String fieldValue = (String)fieldValues.get(j);
                        if (rfField != null) {
                            RfNamedElement assocType = rfField.getAssociatedBaseType();
                            int count = 0;
                            while (assocType instanceof RfTypeAlias && count < 20) {
                                assocType = ((RfTypeAlias)assocType).getAssociatedBaseType();
                                ++count;
                            }
                            if (assocType instanceof RfEnumType) {
                                if (!((RfEnumType)assocType).hasEnumItem(fieldValue)) {
                                    Set enumItems = (Set)enumExtends.get(assocType);
                                    if (enumItems == null) {
                                        enumItems = Collections.newSetFromMap(new LinkedHashMap());
                                        enumExtends.put(assocType, enumItems);
                                    }
                                    enumItems.add(fieldValue);
                                }
                            } else if (assocType instanceof RfPredefinedType) {
                                fieldValue = fieldValue.toLowerCase();
                            }
                        }
                        result2.append("        ").append(key).append("[").append(i).append("].").append(fieldName).append(" = ").append(fieldValue).append(";\n");
                        ++j;
                    }
                    if (i < lines.size() - 1) {
                        result2.append("\n");
                    }
                    ++i;
                }
                result2.append("    }\n\n");
                result2.append("}\n\n");
                for (Map.Entry enumExtendEntry : enumExtends.entrySet()) {
                    RfNamedElement rfEnumType = (RfNamedElement)enumExtendEntry.getKey();
                    result1.append("    extend enum ").append(PSSBuilderUtils.getQualifiedName(rfEnumType)).append(" { ");
                    Set enumItems = (Set)enumExtendEntry.getValue();
                    boolean first = true;
                    for (String enumItem : enumItems) {
                        if (!first) {
                            result1.append(", ");
                        }
                        result1.append(enumItem);
                        first = false;
                    }
                    result1.append(" }\n\n");
                }
                result1.append(result2.toString());
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return result1.toString();
    }

    private static String getQualifiedName(RfNamedElement element) {
        String result = element.getName();
        while ((element = element.getEnclosingScope()) != null) {
            result = DVTStringUtil.appendString((Object[])new Object[]{element.getName(), "::", result});
            if (element instanceof RfPackage) break;
        }
        return result;
    }

    private static void writeFile(String filePath, String content) {
        DVTFileUtils.getInstance().writeStringToFile(new File(filePath), content, false);
    }

    public static IPath getPSSTopPath(IProject project) {
        IPath stateLocation = PSSPlugin.getDefault().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append("__pss__" + project.getName() + ".pss");
        return topLocation;
    }

    public static interface IBuildStatusProvider {
        public void consolePrint(String var1);

        public void consolePrintSection(String var1);

        public void newCancelPoolingThread();

        public void startCancelPoolingThread(PSSCompiler var1, IProject var2, boolean var3);

        public void setCancelPoolingThreadFileName(String var1);

        public void stopCancelPoolingThread();

        public void setTimestamp();

        public boolean checkCancel();

        public void beginInvocation(int var1);

        public void endInvocation(int var1);

        public int getFileIndex();
    }
}

