/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.core;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import ro.amiq.dvt.DVTActivator;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.pssdt.externaltools.PSSExternalToolsDelegate;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.ui.namechecker.NameCheckerWarningsManager;
import ro.amiq.pssdt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.pssdt.ui.syntaxerrors.SyntaxErrorsManager;

public class PSSPlugin
extends AbstractUIPlugin {
    private static PSSPlugin fPlugin;
    public static final String PLUGIN_ID = "ro.amiq.pssdt";
    public static final String NATURE_ID = "ro.amiq.pssdt.pssnature";
    public static final String PSS_SOURCE = "ro.amiq.pssdt.PSSSource";
    private IPreferenceStore fCombinedPreferenceStore;

    public PSSPlugin() {
        fPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DVTLogger.INSTANCE.logDebug(">> Started PSSDT Plugin (version: " + (String)this.getBundle().getHeaders().get("Bundle-Version") + ").");
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getType() == 2 && event.getBundle().getSymbolicName().equals(PSSPlugin.PLUGIN_ID)) {
                    DVTLogger.INSTANCE.logDebug(">> Started PSSDT initialization.");
                    new DVTActivator();
                    SyntaxErrorsManager.getInstance().startup();
                    ExternalToolsModelManager.getInstance().addExternalToolsDelegate((IExternalToolsDelegate)PSSExternalToolsDelegate.getInstance());
                    PSSPlugin.this.contributeToVariables();
                    try {
                        while (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isStarting()) {
                            Thread.sleep(50L);
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DVTLogger.INSTANCE.logDebug(">> Started PSSDT UI initialization.");
                            PersistentTaskManager.getInstance().startup();
                            DVTMixedLangModelManager.getInstance().registerModelManager((DVTModelManager)PSSModelManager.getInstance());
                            NameCheckerWarningsManager.getInstance();
                            ObjectionManager.getInstance().clear(Objection.PSSDT_INITIALIZED);
                            DVTLogger.INSTANCE.logDebug("<< Ended PSSDT UI initialization.");
                        }
                    });
                    DVTLogger.INSTANCE.logDebug("<< Ended PSSDT initialization.");
                }
            }
        });
    }

    private void contributeToVariables() {
    }

    public void stop(BundleContext context) throws Exception {
        try {
            SyntaxErrorsManager.getInstance().shutdown();
            PersistentTaskManager.getInstance().shutdown();
            DVTPlugin.getDefault().collect().i("F707373");
            DVTLogger.INSTANCE.logDebug("<< Ended PSSDT Plugin.");
        }
        finally {
            fPlugin = null;
            super.stop(context);
        }
    }

    public static PSSPlugin getDefault() {
        return fPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public void savePreferences() {
        try {
            InstanceScope instance = new InstanceScope();
            instance.getNode(PLUGIN_ID).flush();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

