/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.swt.graphics.RGB;

public class ADPreferenceBundle {
    public boolean showRedundantParallels;
    public boolean showDataConnections = true;
    public boolean showActionPaths = true;
    public boolean showInputsAndOutputs;
    public boolean showLocksAndShares = true;
    public boolean keepSeed;
    private Map<String, RGB> poolColorMap;

    public static ADPreferenceBundle createActivityDiagramDefaultBundle() {
        ADPreferenceBundle preferenceBundle = new ADPreferenceBundle();
        preferenceBundle.showRedundantParallels = false;
        preferenceBundle.showDataConnections = false;
        preferenceBundle.showActionPaths = false;
        preferenceBundle.showInputsAndOutputs = false;
        preferenceBundle.showLocksAndShares = false;
        preferenceBundle.keepSeed = false;
        return preferenceBundle;
    }

    public ADPreferenceBundle getCopy() {
        ADPreferenceBundle result = new ADPreferenceBundle();
        result.showRedundantParallels = this.showRedundantParallels;
        result.showDataConnections = this.showDataConnections;
        result.showActionPaths = this.showActionPaths;
        result.showInputsAndOutputs = this.showInputsAndOutputs;
        result.showLocksAndShares = this.showLocksAndShares;
        result.keepSeed = this.keepSeed;
        return result;
    }

    public RGB getColor(String pool) {
        if (this.poolColorMap == null) {
            return null;
        }
        return this.poolColorMap.get(pool);
    }

    public void addColorForPool(String pool) {
        if (this.poolColorMap != null && this.poolColorMap.containsKey(pool)) {
            return;
        }
        if (this.poolColorMap == null) {
            this.poolColorMap = new HashMap<String, RGB>();
        }
        TreeSet<Float> values = new TreeSet<Float>();
        this.poolColorMap.values().forEach(color -> {
            boolean bl = values.add(Float.valueOf(color.getHSB()[0]));
        });
        values.add(Float.valueOf(360.0f));
        float offset = 0.0f;
        float lastEl = 0.0f;
        float maxDiff = 0.0f;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            float curentEl = ((Float)it.next()).floatValue();
            float curentDiff = curentEl - lastEl;
            if (curentDiff > maxDiff) {
                maxDiff = curentDiff;
                offset = lastEl;
            }
            lastEl = curentEl;
        }
        float hue = offset + maxDiff / 2.0f;
        int h2 = (pool.length() % 16 * 4 + pool.length() % 16 / 4) % 16;
        float sat = (float)(0.2 + (double)((float)h2 / 16.0f * 0.4f));
        RGB rgb = new RGB(hue, sat, 0.9f);
        this.poolColorMap.put(pool, rgb);
    }
}

