/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ActivityDiagramPhases;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramScene;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.util.Utils;

public class ActivityDiagram
implements DDiagram {
    private static final String DIAGRAM_NAME_PREFIX = "Activity of ";
    private static final DGenerator.Builder<ActivityDiagram, DActionDiagramScene> SCENE_GENERATOR = DGenerator.Builder.input(ActivityDiagram.class).phase(ActivityDiagramPhases::createKNode).phase(DPhases::layoutKNode).phase(ActivityDiagramPhases::createScene);
    private final RfElementPath actionElementPath;
    private final IProject project;
    private final String title;
    private final String name;
    private final ADPreferenceBundle preferenceBundle;

    public ActivityDiagram(RfStruct rootAction, ADPreferenceBundle preferenceBundle) {
        this.actionElementPath = RfElementPath.path((IRfNamedElement)rootAction);
        this.project = rootAction.getRfProject().getProject();
        this.name = this.title = Utils.append(DIAGRAM_NAME_PREFIX, "[", rootAction.getNameForDiagram(), "]");
        this.preferenceBundle = preferenceBundle;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getTitle() {
        return this.title;
    }

    public String getName() {
        return this.name;
    }

    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build((DDiagram)this);
    }

    public RfElementPath getActionElementPath() {
        return this.actionElementPath;
    }

    public RfStruct getRootAction() {
        IRfNamedElement actionNamedElement = this.actionElementPath.toNamedElement(this.project);
        if (!(actionNamedElement instanceof RfStruct)) {
            return null;
        }
        return (RfStruct)actionNamedElement;
    }

    public ADPreferenceBundle getPreferenceBundle() {
        return this.preferenceBundle;
    }

    public int hashCode() {
        return Objects.hash(this.actionElementPath, this.project, this.title, this.name, this.preferenceBundle);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActivityDiagram other = (ActivityDiagram)obj;
        return Objects.equals(this.actionElementPath, other.actionElementPath) && Objects.equals(this.project, other.project) && Objects.equals(this.title, other.title) && Objects.equals(this.name, other.name) && Objects.equals(this.preferenceBundle, other.preferenceBundle);
    }
}

