/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action;

import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.DGenerator;
import ro.amiq.dvt.diagrams.DPhases;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ScenarioDiagramPhases;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramScene;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;
import ro.amiq.pssdt.diagrams.action.model.ScenarioDiagramModel;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;

public class ScenarioDiagram
implements DDiagram {
    private static final DGenerator.Builder<ScenarioDiagram, DActionDiagramScene> SCENE_GENERATOR = DGenerator.Builder.input(ScenarioDiagram.class).phase(ScenarioDiagramPhases::createKNode).phase(DPhases::layoutKNode).phase(ScenarioDiagramPhases::createScene);
    private final String title;
    private final String name;
    private final List<Long> seedHistory;
    private final RfProject rfProject;
    private final RfElementPath rfActionElementPath;
    private final RfElementPath rfInstanceElementPath;
    private final RfElementPath rfComponentElementPath;
    private final ActionInstance instance;
    private final ScenarioDiagramModel model;
    private final ADPreferenceBundle bundle;
    private EnumMap<IActionDiagramElement.MemberActionKind, Set<Integer>> individualNodeActions;

    public ScenarioDiagram(ScenarioUtils.RootDescriptor rootDescriptor, ActionInstance instance, ScenarioDiagramModel model, String name, String title, ADPreferenceBundle bundle, List<Long> seedHistory, EnumMap<IActionDiagramElement.MemberActionKind, Set<Integer>> individualNodeActions, RfProject rfProject) {
        this.rfActionElementPath = RfElementPath.path((IRfNamedElement)rootDescriptor.rfAction);
        this.rfInstanceElementPath = RfElementPath.path((IRfNamedElement)rootDescriptor.rfInstance);
        this.rfComponentElementPath = RfElementPath.path((IRfNamedElement)rootDescriptor.rfComponent);
        this.instance = instance;
        this.model = model;
        this.name = name;
        this.title = title;
        this.bundle = bundle;
        this.individualNodeActions = individualNodeActions;
        this.rfProject = rfProject;
        this.seedHistory = seedHistory;
    }

    public ScenarioUtils.RootDescriptor getRootDescriptor() {
        IProject project = this.rfProject.getProject();
        RfStruct rfAction = (RfStruct)this.rfActionElementPath.toNamedElement(project);
        RfField rfInstance = (RfField)this.rfInstanceElementPath.toNamedElement(project);
        RfStruct rfComponent = (RfStruct)this.rfComponentElementPath.toNamedElement(project);
        return new ScenarioUtils.RootDescriptor(this.rfProject, rfInstance, rfComponent, rfAction);
    }

    public IProject getProject() {
        return this.rfProject.getProject();
    }

    public RfProject getRfProject() {
        return this.rfProject;
    }

    public String getTitle() {
        return this.title;
    }

    public Long getSeed() {
        return this.seedHistory != null ? this.seedHistory.get(this.seedHistory.size() - 1) : null;
    }

    public List<Long> getSeedHistory() {
        return this.seedHistory != null ? this.seedHistory : Collections.emptyList();
    }

    public ScenarioDiagramModel getModel() {
        return this.model;
    }

    public ADPreferenceBundle getPreferenceBundle() {
        return this.bundle;
    }

    public EnumMap<IActionDiagramElement.MemberActionKind, Set<Integer>> getIndividualNodeActions() {
        return this.individualNodeActions;
    }

    public void addIndividualNodeAction(IActionDiagramElement.MemberActionKind kind, int nodeIndex) {
        if (this.individualNodeActions == null) {
            this.individualNodeActions = new EnumMap(IActionDiagramElement.MemberActionKind.class);
        }
        if (this.individualNodeActions.get((Object)kind) == null) {
            this.individualNodeActions.put(kind, new HashSet());
        }
        this.individualNodeActions.get((Object)kind).add(nodeIndex);
    }

    public void removeIndividualNodeAction(IActionDiagramElement.MemberActionKind kind, int nodeIndex) {
        if (this.individualNodeActions == null || this.individualNodeActions.get((Object)kind) == null) {
            return;
        }
        this.individualNodeActions.get((Object)kind).remove(nodeIndex);
    }

    public ActionInstance getInstance() {
        return this.instance;
    }

    public String getName() {
        return this.name;
    }

    public DGenerator<? extends DDiagram, ? extends DObject> getSceneGenerator() {
        return SCENE_GENERATOR.build((DDiagram)this);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bundle == null ? 0 : this.bundle.hashCode());
        result = 31 * result + (this.individualNodeActions == null ? 0 : this.individualNodeActions.hashCode());
        result = 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        result = 31 * result + (this.model == null ? 0 : this.model.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.rfProject == null ? 0 : this.rfProject.hashCode());
        result = 31 * result + (this.seedHistory == null ? 0 : this.seedHistory.hashCode());
        result = 31 * result + (this.title == null ? 0 : this.title.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScenarioDiagram other = (ScenarioDiagram)obj;
        if (this.bundle == null ? other.bundle != null : !this.bundle.equals(other.bundle)) {
            return false;
        }
        if (this.individualNodeActions == null ? other.individualNodeActions != null : !this.individualNodeActions.equals((Object)other.individualNodeActions)) {
            return false;
        }
        if (this.instance == null ? other.instance != null : !this.instance.equals(other.instance)) {
            return false;
        }
        if (this.model == null ? other.model != null : !this.model.equals(other.model)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.rfProject == null ? other.rfProject != null : !this.rfProject.equals(other.rfProject)) {
            return false;
        }
        if (this.seedHistory == null ? other.seedHistory != null : !this.seedHistory.equals(other.seedHistory)) {
            return false;
        }
        return !(this.title == null ? other.title != null : !this.title.equals(other.title));
    }
}

