/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.base.DShape;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DRectangle;
import ro.amiq.dvt.draw.obj.primitive.DRoundRectangle;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramObject;

public class DActionDiagramContainer
extends DActionDiagramObject
implements DSelectable {
    public static final DProperties.Key<RoundDegree> ROUND_DEGREE = new DProperties.Key("DActionDiagramContainer.ROUND_DEGREE");
    private DShape rectangle1;
    private DShape rectangle2;
    private DLine line;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        if (this.getProperty(ROUND_DEGREE) == RoundDegree.HALF) {
            this.rectangle1 = new DRoundRectangle(layout.x, layout.y, layout.width, layout.height, 30);
            this.rectangle2 = new DRectangle(layout.x, layout.y - 1, layout.width, layout.height / 2);
            this.line = new DLine(new int[]{layout.x, layout.y - 1 + layout.height / 2, layout.x, layout.y - 1, layout.x + layout.width, layout.y - 1, layout.x + layout.width, layout.y - 1 + layout.height / 2});
            this.addChild((DObject)this.rectangle1);
            this.addChild((DObject)this.rectangle2);
            this.addChild((DObject)this.line);
        } else {
            if (this.getProperty(ROUND_DEGREE) == RoundDegree.FULL) {
                this.rectangle1 = new DRoundRectangle(layout.x, layout.y, layout.width, layout.height, 30);
            } else if (this.getProperty(ROUND_DEGREE) == RoundDegree.NONE) {
                this.rectangle1 = new DRectangle(layout.x, layout.y, layout.width, layout.height);
            }
            this.addChild((DObject)this.rectangle1);
        }
        if (this.rectangle1 != null) {
            this.rectangle1.setFillColor((RGBV)this.getProperty(FILL_COLOR));
            this.rectangle1.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            this.rectangle1.setLineWidth(((Integer)this.getProperty(LINE_WIDTH)).intValue());
            this.rectangle1.setLineStyle(((Integer)this.getProperty(LINE_STYLE)).intValue());
            this.rectangle1.setLineCap(1);
            this.rectangle1.setLineAutoScale(true);
        }
        if (this.rectangle2 != null) {
            this.rectangle2.setFillColor((RGBV)this.getProperty(FILL_COLOR));
            this.rectangle2.setLineVisible(false);
        }
        if (this.line != null) {
            this.line.setLineColor((RGBV)this.getProperty(LINE_COLOR));
            this.line.setLineWidth(((Integer)this.getProperty(LINE_WIDTH)).intValue());
            this.line.setLineStyle(((Integer)this.getProperty(LINE_STYLE)).intValue());
            this.line.setLineCap(1);
            this.line.setLineAutoScale(true);
        }
    }

    public void select(boolean selected, String type) {
        if (this.rectangle1 != null) {
            this.rectangle1.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.rectangle1.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.rectangle1.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
            this.rectangle1.setLineVisible(true);
        }
        if (this.rectangle2 != null) {
            this.rectangle2.setFillColor(selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR));
            this.rectangle2.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.rectangle2.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
            this.rectangle2.setLineVisible(false);
        }
        if (this.line != null) {
            this.line.setLineColor(selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR));
            this.line.setLineWidth(selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue());
            this.line.setLineVisible(true);
        }
    }

    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add((DObject)this.rectangle1);
        selectedObjects.add((DObject)this.rectangle2);
        selectedObjects.add((DObject)this.line);
        return selectedObjects;
    }

    public static enum RoundDegree {
        NONE,
        HALF,
        FULL;

    }
}

