/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.draw.obj;

import de.cau.cs.kieler.kiml.options.EdgeType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DHeadClosedArrow;
import ro.amiq.dvt.draw.obj.primitive.DLine;
import ro.amiq.dvt.draw.obj.primitive.DSpline;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramLabel;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramObject;

public class DActionDiagramEdge
extends DActionDiagramObject
implements DSelectable {
    public static final DProperties.Key<List<Point>> BENDING_POINTS = new DProperties.Key("DActionDiagramEdge.BENDING_POINTS");
    public static final DProperties.Key<Integer> ARROW_SIZE = new DProperties.Key("DActionDiagramEdge.ARROW_SIZE");
    public static final DProperties.Key<Boolean> SPLINE = new DProperties.Key("DActionDiagramEdge.SPLINE");
    public static final DProperties.Key<EdgeType> EDGE_TYPE = new DProperties.Key("DActionDiagramEdge.EDGE_TYPE");
    private DLine line;
    private DActionDiagramLabel.DActionDiagramSelectableLabel label;
    private DHeadClosedArrow arrowHead;

    public void setLabel(DActionDiagramLabel.DActionDiagramSelectableLabel label) {
        this.label = label;
    }

    public DActionDiagramLabel.DActionDiagramSelectableLabel getLabel() {
        return this.label;
    }

    @Override
    public void forge() {
        List<Point> bendingPoints = this.getProperty(BENDING_POINTS);
        this.line = this.getProperty(SPLINE) != false ? new DSpline(bendingPoints) : new DLine(bendingPoints);
        this.line.setLineWidth(((Integer)this.getProperty(LINE_WIDTH)).intValue());
        this.line.setLineStyle(((Integer)this.getProperty(LINE_STYLE)).intValue());
        this.line.setLineCap(1);
        this.addChild((DObject)this.line);
        int x1 = bendingPoints.get((int)(bendingPoints.size() - 1)).x;
        int y1 = bendingPoints.get((int)(bendingPoints.size() - 1)).y;
        int x2 = bendingPoints.get((int)(bendingPoints.size() - 2)).x;
        int y2 = bendingPoints.get((int)(bendingPoints.size() - 2)).y;
        if (this.getProperty(EDGE_TYPE) != EdgeType.NONE) {
            this.setProperty(ARROW_SIZE, 10);
            this.arrowHead = x1 - x2 == 0 ? new DHeadClosedArrow(this.getProperty(ARROW_SIZE).intValue(), x1, y1 + 3 * Integer.signum(y1 - y2), x2, y2) : (y1 - y2 == 0 ? new DHeadClosedArrow(this.getProperty(ARROW_SIZE).intValue(), x1 + 3 * Integer.signum(x1 - x2), y1, x2, y2) : new DHeadClosedArrow(this.getProperty(ARROW_SIZE).intValue(), x1, y1, x2, y2));
            this.addChild((DObject)this.arrowHead);
        }
        this.select(false, "MAIN_SELECTION");
    }

    public void select(boolean selected, String type) {
        RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
        RGBV fillColor = selected ? (RGBV)this.getProperty(SELECTED_FILL_COLOR) : (RGBV)this.getProperty(FILL_COLOR);
        int lineWidth = selected ? ((Integer)this.getProperty(SELECTED_LINE_WIDTH)).intValue() : ((Integer)this.getProperty(LINE_WIDTH)).intValue();
        this.line.setLineColor(lineColor);
        this.line.setLineWidth(lineWidth);
        if (this.arrowHead == null) {
            return;
        }
        this.arrowHead.setLineWidth(lineWidth);
        this.arrowHead.setLineColor(lineColor);
        this.arrowHead.setFillColor(fillColor);
    }

    public List<DObject> getSelectedObjects() {
        ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
        selectedObjects.add((DObject)this.line);
        selectedObjects.add((DObject)this.arrowHead);
        return selectedObjects;
    }
}

