/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.draw.obj;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import ro.amiq.dvt.draw.obj.base.DObject;
import ro.amiq.dvt.draw.obj.interaction.DSearchable;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.draw.obj.primitive.DText;
import ro.amiq.dvt.draw.obj.utils.DProperties;
import ro.amiq.dvt.draw.obj.utils.RGBV;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramObject;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;

public class DActionDiagramLabel
extends DActionDiagramObject
implements DSearchable {
    public static final DProperties.Key<FontData> FONT = new DProperties.Key("DActionDiagramLabel.FONT");
    public static final DProperties.Key<String> TEXT = new DProperties.Key("DActionDiagramLabel.TEXT");
    protected DText text;

    @Override
    public void forge() {
        Rectangle layout = (Rectangle)this.getProperty(LAYOUT);
        this.text = new DText(this.getProperty(TEXT), layout.x, layout.y, layout.width, layout.height, this.getProperty(FONT));
        this.text.setTextColor((RGBV)this.getProperty(LINE_COLOR));
        this.addChild((DObject)this.text);
        if (this instanceof DActionDiagramSelectableLabel) {
            ((DActionDiagramSelectableLabel)this).select(false, "MAIN_SELECTION");
        }
    }

    public String getSearchText() {
        return this.getProperty(TEXT);
    }

    public void highlightSearchMatch(DSearchable.Highlight highlight) {
        DText text = (DText)this.getChildren().get(0);
        if (highlight == DSearchable.Highlight.NONE) {
            text.setHighlight(-1, -1);
        } else {
            text.setHighlightColor(highlight.getColor());
            text.setHighlight(1, this.getProperty(TEXT).length() - 1);
        }
    }

    public String shortValueString() {
        return this.getProperty(TEXT);
    }

    public static class DActionDiagramSelectableLabel
    extends DActionDiagramLabel
    implements DSelectable {
        private DActionDiagramEdge edge;
        private ActionDiagramMemberNode parent;

        public void setEdge(DActionDiagramEdge edge) {
            this.edge = edge;
        }

        public DActionDiagramEdge getEdge() {
            return this.edge;
        }

        public void setParent(ActionDiagramMemberNode parent) {
            this.parent = parent;
        }

        public ActionDiagramMemberNode getParent() {
            return this.parent;
        }

        public void select(boolean selected, String type) {
            RGBV lineColor = selected ? (RGBV)this.getProperty(SELECTED_LINE_COLOR) : (RGBV)this.getProperty(LINE_COLOR);
            this.text.setTextColor(lineColor);
        }

        public List<DObject> getSelectedObjects() {
            ArrayList<DObject> selectedObjects = new ArrayList<DObject>();
            selectedObjects.add((DObject)this.text);
            return selectedObjects;
        }
    }
}

