/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.editor.actions;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ScenarioDiagram;
import ro.amiq.pssdt.diagrams.action.editor.DActionDiagramEditorFactory;
import ro.amiq.pssdt.diagrams.action.editor.actions.DActionDiagramPreferencesDialog;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;

public class DScenarioDiagramPreferencesDialog
extends DActionDiagramPreferencesDialog {
    private static final String SHOW_REDUNDANT_PARALLELS_TEXT = "Show redundant parallel nodes";
    private static final String SHOW_DATA_CONNECTIONS_TEXT = "Show data connections";
    private static final String SHOW_ACTION_PATHS_TEXT = "Show action paths";
    private static final String SHOW_LOCKS_AND_SHARES_TEXT = "Show locks and shares";
    private Button showRedundantParallels;
    private Button showDataConnections;
    private Button showActionPaths;
    private Button showLocksAndShares;
    private Button showInputsAndOutputs;

    public DScenarioDiagramPreferencesDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location);
    }

    protected void createMainArea(Composite parent) {
        Composite composite = this.createComposite(parent);
        ScenarioDiagram diagram = (ScenarioDiagram)this.getDiagramEditor().getInput().getDiagram();
        ADPreferenceBundle bundle = diagram.getPreferenceBundle();
        this.showRedundantParallels = this.createPreferenceButton(SHOW_REDUNDANT_PARALLELS_TEXT, composite, bundle.showRedundantParallels);
        this.showDataConnections = this.createPreferenceButton(SHOW_DATA_CONNECTIONS_TEXT, composite, bundle.showDataConnections);
        this.showActionPaths = this.createPreferenceButton(SHOW_ACTION_PATHS_TEXT, composite, bundle.showActionPaths);
        this.showLocksAndShares = this.createPreferenceButton(SHOW_LOCKS_AND_SHARES_TEXT, composite, bundle.showLocksAndShares);
        this.showInputsAndOutputs = this.createPreferenceButton("Show inputs and outputs", composite, bundle.showInputsAndOutputs);
    }

    @Override
    protected void openEditor(boolean newEditor) {
        DActionDiagramEditorFactory editorFactory = null;
        ScenarioDiagram diagram = (ScenarioDiagram)this.getDiagramEditor().getInput().getDiagram();
        ADPreferenceBundle bundle = new ADPreferenceBundle();
        bundle.showRedundantParallels = this.showRedundantParallels.getSelection();
        bundle.showDataConnections = this.showDataConnections.getSelection();
        bundle.showActionPaths = this.showActionPaths.getSelection();
        bundle.showInputsAndOutputs = this.showInputsAndOutputs.getSelection();
        bundle.showLocksAndShares = this.showLocksAndShares.getSelection();
        if (diagram.getIndividualNodeActions() != null && (bundle.showInputsAndOutputs != diagram.getPreferenceBundle().showInputsAndOutputs || bundle.showLocksAndShares != diagram.getPreferenceBundle().showLocksAndShares)) {
            diagram.getIndividualNodeActions().remove((Object)IActionDiagramElement.MemberActionKind.SHOW_LOCKS_AND_SHARES);
            diagram.getIndividualNodeActions().remove((Object)IActionDiagramElement.MemberActionKind.HIDE_LOCKS_AND_SHARES);
            diagram.getIndividualNodeActions().remove((Object)IActionDiagramElement.MemberActionKind.SHOW_INPUTS_AND_OUTPUTS);
            diagram.getIndividualNodeActions().remove((Object)IActionDiagramElement.MemberActionKind.HIDE_INPUTS_AND_OUTPUTS);
        }
        editorFactory = DActionDiagramEditorFactory.newScenarioDiagram(diagram.getRootDescriptor(), diagram.getInstance(), diagram.getSeedHistory(), bundle, diagram.getIndividualNodeActions(), diagram.getRfProject());
        this.close();
        if (editorFactory != null) {
            if (newEditor) {
                editorFactory.openNewEditor();
            } else {
                editorFactory.openReuseEditor(this.getDiagramEditor());
            }
        }
    }
}

