/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.editor.actions;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.utils.DEditorDialog;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ScenarioDiagram;
import ro.amiq.pssdt.diagrams.action.editor.actions.RefreshScenarioDiagram;

public class DScenarioDiagramSeedHistoryDialog
extends DEditorDialog {
    private Combo seedCombo;
    private Text customSeedText;
    private Button keepSeedButton;
    private ScenarioDiagram diagram;

    public DScenarioDiagramSeedHistoryDialog(DDiagramEditor diagramEditor, Point location) {
        super(diagramEditor, location, false);
    }

    protected void createMainArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        Label filtersetLabel = new Label(composite, 0);
        filtersetLabel.setText("Seed");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)filtersetLabel);
        this.seedCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.seedCombo);
        Label filterSetNameLabel = new Label(composite, 0);
        filterSetNameLabel.setText("Custom seed");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)filterSetNameLabel);
        this.customSeedText = new Text(composite, 2052);
        GridDataFactory.fillDefaults().minSize(150, 1).align(4, 4).grab(true, true).applyTo((Control)this.customSeedText);
        this.keepSeedButton = this.createButton(composite, 32, GridDataFactory.fillDefaults().span(5, 1).align(1, 0x1000000).grab(false, false), "Keep current seed", null);
        this.keepSeedButton.setSelection(((ScenarioDiagram)this.getDiagramEditor().getInput().getDiagram()).getPreferenceBundle().keepSeed);
    }

    protected void setDefaults() {
        super.setDefaults();
        this.diagram = (ScenarioDiagram)this.getDiagramEditor().getInput().getDiagram();
        long currentSeed = this.diagram.getSeed();
        List<Long> seedHistory = this.diagram.getSeedHistory();
        int i = seedHistory.size() - 1;
        while (i >= 0) {
            long seed = seedHistory.get(i);
            this.seedCombo.add(String.valueOf(seed));
            --i;
        }
        this.seedCombo.setText(String.valueOf(currentSeed));
    }

    protected void createBottomArea(Composite parent) {
        Composite buttonsComposite = this.createButtonsComposite(parent, 3);
        this.createButton(buttonsComposite, 8, "Cancel", () -> {
            boolean bl = this.close();
        });
        this.createButton(buttonsComposite, 8, "New", () -> this.openEditor(true));
        this.createButton(buttonsComposite, 8, "Apply", () -> this.openEditor(false));
    }

    public void openEditor(boolean newEditor) {
        ADPreferenceBundle bundle = this.diagram.getPreferenceBundle().getCopy();
        bundle.keepSeed = this.keepSeedButton.getSelection();
        Long customSeed = null;
        if (!this.customSeedText.getText().isEmpty()) {
            try {
                customSeed = Long.parseLong(this.customSeedText.getText());
            }
            catch (Exception exception) {
                customSeed = null;
            }
        }
        long seed = customSeed != null ? customSeed : Long.parseLong(this.seedCombo.getText());
        this.close();
        RefreshScenarioDiagram refresh = new RefreshScenarioDiagram(this.getDiagramEditor(), seed, bundle, newEditor);
        refresh.run();
    }
}

