/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.editor.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMessages;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ActionDiagramHelper;
import ro.amiq.pssdt.diagrams.action.ScenarioDiagram;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.elaboration.Solver;
import ro.amiq.pssdt.model.reflection.elaboration.util.ScenarioUtils;

public class RefreshScenarioDiagram
extends Action {
    private final DDiagramEditor diagramEditor;
    private Long seed;
    private boolean newEditor;
    private ADPreferenceBundle bundle;

    public RefreshScenarioDiagram(DDiagramEditor diagramEditor, Long seed, ADPreferenceBundle bundle, boolean newEditor) {
        super(DMessages.DiagramPanel_Refresh_Button_TT, DVTImages.IMG_TAB_GRAPHVIZ_REFRESH);
        this.diagramEditor = diagramEditor;
        this.seed = seed;
        this.bundle = bundle;
        this.newEditor = newEditor;
    }

    public void run() {
        ScenarioDiagram diagram = (ScenarioDiagram)this.diagramEditor.getInput().getDiagram();
        RfProject rfProject = diagram.getRfProject();
        ScenarioUtils.RootDescriptor rootDescriptor = diagram.getRootDescriptor();
        Long keepSeedValue = null;
        if (this.seed != null) {
            keepSeedValue = this.seed;
        } else if (diagram.getPreferenceBundle().keepSeed) {
            keepSeedValue = diagram.getSeed();
        }
        Solver solver = ScenarioUtils.generateScenario(rootDescriptor, keepSeedValue, false);
        solver.notifyUIRunnable(() -> {
            long currentSeed;
            ArrayList<Long> seedHistory = new ArrayList<Long>(diagram.getSeedHistory());
            long l = currentSeed = this.seed != null ? this.seed.longValue() : solver.getSeed();
            if (!seedHistory.contains(currentSeed)) {
                seedHistory.add(currentSeed);
            } else {
                seedHistory.remove(currentSeed);
                seedHistory.add(currentSeed);
            }
            if (seedHistory.size() > 15) {
                seedHistory.remove(0);
            }
            ActionDiagramHelper.makeScenarioDiagramFor(rootDescriptor, solver.getTreeRoot(), seedHistory, this.bundle != null ? this.bundle : diagram.getPreferenceBundle(), rfProject, this.newEditor);
        });
    }
}

