/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.editor.actions.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DMenuItem;
import ro.amiq.dvt.diagrams.editor.DMenuSeparator;
import ro.amiq.dvt.draw.obj.interaction.DSelectable;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.pssdt.diagrams.action.ActivityDiagram;
import ro.amiq.pssdt.diagrams.action.ScenarioDiagram;
import ro.amiq.pssdt.diagrams.action.draw.ActionDiagramDrawUtils;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramContainer;
import ro.amiq.pssdt.diagrams.action.draw.obj.DActionDiagramLabel;
import ro.amiq.pssdt.diagrams.action.editor.actions.menu.DActionDiagramGoToSourceMenuAction;
import ro.amiq.pssdt.diagrams.action.editor.actions.menu.DActionDiagramStepIntoMenuAction;
import ro.amiq.pssdt.diagrams.action.editor.actions.menu.DNodeMembersMenuAction;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;

public class DActionDiagramMenuActionFactory {
    private DActionDiagramMenuActionFactory() {
    }

    public static List<DMenuItem> createActions(DDiagramEditor diagramEditor, Set<DSelectable> selection) {
        DDiagram diagram = diagramEditor.getInput().getDiagram();
        if (!(diagram instanceof ScenarioDiagram) && !(diagram instanceof ActivityDiagram)) {
            return Collections.emptyList();
        }
        ArrayList<DMenuItem> result = new ArrayList<DMenuItem>();
        for (DMenuItem item : DActionDiagramMenuActionFactory.createStepIntoActions(selection, diagram)) {
            if (!item.isVisible()) continue;
            result.add(item);
        }
        for (DMenuItem item : DActionDiagramMenuActionFactory.createGoToSourceActions(selection, diagram)) {
            if (!item.isVisible()) continue;
            result.add(item);
        }
        IActionDiagramElement.MemberActionKind[] memberActionKindArray = IActionDiagramElement.MemberActionKind.values();
        int n = memberActionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            IActionDiagramElement.MemberActionKind kind = memberActionKindArray[n2];
            DNodeMembersMenuAction action = new DNodeMembersMenuAction(diagram, kind, new HashSet<DSelectable>(selection));
            if (action.isVisible()) {
                if (!result.contains(DMenuSeparator.INSTANCE)) {
                    result.add((DMenuItem)DMenuSeparator.INSTANCE);
                }
                result.add((DMenuItem)action);
            }
            ++n2;
        }
        return result;
    }

    private static List<DMenuItem> createGoToSourceActions(Set<DSelectable> selection, DDiagram diagram) {
        ArrayList<IActionDiagramElement> elements = new ArrayList<IActionDiagramElement>();
        ArrayList<GoToInfo> goTos = new ArrayList<GoToInfo>();
        for (DSelectable selectable : selection) {
            if (selectable instanceof DActionDiagramLabel.DActionDiagramSelectableLabel) {
                DActionDiagramLabel.DActionDiagramSelectableLabel label = (DActionDiagramLabel.DActionDiagramSelectableLabel)selectable;
                ActionDiagramMemberNode node = label.getParent();
                if (node == null) continue;
                boolean isFieldLabel = false;
                ActionDiagramMemberNode.MemberKind[] memberKindArray = ActionDiagramMemberNode.MemberKind.values();
                int n = memberKindArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ActionDiagramMemberNode.MemberKind kind = memberKindArray[n2];
                    if (label.getSearchText().trim().startsWith(kind.name())) {
                        isFieldLabel = true;
                    }
                    ++n2;
                }
                if (isFieldLabel && node.getSourceMarker() != null) {
                    goTos.add(node.getSourceMarker());
                    continue;
                }
                if (node.getPoolSourceMarker() == null) continue;
                goTos.add(node.getPoolSourceMarker());
                continue;
            }
            elements.add(ActionDiagramDrawUtils.getADViewSelectable(selectable));
        }
        for (IActionDiagramElement element : elements) {
            if (element == null || !(element instanceof ActionDiagramNode) || ((ActionDiagramNode)element).getSourceMarker() == null) continue;
            goTos.add(((ActionDiagramNode)element).getSourceMarker());
        }
        if (goTos.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DActionDiagramGoToSourceMenuAction(diagram, goTos));
    }

    private static List<DMenuItem> createStepIntoActions(Set<DSelectable> selection, DDiagram diagram) {
        if (!(diagram instanceof ActivityDiagram)) {
            return Collections.emptyList();
        }
        ArrayList<RfElementPath> elementPaths = new ArrayList<RfElementPath>();
        for (DSelectable selectable : selection) {
            RfElementPath elementPath;
            ActivityDiagramNode selectedNode;
            IActionDiagramElement element;
            if (!(selectable instanceof DActionDiagramContainer) || !((element = ActionDiagramDrawUtils.getADViewSelectable(selectable)) instanceof ActivityDiagramNode) || !(selectedNode = (ActivityDiagramNode)element).isCompoundAction() || (elementPath = selectedNode.getActionElementPath()) == null || elementPath.equals((Object)((ActivityDiagram)diagram).getActionElementPath())) continue;
            elementPaths.add(elementPath);
        }
        if (elementPaths.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new DActionDiagramStepIntoMenuAction(diagram, elementPaths));
    }
}

