/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.klay;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.EdgeLabelPlacement;
import de.cau.cs.kieler.kiml.options.EdgeRouting;
import de.cau.cs.kieler.kiml.options.EdgeType;
import de.cau.cs.kieler.kiml.options.HierarchyHandling;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.NodeLabelPlacement;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import de.cau.cs.kieler.kiml.options.SizeOptions;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import de.cau.cs.kieler.klay.layered.p2layers.LayeringStrategy;
import de.cau.cs.kieler.klay.layered.p3order.CrossingMinimizationStrategy;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.ContentAlignment;
import de.cau.cs.kieler.klay.layered.properties.GreedySwitchType;
import de.cau.cs.kieler.klay.layered.properties.Properties;
import de.cau.cs.kieler.klay.layered.properties.SelfLoopPlacement;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.diagrams.klay.model.KLaySize;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.draw.ActionDiagramDrawUtils;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramContainerNode;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;
import ro.amiq.pssdt.diagrams.action.model.ScenarioDiagramNode;
import ro.amiq.pssdt.diagrams.action.rendering.ActionDiagramRenderingUtils;

public class ActionDiagramAdapter {
    public static void setKNodeInfo(KNode kNode, ActionDiagramNode node, ADPreferenceBundle bundle) {
        ActionDiagramAdapter.setKIdentifier((KGraphElement)kNode, ActionDiagramAdapter.getKIdentifier(node));
        ActionDiagramRenderingUtils.renderNode(kNode, node, null, bundle);
        if (kNode.getChildren().isEmpty()) {
            ActionDiagramAdapter.setKLabels((KLabeledGraphElement)kNode, node, bundle.showActionPaths);
        }
        KShapeLayout nodeShapeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        ActionDiagramAdapter.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, ActionDiagramAdapter.getKNodeSizeOptions(), ActionDiagramAdapter.getKNodeSizeConstraint(), ActionDiagramAdapter.getKNodeHierarchyHandling(), ActionDiagramAdapter.getKNodePortContraints());
        ActionDiagramAdapter.setLNodeLayeredOptions(nodeShapeLayout);
    }

    public static void setMemberKNodeInfo(KNode kNode, ActionDiagramNode node, ActionDiagramMemberNode member, ADPreferenceBundle bundle) {
        ActionDiagramAdapter.setKIdentifier((KGraphElement)kNode, node.getIdentifier());
        ActionDiagramRenderingUtils.renderNode(kNode, node, member, bundle);
        ActionDiagramAdapter.setMemberKLabels(kNode, member);
        KShapeLayout nodeShapeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        ActionDiagramAdapter.setKNodeLayoutOptions(nodeShapeLayout, Direction.RIGHT, ActionDiagramAdapter.getKNodeSizeOptions(), ActionDiagramAdapter.getKNodeSizeConstraint(), ActionDiagramAdapter.getKNodeHierarchyHandling(), ActionDiagramAdapter.getKNodePortContraints());
        ActionDiagramAdapter.setLNodeLayeredOptions(nodeShapeLayout);
    }

    private static void setMemberKLabels(KNode kNode, ActionDiagramMemberNode member) {
        StringBuilder sb = new StringBuilder();
        sb.append(member.getKind().name());
        sb.append(" ");
        if (member.getStructKind() != null) {
            sb.append(member.getStructKind().name());
            sb.append(" ");
        }
        if (member.getType() != null) {
            sb.append(member.getType());
            sb.append(" ");
        }
        sb.append(member.getIdentifier());
        ActionDiagramAdapter.setKLabel(member, sb.toString(), (KLabeledGraphElement)kNode, true);
        if (member.getPool() != null) {
            ActionDiagramAdapter.setKLabel(member, member.getPool(), (KLabeledGraphElement)kNode, true);
        }
    }

    public static void setKEdgeInfo(KEdge kEdge, ActionDiagramEdge edge, EdgeType edgeType) {
        ActionDiagramAdapter.setKIdentifier((KGraphElement)kEdge, ActionDiagramAdapter.getKIdentifier(edge));
        if (edge != null && edge.isFlowEdge()) {
            ActionDiagramRenderingUtils.renderFlowEdge(kEdge);
            if (edgeType == null) {
                edgeType = EdgeType.ASSOCIATION;
            }
        } else {
            ActionDiagramRenderingUtils.renderDataEdge(kEdge);
            if (edgeType == null) {
                edgeType = EdgeType.DIRECTED;
            }
        }
        ActionDiagramAdapter.setKLabels((KLabeledGraphElement)kEdge, edge, false);
        ActionDiagramAdapter.setKEdgeLayoutOptions((KEdgeLayout)kEdge.getData(KEdgeLayout.class), edgeType, ActionDiagramAdapter.getKEdgeThickness());
    }

    private static void setKNodeLayoutOptions(KShapeLayout nodeLayout, Direction direction, EnumSet<SizeOptions> nodeSizeOptions, EnumSet<SizeConstraint> nodeSizeContraints, HierarchyHandling hierarchyHandling, PortConstraints portConstraints) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)direction);
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        nodeLayout.setProperty(LayoutOptions.SIZE_OPTIONS, nodeSizeOptions);
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, nodeSizeContraints);
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)portConstraints);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)hierarchyHandling);
    }

    private static void setKEdgeLayoutOptions(KEdgeLayout edgeLayout, EdgeType edgeType, float edgeThickness) {
        if (edgeLayout == null) {
            return;
        }
        if (edgeType != null) {
            edgeLayout.setProperty(LayoutOptions.EDGE_TYPE, (Object)edgeType);
        }
        edgeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)ActionDiagramAdapter.getEdgeRouting());
        edgeLayout.setProperty(LayoutOptions.THICKNESS, (Object)Float.valueOf(Math.max(edgeThickness, 1.0f)));
    }

    private static void setKLabels(KLabeledGraphElement parent, IActionDiagramElement object, boolean showPath) {
        if (parent == null || object == null) {
            return;
        }
        if (object instanceof ActionDiagramNode) {
            ActionDiagramNode node = (ActionDiagramNode)object;
            String text = node.getIdentifier();
            if (text == null) {
                return;
            }
            boolean isInferred = false;
            if (node instanceof ScenarioDiagramNode) {
                isInferred = ((ScenarioDiagramNode)node).isInferred();
            }
            ActionDiagramAdapter.setKLabel(object, isInferred ? "*" + text : text, parent, false);
            if (showPath) {
                ActionDiagramAdapter.setKLabel(object, node.getPath(), parent, false);
            }
        } else if (object instanceof ActionDiagramEdge) {
            ActionDiagramEdge edge = (ActionDiagramEdge)object;
            String text = edge.getLabel();
            if (text == null) {
                return;
            }
            ActionDiagramAdapter.setKLabel(edge, text, parent, true);
        }
    }

    private static void setKLabel(IActionDiagramElement object, String text, KLabeledGraphElement parent, boolean selectable) {
        if (text == null) {
            return;
        }
        KLabel label = KimlUtil.createInitializedLabel((KLabeledGraphElement)parent);
        if (object != null && selectable) {
            label.getData().add((Object)KLayWrapper.of((Object)object));
        }
        String padding = " ";
        label.setText(String.valueOf(padding) + text + padding);
        ActionDiagramAdapter.setKLabelInfo(label, object, selectable);
    }

    private static void setKLabelInfo(KLabel label, IActionDiagramElement object, boolean selectable) {
        ActionDiagramAdapter.setKIdentifier((KGraphElement)label, ActionDiagramAdapter.getKIdentifier(object));
        ActionDiagramRenderingUtils.renderLabel(label, object, selectable);
        ActionDiagramAdapter.setKLabelLayoutOptions((KShapeLayout)label.getData(KShapeLayout.class), ActionDiagramAdapter.getKLabelFixedSize(label), label, object);
    }

    private static PortConstraints getKNodePortContraints() {
        return PortConstraints.FIXED_SIDE;
    }

    private static void setKIdentifier(KGraphElement kElement, String id) {
        KIdentifier identifier = (KIdentifier)kElement.getData(KIdentifier.class);
        if (identifier != null) {
            return;
        }
        identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
        identifier.setId(id);
        kElement.getData().add((Object)identifier);
    }

    private static String getKIdentifier(IActionDiagramElement element) {
        if (element == null) {
            return "Root";
        }
        return element.getIdentifier();
    }

    private static void setLNodeLayeredOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
    }

    private static HierarchyHandling getKNodeHierarchyHandling() {
        return HierarchyHandling.INHERIT;
    }

    private static EnumSet<SizeConstraint> getKNodeSizeConstraint() {
        return EnumSet.of(SizeConstraint.MINIMUM_SIZE, SizeConstraint.NODE_LABELS);
    }

    private static EnumSet<SizeOptions> getKNodeSizeOptions() {
        return EnumSet.of(SizeOptions.DEFAULT_MINIMUM_SIZE);
    }

    private static void setKLabelLayoutOptions(KShapeLayout layout, Point size, KLabel label, IActionDiagramElement object) {
        if (layout == null) {
            return;
        }
        layout.setSize((float)size.x, (float)size.y);
        String text = label.getText();
        if (text.trim().length() > 0 && (object instanceof ActionDiagramNode || object instanceof ActionDiagramMemberNode)) {
            layout.setProperty(LayoutOptions.NODE_LABEL_PLACEMENT, (Object)NodeLabelPlacement.insideTopCenter());
        }
        layout.setProperty(LayoutOptions.EDGE_LABEL_PLACEMENT, (Object)EdgeLabelPlacement.CENTER);
    }

    private static Point getKLabelFixedSize(KLabel label) {
        if (label == null) {
            return new Point(0, 0);
        }
        FontData fontData = ActionDiagramRenderingUtils.getFontData(label);
        if (fontData == null) {
            return new Point(0, 0);
        }
        return FontFactory.getInstance().stringExtent(label.getText(), fontData);
    }

    private static float getKEdgeThickness() {
        return 1.0f;
    }

    public static void setKPortInfo(KPort port, String portID, boolean isOutgoing, boolean isDataPort) {
        ActionDiagramAdapter.setKIdentifier((KGraphElement)port, portID);
        ActionDiagramRenderingUtils.renderPort(port);
        ActionDiagramAdapter.setKPortLayoutOptions((KShapeLayout)port.getData(KShapeLayout.class), ActionDiagramAdapter.getKPortSide(isOutgoing, isDataPort));
    }

    private static void setKPortLayoutOptions(KShapeLayout portLayout, PortSide side) {
        if (portLayout == null) {
            return;
        }
        portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)(side != null ? side : PortSide.UNDEFINED));
        portLayout.setSize(0.0f, 0.0f);
    }

    private static PortSide getKPortSide(boolean isOutgoing, boolean isDataPort) {
        return isOutgoing ? (isDataPort ? PortSide.EAST : PortSide.SOUTH) : (isDataPort ? PortSide.WEST : PortSide.NORTH);
    }

    public static void setKNodesSpacingInfo(Map<ActionDiagramNode, KNode> kNodes) {
        if (kNodes == null || kNodes.isEmpty()) {
            return;
        }
        for (KNode kNode : kNodes.values()) {
            KShapeLayout childLayout;
            KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
            if (nodeLayout == null) continue;
            KLaySize size = ActionDiagramAdapter.getKNodeSpacingInfo(nodeLayout, (List<KLabel>)kNode.getLabels(), 4.0f);
            for (KNode child : kNode.getChildren()) {
                childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
                if (childLayout == null) continue;
                KLaySize localNew = ActionDiagramAdapter.getKNodeSpacingInfo(childLayout, (List<KLabel>)child.getLabels(), 4.0f);
                childLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(localNew.height));
                size.width = Math.max(size.width, localNew.width);
                size.height += localNew.height;
            }
            for (KNode child : kNode.getChildren()) {
                childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
                if (childLayout == null) continue;
                childLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
            }
            nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(size.height));
            nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
        }
    }

    private static KLaySize getKNodeSpacingInfo(KShapeLayout nodeLayout, List<KLabel> labels, float labelSpacing) {
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(labelSpacing));
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(0.0f));
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(0.0f));
        KLaySize nLSpace = ActionDiagramAdapter.computeSpaceForNodeLabels(labels, labelSpacing);
        return nLSpace;
    }

    private static KLaySize computeSpaceForNodeLabels(List<KLabel> nodeLabels, float labelSpacing) {
        KLaySize size = KLaySize.of((float)0.0f, (float)0.0f);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return size;
        }
        for (KLabel nodeLabel : nodeLabels) {
            KShapeLayout labelLayout = (KShapeLayout)nodeLabel.getData(KShapeLayout.class);
            float lWidth = labelLayout.getWidth() + 2.0f * labelSpacing;
            float lHeight = labelLayout.getHeight() + 2.0f * labelSpacing;
            if (size.width < lWidth) {
                size.width = lWidth;
            }
            if (nodeLabel.getText().trim().isEmpty()) continue;
            size.height += lHeight;
        }
        return size;
    }

    public static void setRootKNodeInfo(String title, KNode root) {
        if (root == null) {
            return;
        }
        Object diagramObject = ActionDiagramDrawUtils.getActionDiagramObjectFromKElement((KGraphElement)root);
        if (diagramObject instanceof ActivityDiagramContainerNode) {
            return;
        }
        ActionDiagramRenderingUtils.renderDummyGate(root);
        ActionDiagramAdapter.setKLabel(null, title, (KLabeledGraphElement)root, false);
        KShapeLayout layout = (KShapeLayout)root.getData(KShapeLayout.class);
        if (layout == null) {
            return;
        }
        ActionDiagramAdapter.setRootKNodeLayoutOptions(layout);
        ActionDiagramAdapter.setRootLNodeLayeredOptions(layout, ActionDiagramAdapter.getRootKNodePlacement());
        ActionDiagramAdapter.setRootKNodeSpacingOptions(layout);
    }

    private static void setRootLNodeLayeredOptions(KShapeLayout nodeLayout, NodePlacementStrategy nodePlacementStrategy) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(Properties.NODE_PLACER, (Object)nodePlacementStrategy);
        nodeLayout.setProperty(Properties.GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED_BEST_OF_UP_OR_DOWN);
        nodeLayout.setProperty(Properties.NODE_LAYERING, (Object)LayeringStrategy.NETWORK_SIMPLEX);
        nodeLayout.setProperty(Properties.CROSS_MIN, (Object)CrossingMinimizationStrategy.LAYER_SWEEP);
        nodeLayout.setProperty(Properties.FEEDBACK_EDGES, (Object)true);
        nodeLayout.setProperty(Properties.SPLINE_SELF_LOOP_PLACEMENT, (Object)SelfLoopPlacement.EQUALLY_DISTRIBUTED);
    }

    private static void setRootKNodeSpacingOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(50.0f));
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(12.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_NODE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR, (Object)Float.valueOf(1.0f));
    }

    private static NodePlacementStrategy getRootKNodePlacement() {
        return NodePlacementStrategy.BRANDES_KOEPF;
    }

    private static EdgeRouting getEdgeRouting() {
        return EdgeRouting.ORTHOGONAL;
    }

    private static void setRootKNodeLayoutOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)Direction.DOWN);
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)ActionDiagramAdapter.getEdgeRouting());
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        nodeLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
    }

    protected static void setContainerKNodeInfo(KNode kNode, ActivityDiagramContainerNode node) {
        if (kNode == null || node == null) {
            return;
        }
        ActionDiagramAdapter.setKIdentifier((KGraphElement)kNode, ActionDiagramAdapter.getKIdentifier(node));
        ActionDiagramAdapter.setKLabel(node, node.getIdentifier(), (KLabeledGraphElement)kNode, false);
        ActionDiagramRenderingUtils.renderContainerNode(kNode);
        KShapeLayout nodeShapeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        ActionDiagramAdapter.setContainerKNodeLayoutOptions(nodeShapeLayout);
        ActionDiagramAdapter.setContainerKNodeLayeredOptions(nodeShapeLayout);
        ActionDiagramAdapter.setContainerKNodeSpacingInfo(kNode);
    }

    private static void setContainerKNodeLayoutOptions(KShapeLayout nodeLayout) {
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.DIRECTION, (Object)Direction.DOWN);
        nodeLayout.setProperty(LayoutOptions.EDGE_ROUTING, (Object)ActionDiagramAdapter.getEdgeRouting());
        nodeLayout.setProperty(LayoutOptions.ALGORITHM, (Object)"de.cau.cs.kieler.klay.layered");
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, ActionDiagramAdapter.getKNodeSizeConstraint());
        nodeLayout.setProperty(LayoutOptions.PORT_CONSTRAINTS, (Object)ActionDiagramAdapter.getKNodePortContraints());
        nodeLayout.setProperty(LayoutOptions.EXPAND_NODES, (Object)true);
        nodeLayout.setProperty(LayoutOptions.HIERARCHY_HANDLING, (Object)HierarchyHandling.INCLUDE_CHILDREN);
        nodeLayout.setProperty(Properties.CONTENT_ALIGNMENT, (Object)ContentAlignment.centerCenter());
    }

    private static void setContainerKNodeLayeredOptions(KShapeLayout nodeLayout) {
        ActionDiagramAdapter.setRootLNodeLayeredOptions(nodeLayout, ActionDiagramAdapter.getRootKNodePlacement());
    }

    private static void setContainerKNodeSpacingInfo(KNode kNode) {
        if (kNode == null) {
            return;
        }
        KShapeLayout nodeLayout = (KShapeLayout)kNode.getData(KShapeLayout.class);
        if (nodeLayout == null) {
            return;
        }
        nodeLayout.setProperty(LayoutOptions.LABEL_SPACING, (Object)Float.valueOf(4.0f));
        nodeLayout.setProperty(LayoutOptions.SPACING, (Object)Float.valueOf(50.0f));
        nodeLayout.setProperty(LayoutOptions.BORDER_SPACING, (Object)Float.valueOf(12.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_NODE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty((IProperty)Properties.EDGE_SPACING_FACTOR, (Object)Float.valueOf(1.0f));
        nodeLayout.setProperty(Properties.OBJ_SPACING_IN_LAYER_FACTOR, (Object)Float.valueOf(1.0f));
        KLaySize size = ActionDiagramAdapter.computeSpaceForNodeLabels((List<KLabel>)kNode.getLabels(), 4.0f);
        EList children = kNode.getChildren();
        if (children == null) {
            nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(size.height));
            nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
            return;
        }
        for (KNode child : children) {
            KShapeLayout childLayout = (KShapeLayout)child.getData(KShapeLayout.class);
            if (childLayout == null) continue;
            KLaySize localNew = ActionDiagramAdapter.getKNodeSpacingInfo(childLayout, (List<KLabel>)child.getLabels(), 4.0f);
            childLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(localNew.height));
            size.width = Math.max(size.width, localNew.width);
            size.height += localNew.height;
        }
        nodeLayout.setProperty(LayoutOptions.MIN_HEIGHT, (Object)Float.valueOf(size.height));
        nodeLayout.setProperty(LayoutOptions.MIN_WIDTH, (Object)Float.valueOf(size.width));
    }
}

