/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.klay;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.diagrams.DProgressMonitor;
import ro.amiq.dvt.diagrams.exceptions.DCanceledException;
import ro.amiq.dvt.diagrams.klay.model.KLayWrapper;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.klay.ActionDiagramAdapter;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramContainerNode;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;

public enum ActionDiagramKLayConverter {
    INSTANCE;


    public KNode convertScenarioRoot(ActionDiagramNode root, ADPreferenceBundle preferenceBundle, Map<IActionDiagramElement.MemberActionKind, Set<Integer>> individualNodeActions, DProgressMonitor monitor) throws DCanceledException {
        monitor.checkCanceled();
        KNode kRoot = KimlUtil.createInitializedNode();
        LinkedHashMap<ActionDiagramNode, KNode> kNodes = new LinkedHashMap<ActionDiagramNode, KNode>();
        this.createOrGetKnode(root, individualNodeActions, kRoot, preferenceBundle, kNodes);
        ActionDiagramAdapter.setKNodesSpacingInfo(kNodes);
        return kRoot;
    }

    public KNode convertActivityContainer(ActivityDiagramContainerNode diagramContainer, ADPreferenceBundle preferenceBundle, DProgressMonitor monitor) throws DCanceledException {
        if (diagramContainer == null || preferenceBundle == null || monitor == null) {
            return null;
        }
        monitor.checkCanceled();
        KNode dummyRoot = KimlUtil.createInitializedNode();
        KNode containerKNode = KimlUtil.createInitializedNode();
        containerKNode.getData().add((Object)KLayWrapper.of((Object)diagramContainer));
        dummyRoot.getChildren().add((Object)containerKNode);
        LinkedHashMap<ActionDiagramNode, KNode> kNodes = new LinkedHashMap<ActionDiagramNode, KNode>();
        kNodes.put(diagramContainer, containerKNode);
        for (ActionDiagramEdge edge : diagramContainer.getDataEdges()) {
            this.createKEdge(edge, dummyRoot, preferenceBundle, null, kNodes);
        }
        ActionDiagramAdapter.setKNodesSpacingInfo(kNodes);
        kNodes.clear();
        this.createOrGetKnode(diagramContainer.getActivityRootNode(), null, containerKNode, preferenceBundle, kNodes);
        ActionDiagramAdapter.setKNodesSpacingInfo(kNodes);
        ActionDiagramAdapter.setContainerKNodeInfo(containerKNode, diagramContainer);
        return dummyRoot;
    }

    private KNode createOrGetKnode(ActionDiagramNode adNode, Map<IActionDiagramElement.MemberActionKind, Set<Integer>> individualNodeActions, KNode dummyRoot, ADPreferenceBundle preferenceBundle, Map<ActionDiagramNode, KNode> kNodes) {
        if (adNode == null) {
            return null;
        }
        if (kNodes.containsKey(adNode)) {
            return kNodes.get(adNode);
        }
        KNode node = KimlUtil.createInitializedNode();
        kNodes.put(adNode, node);
        node.getData().add((Object)KLayWrapper.of((Object)adNode));
        KNode childNode = KimlUtil.createInitializedNode();
        node.getChildren().add((Object)childNode);
        childNode.getData().add((Object)KLayWrapper.of((Object)adNode));
        ActionDiagramAdapter.setKNodeInfo(childNode, adNode, preferenceBundle);
        boolean showLocksAndShares = preferenceBundle.showLocksAndShares;
        boolean showInputsAndOutputs = preferenceBundle.showInputsAndOutputs;
        if (individualNodeActions != null) {
            Set<Integer> shownLS = individualNodeActions.get((Object)IActionDiagramElement.MemberActionKind.SHOW_LOCKS_AND_SHARES);
            Set<Integer> hiddenLS = individualNodeActions.get((Object)IActionDiagramElement.MemberActionKind.HIDE_LOCKS_AND_SHARES);
            if (shownLS != null && shownLS.contains(adNode.getIndex())) {
                showLocksAndShares = true;
            }
            if (hiddenLS != null && hiddenLS.contains(adNode.getIndex())) {
                showLocksAndShares = false;
            }
            Set<Integer> shownIO = individualNodeActions.get((Object)IActionDiagramElement.MemberActionKind.SHOW_INPUTS_AND_OUTPUTS);
            Set<Integer> hiddenIO = individualNodeActions.get((Object)IActionDiagramElement.MemberActionKind.HIDE_INPUTS_AND_OUTPUTS);
            if (shownIO != null && shownIO.contains(adNode.getIndex())) {
                showInputsAndOutputs = true;
            }
            if (hiddenIO != null && hiddenIO.contains(adNode.getIndex())) {
                showInputsAndOutputs = false;
            }
        }
        if (showLocksAndShares) {
            for (ActionDiagramMemberNode member : adNode.getMembers(ActionDiagramMemberNode.MemberKind.LOCK)) {
                KNode lockNode = KimlUtil.createInitializedNode();
                node.getChildren().add((Object)lockNode);
                lockNode.getData().add((Object)KLayWrapper.of((Object)member));
                ActionDiagramAdapter.setMemberKNodeInfo(lockNode, adNode, member, preferenceBundle);
            }
            for (ActionDiagramMemberNode member : adNode.getMembers(ActionDiagramMemberNode.MemberKind.SHARE)) {
                KNode shareNode = KimlUtil.createInitializedNode();
                node.getChildren().add((Object)shareNode);
                shareNode.getData().add((Object)KLayWrapper.of((Object)member));
                ActionDiagramAdapter.setMemberKNodeInfo(shareNode, adNode, member, preferenceBundle);
            }
        }
        if (showInputsAndOutputs) {
            for (ActionDiagramMemberNode member : adNode.getMembers(ActionDiagramMemberNode.MemberKind.INPUT)) {
                KNode inputNode = KimlUtil.createInitializedNode();
                node.getChildren().add((Object)inputNode);
                inputNode.getData().add((Object)KLayWrapper.of((Object)member));
                ActionDiagramAdapter.setMemberKNodeInfo(inputNode, adNode, member, preferenceBundle);
            }
            for (ActionDiagramMemberNode member : adNode.getMembers(ActionDiagramMemberNode.MemberKind.OUTPUT)) {
                KNode outputNode = KimlUtil.createInitializedNode();
                node.getChildren().add((Object)outputNode);
                outputNode.getData().add((Object)KLayWrapper.of((Object)member));
                ActionDiagramAdapter.setMemberKNodeInfo(outputNode, adNode, member, preferenceBundle);
            }
        }
        dummyRoot.getChildren().add((Object)node);
        for (ActionDiagramEdge edge : adNode.getDataEdges()) {
            this.createKEdge(edge, dummyRoot, preferenceBundle, individualNodeActions, kNodes);
        }
        for (ActionDiagramEdge edge : adNode.getFlowEdges()) {
            this.createKEdge(edge, dummyRoot, preferenceBundle, individualNodeActions, kNodes);
        }
        ActionDiagramAdapter.setKNodeInfo(node, adNode, preferenceBundle);
        ActionDiagramAdapter.setRootKNodeInfo("Root", dummyRoot);
        return node;
    }

    private void createKEdge(ActionDiagramEdge adEdge, KNode dummyRoot, ADPreferenceBundle preferenceBundle, Map<IActionDiagramElement.MemberActionKind, Set<Integer>> individualNodeActions, Map<ActionDiagramNode, KNode> kNodes) {
        KEdge edge = KimlUtil.createInitializedEdge();
        edge.getData().add((Object)KLayWrapper.of((Object)adEdge));
        KNode sourceNode = this.createOrGetKnode(adEdge.getSource(), individualNodeActions, dummyRoot, preferenceBundle, kNodes);
        KNode destinationNode = this.createOrGetKnode(adEdge.getDestination(), individualNodeActions, dummyRoot, preferenceBundle, kNodes);
        edge.setSource(sourceNode);
        KPort sourcePort = KimlUtil.createInitializedPort();
        sourceNode.getPorts().add((Object)sourcePort);
        edge.setSourcePort(sourcePort);
        ActionDiagramAdapter.setKPortInfo(sourcePort, String.valueOf(adEdge.getIdentifier()) + ".source", true, false);
        edge.setTarget(destinationNode);
        KPort targetPort = KimlUtil.createInitializedPort();
        destinationNode.getPorts().add((Object)targetPort);
        edge.setTargetPort(targetPort);
        ActionDiagramAdapter.setKPortInfo(targetPort, String.valueOf(adEdge.getIdentifier()) + ".target", false, false);
        ActionDiagramAdapter.setKEdgeInfo(edge, adEdge, null);
    }
}

