/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;

public abstract class ActionDiagramNode
implements IActionDiagramElement {
    private NodeKind kind;
    private String name;
    private String path;
    private GoToInfo source;
    private int index;
    private Set<ActionDiagramEdge> dataEdges;
    private Set<ActionDiagramEdge> flowEdges;
    private EnumMap<ActionDiagramMemberNode.MemberKind, List<ActionDiagramMemberNode>> members;
    private List<ActionDiagramNode> parents;
    private ActionDiagramNode parallelEnd;
    private String inspectInfo;

    protected ActionDiagramNode(String name, String path, ActionDiagramNode parent, NodeKind kind) {
        this.name = name;
        this.path = path;
        this.kind = kind;
        this.addParent(parent);
    }

    public void addDataEdge(ActionDiagramEdge edge) {
        if (edge == null || edge.getKind() == ActionDiagramEdge.EdgeKind.FLOW) {
            return;
        }
        if (this.dataEdges == null) {
            this.dataEdges = new LinkedHashSet<ActionDiagramEdge>();
        }
        this.dataEdges.add(edge);
    }

    public void addFlowEdge(ActionDiagramEdge edge) {
        if (edge == null || edge.getKind() == ActionDiagramEdge.EdgeKind.DATA) {
            return;
        }
        if (this.flowEdges == null) {
            this.flowEdges = new LinkedHashSet<ActionDiagramEdge>();
        }
        this.flowEdges.add(edge);
    }

    public void setParallelEnd(ActionDiagramNode node) {
        if (this.kind != NodeKind.PARALLEL || node.kind != NodeKind.PARALLEL_END) {
            return;
        }
        this.parallelEnd = node;
    }

    public ActionDiagramNode getParallelEnd() {
        return this.parallelEnd;
    }

    public NodeKind getKind() {
        return this.kind;
    }

    @Override
    public String getIdentifier() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int value) {
        this.index = value;
    }

    public String getPath() {
        return this.path != null ? this.path : "";
    }

    public Set<ActionDiagramEdge> getDataEdges() {
        return this.dataEdges != null ? this.dataEdges : Collections.emptySet();
    }

    public Set<ActionDiagramEdge> getFlowEdges() {
        return this.flowEdges != null ? this.flowEdges : Collections.emptySet();
    }

    public List<ActionDiagramNode> getParents() {
        return this.parents != null ? this.parents : Collections.emptyList();
    }

    public List<ActionDiagramMemberNode> getMembers(ActionDiagramMemberNode.MemberKind kind) {
        return this.members != null ? (this.members.get((Object)kind) != null ? this.members.get((Object)kind) : Collections.emptyList()) : Collections.emptyList();
    }

    public void addMember(ActionDiagramMemberNode member) {
        if (member == null) {
            return;
        }
        if (this.members == null) {
            this.members = new EnumMap(ActionDiagramMemberNode.MemberKind.class);
        }
        if (this.members.get((Object)member.getKind()) == null) {
            this.members.put(member.getKind(), new ArrayList());
        }
        this.members.get((Object)member.getKind()).add(member);
    }

    public void addParent(ActionDiagramNode parent) {
        if (parent == null) {
            return;
        }
        if (this.parents == null) {
            this.parents = new ArrayList<ActionDiagramNode>();
        }
        this.parents.add(parent);
    }

    public GoToInfo getSourceMarker() {
        return this.source;
    }

    public void setSourceMarker(GoToInfo marker) {
        this.source = marker;
    }

    public boolean isActionNode() {
        return this.kind == NodeKind.ACTION;
    }

    public boolean isPoolNode() {
        return this.kind == NodeKind.POOL;
    }

    public boolean isParallelNode() {
        return this.kind == NodeKind.PARALLEL;
    }

    public boolean isParallelEndNode() {
        return this.kind == NodeKind.PARALLEL_END;
    }

    public boolean isRuntimeIfNode() {
        return this.kind == NodeKind.RUNTIME_IF;
    }

    public boolean isRuntimeIfEndNode() {
        return this.kind == NodeKind.RUNTIME_IF_END;
    }

    public boolean isRuntimeWhileNode() {
        return this.kind == NodeKind.RUNTIME_WHILE;
    }

    public boolean isRuntimeWhileEndNode() {
        return this.kind == NodeKind.RUNTIME_WHILE_END;
    }

    public boolean isRuntimeMatchNode() {
        return this.kind == NodeKind.RUNTIME_MATCH;
    }

    public boolean isRuntimeMatchEndNode() {
        return this.kind == NodeKind.RUNTIME_MATCH_END;
    }

    public boolean isSchedulingNode() {
        return this.kind == NodeKind.SCHEDULE;
    }

    public boolean isRootNode() {
        return this.kind == NodeKind.ROOT;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.index).append(" ").append(this.name).append(" ").append(this.kind.name());
        if (this.members != null) {
            for (ActionDiagramMemberNode.MemberKind kind : this.members.keySet()) {
                for (ActionDiagramMemberNode member : this.getMembers(kind)) {
                    result.append("\n").append(member.toString());
                }
            }
        }
        return result.toString();
    }

    public void setInspectInfo(String inspectInfo) {
        this.inspectInfo = inspectInfo;
    }

    public String getInspectInfo() {
        return this.inspectInfo;
    }

    public static enum NodeKind {
        ACTION,
        POOL,
        PARALLEL,
        PARALLEL_END,
        SCHEDULE,
        ROOT,
        RUNTIME_IF,
        RUNTIME_IF_END,
        RUNTIME_WHILE,
        RUNTIME_WHILE_END,
        RUNTIME_MATCH,
        RUNTIME_MATCH_END;

    }
}

