/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.model;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.ActivityDiagram;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramContainerNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramUtils;
import ro.amiq.pssdt.model.reflection.BlockInfo;
import ro.amiq.pssdt.model.reflection.RfBlock;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;

public enum ActivityDiagramModel {
    INSTANCE;


    public ActivityDiagramContainerNode createRoot(ActivityDiagram diagram) {
        if (diagram == null) {
            return null;
        }
        RfStruct rootAction = diagram.getRootAction();
        if (rootAction == null) {
            return null;
        }
        ActivityDiagramContainerNode root = new ActivityDiagramContainerNode(rootAction);
        this.expandAction(root, rootAction, diagram.getPreferenceBundle());
        this.addInputOutputNodes(root, rootAction, diagram.getPreferenceBundle());
        return root;
    }

    private void expandAction(ActivityDiagramContainerNode containerNode, RfStruct rootAction, ADPreferenceBundle prefBundle) {
        ActivityDiagramNode parent;
        List<RfDefElement> activities = rootAction.getActivities();
        if (activities == null || activities.isEmpty()) {
            return;
        }
        ActionDiagramNode lastNode = parent = new ActivityDiagramNode(null, null, null);
        for (RfDefElement activity : activities) {
            Collection<RfDefElement> children = activity.getChildren();
            if (children == null || children.isEmpty()) continue;
            for (RfDefElement child : children) {
                RfNamedElement namedElement = child.getNamedElement();
                if (!(namedElement instanceof RfBlock)) continue;
                lastNode = this.expandSequential(lastNode, (RfBlock)namedElement, prefBundle);
            }
        }
        Set<ActionDiagramEdge> parentFlowEdges = parent.getFlowEdges();
        if (parentFlowEdges == null || parentFlowEdges.size() != 1) {
            return;
        }
        ActionDiagramNode activityRootNode = parentFlowEdges.iterator().next().getDestination();
        if (activityRootNode instanceof ActivityDiagramNode) {
            containerNode.setActivityRootNode((ActivityDiagramNode)activityRootNode);
        }
    }

    private void addInputOutputNodes(ActionDiagramNode root, RfStruct action, ADPreferenceBundle prefBundle) {
        if (!prefBundle.showInputsAndOutputs) {
            return;
        }
        List<RfField> inputPorts = ActivityDiagramUtils.getActionInputPorts(action);
        for (RfField inputPort : inputPorts) {
            ActivityDiagramNode inputNode = new ActivityDiagramNode(inputPort.getAssociatedTypeName(), null, ActionDiagramNode.NodeKind.POOL);
            root.addDataEdge(new ActionDiagramEdge(inputNode, root, inputPort.getNameForDiagram(), ActionDiagramEdge.EdgeKind.DATA));
        }
        List<RfField> outputPorts = ActivityDiagramUtils.getActionOutputPorts(action);
        for (RfField outputPort : outputPorts) {
            ActivityDiagramNode outputNode = new ActivityDiagramNode(outputPort.getAssociatedTypeName(), null, ActionDiagramNode.NodeKind.POOL);
            root.addDataEdge(new ActionDiagramEdge(root, outputNode, outputPort.getNameForDiagram(), ActionDiagramEdge.EdgeKind.DATA));
        }
    }

    private ActionDiagramNode expandSequential(ActionDiagramNode parent, RfBlock block, ADPreferenceBundle prefBundle) {
        if (block == null) {
            return null;
        }
        BlockInfo blockInfo = block.getBlockInfo();
        if (blockInfo == null) {
            return this.createActionNode(block, block.getInstanceScopeName(), parent, prefBundle);
        }
        if (blockInfo == BlockInfo.DO) {
            return this.createActionNode(block, block.isAnonymous() ? null : block.getName(), parent, prefBundle);
        }
        boolean showAsParallel = blockInfo == BlockInfo.PARALLEL || blockInfo == BlockInfo.SELECT || blockInfo == BlockInfo.MATCH;
        return this.expandActivityStatement(parent, block, showAsParallel, prefBundle);
    }

    private ActionDiagramNode createActionNode(RfBlock block, String instanceScopeName, ActionDiagramNode parent, ADPreferenceBundle prefBundle) {
        if (block == null) {
            return parent;
        }
        RfNamedElement constraintScope = block.getConstraintScope();
        if (!(constraintScope instanceof RfStruct)) {
            return parent;
        }
        RfStruct struct = (RfStruct)constraintScope;
        if (!struct.isAction(true)) {
            return parent;
        }
        String nodeName = ActivityDiagramUtils.getNodeName(struct, instanceScopeName);
        ActivityDiagramNode childNode = new ActivityDiagramNode(nodeName, parent, ActionDiagramNode.NodeKind.ACTION);
        childNode.setAction(struct);
        parent.addFlowEdge(new ActionDiagramEdge(parent, childNode, null, ActionDiagramEdge.EdgeKind.FLOW));
        this.addInputOutputNodes(childNode, struct, prefBundle);
        return childNode;
    }

    private ActionDiagramNode expandActivityStatement(ActionDiagramNode parent, RfBlock block, boolean showAsParallel, ADPreferenceBundle prefBundle) {
        if (block == null) {
            return parent;
        }
        BlockInfo blockInfo = block.getBlockInfo();
        if (blockInfo == null) {
            return parent;
        }
        Collection<RfNamedElement> localMembers = block.getLocalMembers();
        if (localMembers == null || localMembers.isEmpty()) {
            return parent;
        }
        ActivityDiagramNode startNode = new ActivityDiagramNode("[" + blockInfo.toString() + "]", parent, ActionDiagramNode.NodeKind.PARALLEL);
        parent.addFlowEdge(new ActionDiagramEdge(parent, startNode, null, ActionDiagramEdge.EdgeKind.FLOW));
        ActivityDiagramNode endNode = new ActivityDiagramNode("[" + blockInfo.toString() + " end]", null, ActionDiagramNode.NodeKind.PARALLEL_END);
        startNode.setBlock(block);
        if (showAsParallel) {
            startNode.setParallelEnd(endNode);
        }
        ActionDiagramNode lastParentNode = startNode;
        for (RfNamedElement member : localMembers) {
            if (!(member instanceof RfBlock) || !block.equals(member.getEnclosingScope())) continue;
            ActionDiagramNode childNode = this.expandSequential(lastParentNode, (RfBlock)member, prefBundle);
            if (showAsParallel) {
                childNode.addFlowEdge(new ActionDiagramEdge(childNode, endNode, null, ActionDiagramEdge.EdgeKind.FLOW));
                endNode.addParent(childNode);
                continue;
            }
            lastParentNode = childNode;
        }
        if (!showAsParallel) {
            lastParentNode.addFlowEdge(new ActionDiagramEdge(lastParentNode, endNode, null, ActionDiagramEdge.EdgeKind.FLOW));
        }
        return endNode;
    }
}

