/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import ro.amiq.pssdt.model.reflection.FieldModifier;
import ro.amiq.pssdt.model.reflection.IRfClassType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;

public class ActivityDiagramUtils {
    private ActivityDiagramUtils() {
    }

    protected static List<RfField> getActionInputPorts(RfStruct action) {
        return ActivityDiagramUtils.getActionFields(action, FieldModifier.INPUT);
    }

    protected static List<RfField> getActionOutputPorts(RfStruct action) {
        return ActivityDiagramUtils.getActionFields(action, FieldModifier.OUTPUT);
    }

    private static List<RfField> getActionFields(RfStruct action, FieldModifier fieldModifier) {
        if (!action.isAction(true)) {
            return Collections.emptyList();
        }
        Collection<RfNamedElement> localMembers = action.getLocalMembers();
        if (localMembers == null || localMembers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RfField> result = new ArrayList<RfField>(1);
        for (RfNamedElement member : localMembers) {
            if (!(member instanceof RfField) || fieldModifier != ((RfField)member).getFieldModifier()) continue;
            result.add((RfField)member);
        }
        IRfClassType parent = action.getParent();
        if (parent == null || parent.isPredefined()) {
            return result;
        }
        if (!(parent instanceof RfStruct) || !((RfStruct)parent).isAction(true)) {
            return result;
        }
        result.addAll(ActivityDiagramUtils.getActionFields((RfStruct)parent, fieldModifier));
        return result;
    }

    protected static String getNodeName(RfStruct action, String instanceScopeName) {
        if (action == null) {
            return "";
        }
        String actionName = action.getNameForDiagram();
        if (actionName == null) {
            return instanceScopeName != null ? instanceScopeName : "";
        }
        if (instanceScopeName == null) {
            return actionName;
        }
        return String.valueOf(instanceScopeName) + ": " + actionName;
    }
}

