/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramEdge;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ScenarioDiagramNode;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.elaboration.ActionInstance;
import ro.amiq.pssdt.model.reflection.elaboration.ComponentInstance;
import ro.amiq.pssdt.model.reflection.elaboration.FieldInstance;
import ro.amiq.pssdt.model.reflection.elaboration.PoolItem;
import ro.amiq.pssdt.model.reflection.elaboration.PortInstance;

public class ScenarioDiagramModel {
    public ActionDiagramNode createRoot(ActionInstance instance, ADPreferenceBundle bundle) {
        if (instance == null || instance.getScenario() == null) {
            return null;
        }
        if (!((instance = instance.getScenario().getTreeRoot()) instanceof ActionInstance.SequenceActionInstance)) {
            return null;
        }
        ScenarioDiagramNode root = new ScenarioDiagramNode("START", null, null, ActionDiagramNode.NodeKind.ROOT, false);
        HashMap<ActionInstance, ActionDiagramNode> instanceNodeMap = new HashMap<ActionInstance, ActionDiagramNode>();
        int[] nodeIndex = new int[]{1};
        ActionDiagramNode lastNode = this.expandSequential(instance, root, bundle, instanceNodeMap, nodeIndex);
        ScenarioDiagramNode end = new ScenarioDiagramNode("END", null, lastNode, ActionDiagramNode.NodeKind.ROOT, false);
        lastNode.addFlowEdge(new ActionDiagramEdge(lastNode, end, null, ActionDiagramEdge.EdgeKind.FLOW));
        if (bundle.showDataConnections) {
            this.createPools(instance, instanceNodeMap);
        }
        return root;
    }

    private ActionDiagramNode expandSequential(ActionInstance instance, ActionDiagramNode parent, ADPreferenceBundle bundle, Map<ActionInstance, ActionDiagramNode> instanceNodeMap, int[] index) {
        List<ActionInstance> children;
        if (this.isSplitMergeCandidate(instance) || instance.getChildren() == null) {
            return parent;
        }
        if (instance instanceof ActionInstance.ScheduleActionInstance) {
            try {
                throw new Exception("Schedule Instance found!");
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if ((children = instance.getChildren()) == null || children.isEmpty()) {
            return parent;
        }
        boolean isFirstChild = true;
        for (ActionInstance child : children) {
            if (this.isSplitMergeCandidate(child)) {
                parent = this.expandParallel(child, parent, true, bundle, instanceNodeMap, index);
            } else if (child instanceof ActionInstance.SequenceActionInstance || child.isCompound() || child.isSkipCompound()) {
                parent = this.expandSequential(child, parent, bundle, instanceNodeMap, index);
            } else {
                if (child.isActionQualifiedFieldWrapper()) continue;
                String name = String.valueOf(child.getDiagramInstanceName()) + ": " + child.getRfAction().getNameForDiagram();
                ComponentInstance parentComponentInstance = child.getParentComponentInstance();
                ScenarioDiagramNode node = new ScenarioDiagramNode(name, parentComponentInstance.getInstancePath().asString(), parent, ActionDiagramNode.NodeKind.ACTION, child.isInferred());
                parent.addFlowEdge(new ActionDiagramEdge(parent, node, isFirstChild ? this.getRuntimeBranchLabel(instance) : null, ActionDiagramEdge.EdgeKind.FLOW));
                node.setIndex(index[0]);
                index[0] = index[0] + 1;
                this.addNodeDetailsSourceInfo(node, child, bundle);
                instanceNodeMap.put(child, node);
                parent = node;
            }
            isFirstChild = false;
        }
        return parent;
    }

    private String getRuntimeBranchLabel(ActionInstance instance) {
        if (instance instanceof ActionInstance.ParallelActionInstance) {
            return ((ActionInstance.ParallelActionInstance)instance).getRuntimeBranchLabel(false);
        }
        if (instance instanceof ActionInstance.SequenceActionInstance) {
            return ((ActionInstance.SequenceActionInstance)instance).getRuntimeBranchLabel(true);
        }
        return null;
    }

    private boolean isSplitMergeCandidate(ActionInstance instance) {
        return instance instanceof ActionInstance.ParallelActionInstance && this.hasMoreThanOneChild(instance) || instance instanceof ActionInstance.RuntimeIfActionInstance || instance instanceof ActionInstance.RuntimeWhileActionInstance || instance instanceof ActionInstance.RuntimeMatchActionInstance;
    }

    private boolean hasMoreThanOneChild(ActionInstance instance) {
        List<ActionInstance> children = instance.getChildren();
        return children != null && children.size() > 1;
    }

    private ActionDiagramNode expandParallel(ActionInstance instance, ActionDiagramNode parent, boolean fromSequence, ADPreferenceBundle bundle, Map<ActionInstance, ActionDiagramNode> instanceNodeMap, int[] index) {
        if (!this.isSplitMergeCandidate(instance) || parent == null) {
            return null;
        }
        ActionDiagramNode parallelNode = null;
        ActionDiagramNode parallelEndNode = null;
        if (instance instanceof ActionInstance.RuntimeIfActionInstance) {
            parallelNode = new ScenarioDiagramNode(instance.getDiagramName(), null, parent, ActionDiagramNode.NodeKind.RUNTIME_IF, false);
            parent.addFlowEdge(new ActionDiagramEdge(parent, parallelNode, this.getRuntimeBranchLabel(instance), ActionDiagramEdge.EdgeKind.FLOW));
            parallelEndNode = new ScenarioDiagramNode("[if end]", null, null, ActionDiagramNode.NodeKind.RUNTIME_IF_END, false);
            parallelNode.setParallelEnd(parallelEndNode);
        } else if (instance instanceof ActionInstance.RuntimeWhileActionInstance) {
            parallelNode = new ScenarioDiagramNode(instance.getDiagramName(), null, parent, ActionDiagramNode.NodeKind.RUNTIME_WHILE, false);
            parent.addFlowEdge(new ActionDiagramEdge(parent, parallelNode, this.getRuntimeBranchLabel(instance), ActionDiagramEdge.EdgeKind.FLOW));
            parallelEndNode = new ScenarioDiagramNode("[while end]", null, null, ActionDiagramNode.NodeKind.RUNTIME_WHILE_END, false);
            parallelNode.setParallelEnd(parallelEndNode);
            parallelNode.addFlowEdge(new ActionDiagramEdge(parallelNode, parallelEndNode, null, ActionDiagramEdge.EdgeKind.FLOW));
        } else if (instance instanceof ActionInstance.RuntimeMatchActionInstance) {
            parallelNode = new ScenarioDiagramNode(instance.getDiagramName(), null, parent, ActionDiagramNode.NodeKind.RUNTIME_MATCH, false);
            parent.addFlowEdge(new ActionDiagramEdge(parent, parallelNode, this.getRuntimeBranchLabel(instance), ActionDiagramEdge.EdgeKind.FLOW));
            parallelEndNode = new ScenarioDiagramNode("[match end]", null, null, ActionDiagramNode.NodeKind.RUNTIME_MATCH_END, false);
            parallelNode.setParallelEnd(parallelEndNode);
        } else if (parent.isParallelNode() && !bundle.showRedundantParallels) {
            parallelNode = parent;
            parallelEndNode = fromSequence ? new ScenarioDiagramNode("[parallel end]", null, null, ActionDiagramNode.NodeKind.PARALLEL_END, false) : parent.getParallelEnd();
            parallelNode.setParallelEnd(parallelEndNode);
        } else {
            parallelNode = new ScenarioDiagramNode("[parallel]", null, parent, ActionDiagramNode.NodeKind.PARALLEL, false);
            parent.addFlowEdge(new ActionDiagramEdge(parent, parallelNode, this.getRuntimeBranchLabel(instance), ActionDiagramEdge.EdgeKind.FLOW));
            parallelEndNode = new ScenarioDiagramNode("[parallel end]", null, null, ActionDiagramNode.NodeKind.PARALLEL_END, false);
            parallelNode.setParallelEnd(parallelEndNode);
        }
        List<ActionInstance> children = instance.getChildren();
        if (children == null || children.isEmpty()) {
            return parallelEndNode;
        }
        for (ActionInstance child : children) {
            if (this.isSplitMergeCandidate(child)) {
                ActionDiagramNode newParallelEndNode = this.expandParallel(child, parallelNode, false, bundle, instanceNodeMap, index);
                if (newParallelEndNode.isParallelEndNode() && !bundle.showRedundantParallels) continue;
                newParallelEndNode.addFlowEdge(new ActionDiagramEdge(newParallelEndNode, parallelEndNode, null, ActionDiagramEdge.EdgeKind.FLOW));
                continue;
            }
            if (child instanceof ActionInstance.SequenceActionInstance || child.isCompound() || child.isSkipCompound()) {
                ActionDiagramNode lastNode = this.expandSequential(child, parallelNode, bundle, instanceNodeMap, index);
                lastNode.addFlowEdge(new ActionDiagramEdge(lastNode, parallelEndNode, null, ActionDiagramEdge.EdgeKind.FLOW));
                parallelEndNode.addParent(lastNode);
                continue;
            }
            if (child.isActionQualifiedFieldWrapper()) continue;
            String name = String.valueOf(child.getDiagramInstanceName()) + ": " + child.getRfAction().getNameForDiagram();
            ComponentInstance parentComponentInstance = child.getParentComponentInstance();
            ScenarioDiagramNode node = new ScenarioDiagramNode(name, parentComponentInstance.getInstancePath().asString(), parallelNode, ActionDiagramNode.NodeKind.ACTION, child.isInferred());
            parallelNode.addFlowEdge(new ActionDiagramEdge(parallelNode, node, null, ActionDiagramEdge.EdgeKind.FLOW));
            node.addFlowEdge(new ActionDiagramEdge(node, parallelEndNode, null, ActionDiagramEdge.EdgeKind.FLOW));
            parallelEndNode.addParent(node);
            node.setIndex(index[0]);
            index[0] = index[0] + 1;
            this.addNodeDetailsSourceInfo(node, child, bundle);
            instanceNodeMap.put(child, node);
        }
        return parallelEndNode;
    }

    /*
     * WARNING - void declaration
     */
    private void addNodeDetailsSourceInfo(ActionDiagramNode node, ActionInstance actionInstance, ADPreferenceBundle bundle) {
        if (actionInstance.getRfAction() == null) {
            return;
        }
        node.setSourceMarker(GoToInfo.sourceOf((IRfNamedElement)actionInstance.getRfAction()));
        node.setInspectInfo("info not available");
        Map<String, FieldInstance> fieldInstances = actionInstance.getFieldInstances();
        if (fieldInstances == null) {
            return;
        }
        StringBuilder inspectInfo = new StringBuilder();
        List<PortInstance> portInstances = actionInstance.getPortInstances();
        for (FieldInstance fieldInstance : portInstances) {
            RfNamedElement type = fieldInstance.getRfFieldType();
            if (type == null) continue;
            StringBuilder poolLabel = new StringBuilder();
            inspectInfo.append("").append(fieldInstance.getInspectInfo(fieldInstance.getDiagramName())).append("");
            if (fieldInstance.isLockOrShare()) {
                void var7_8;
                GoToInfo poolSource = null;
                while (true) {
                    for (FieldInstance fieldInstance2 : var7_8.getBinds()) {
                        if (!(fieldInstance2 instanceof PoolItem)) {
                            if (!fieldInstance2.getParentActionInstance().isParentInstanceOf(var7_8.getParentActionInstance())) continue;
                            FieldInstance fieldInstance3 = fieldInstance2;
                            continue;
                        }
                        poolLabel.append(fieldInstance2.getInstancePath().asString());
                        poolSource = GoToInfo.sourceOf((IRfNamedElement)fieldInstance2.getRfField());
                    }
                    break;
                }
                bundle.addColorForPool(poolLabel.toString());
                node.addMember(new ActionDiagramMemberNode(var7_8.getDiagramName(), type.getNameForDiagram(), poolLabel.toString(), var7_8.isLock() ? ActionDiagramMemberNode.MemberKind.LOCK : ActionDiagramMemberNode.MemberKind.SHARE, null, GoToInfo.sourceOf((IRfNamedElement)var7_8.getRfField()), poolSource, "info not available"));
                continue;
            }
            if (!fieldInstance.isInput() && !fieldInstance.isOutput()) continue;
            node.addMember(new ActionDiagramMemberNode(fieldInstance.getDiagramName(), type.getNameForDiagram(), null, fieldInstance.isInput() ? ActionDiagramMemberNode.MemberKind.INPUT : ActionDiagramMemberNode.MemberKind.OUTPUT, type instanceof RfStruct ? ((RfStruct)type).getStructKind() : null, GoToInfo.sourceOf((IRfNamedElement)fieldInstance.getRfField()), null, "info not available"));
        }
        HashSet<PortInstance> hashSet = new HashSet<PortInstance>(portInstances);
        for (FieldInstance field : fieldInstances.values()) {
            RfNamedElement type;
            if (field.isPort() || hashSet.contains(field) || (type = field.getRfFieldType()) == null) continue;
            inspectInfo.append("").append(field.getInspectInfo(field.getDiagramName())).append("");
        }
        node.setInspectInfo(inspectInfo.toString());
    }

    private void createPools(ActionInstance instance, Map<ActionInstance, ActionDiagramNode> instanceNodeMap) {
        List<ActionInstance> childrenActionInstances;
        if (instance == null || instanceNodeMap == null) {
            return;
        }
        ActionDiagramNode node = instanceNodeMap.get(instance);
        if (node != null) {
            List<PortInstance> portInstances = instance.getPortInstances();
            for (PortInstance portInstance : portInstances) {
                RfNamedElement type;
                if (portInstance.isLockOrShare() || (type = portInstance.getRfFieldType()) == null || !portInstance.isOutput()) continue;
                List<PortInstance> poolBinds = portInstance.getPoolBinds();
                String poolPath = this.getPoolPath(poolBinds);
                String poolName = this.getPoolName(portInstance, poolBinds);
                ScenarioDiagramNode poolNode = new ScenarioDiagramNode(poolName, poolPath, null, ActionDiagramNode.NodeKind.POOL, false);
                GoToInfo goToInfo = poolBinds != null && !poolBinds.isEmpty() ? GoToInfo.sourceOf((IRfNamedElement)poolBinds.get(0).getRfField()) : GoToInfo.sourceOf((IRfNamedElement)portInstance.getRfField());
                poolNode.setSourceMarker(goToInfo);
                StringBuilder inspectInfo = new StringBuilder();
                inspectInfo.append("").append(portInstance.getInspectInfo(portInstance.getDiagramName())).append("");
                poolNode.setInspectInfo(inspectInfo.toString());
                node.addDataEdge(new ActionDiagramEdge(node, poolNode, portInstance.getDiagramName(), ActionDiagramEdge.EdgeKind.DATA));
                this.checkBinds(instanceNodeMap, portInstance.getBinds(), poolNode);
                this.checkBinds(instanceNodeMap, portInstance.getHierarchicalBinds(FieldInstance.HierarchicalBindKind.BOTH), poolNode);
            }
        }
        if ((childrenActionInstances = instance.getChildren()) == null || childrenActionInstances.isEmpty()) {
            return;
        }
        for (ActionInstance childActionInstance : childrenActionInstances) {
            this.createPools(childActionInstance, instanceNodeMap);
        }
    }

    private String getPoolName(PortInstance portInstance, List<PortInstance> poolBindInstances) {
        RfNamedElement type = portInstance.getRfFieldType();
        if (poolBindInstances == null || poolBindInstances.isEmpty()) {
            return type.getNameForDiagram();
        }
        return portInstance.isLockOrShare() ? poolBindInstances.get(0).getDiagramName() : poolBindInstances.get(0).getParentInstance().getDiagramName();
    }

    private String getPoolPath(List<PortInstance> poolBindInstances) {
        return poolBindInstances == null || poolBindInstances.isEmpty() ? null : poolBindInstances.get(0).getParentComponentInstance().getInstancePath().toString();
    }

    private void checkBinds(Map<ActionInstance, ActionDiagramNode> instanceNodeMap, List<PortInstance> poolBindInstances, ActionDiagramNode poolNode) {
        if (poolBindInstances == null || poolNode == null || instanceNodeMap == null) {
            return;
        }
        for (PortInstance poolBindInstance : poolBindInstances) {
            if (!poolBindInstance.isInput()) continue;
            ActionDiagramNode destinationNode = instanceNodeMap.get(poolBindInstance.getParentActionInstance());
            if (destinationNode == null) {
                this.checkBinds(instanceNodeMap, poolBindInstance.getHierarchicalBinds(FieldInstance.HierarchicalBindKind.BOTH), poolNode);
                continue;
            }
            poolNode.addDataEdge(new ActionDiagramEdge(poolNode, destinationNode, poolBindInstance.getDiagramName(), ActionDiagramEdge.EdgeKind.DATA));
        }
    }
}

