/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.diagrams.action.rendering;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.krendering.KColor;
import de.cau.cs.kieler.core.krendering.KFontBold;
import de.cau.cs.kieler.core.krendering.KFontItalic;
import de.cau.cs.kieler.core.krendering.KFontName;
import de.cau.cs.kieler.core.krendering.KFontSize;
import de.cau.cs.kieler.core.krendering.KRendering;
import de.cau.cs.kieler.core.krendering.KStyle;
import de.cau.cs.kieler.core.krendering.KText;
import de.cau.cs.kieler.core.krendering.LineStyle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.diagrams.klay.rendering.KLayStyleFactory;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.pssdt.diagrams.action.ADPreferenceBundle;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramMemberNode;
import ro.amiq.pssdt.diagrams.action.model.ActionDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.ActivityDiagramNode;
import ro.amiq.pssdt.diagrams.action.model.IActionDiagramElement;
import ro.amiq.pssdt.diagrams.action.model.ScenarioDiagramNode;
import ro.amiq.pssdt.diagrams.action.rendering.ActionDiagramRendering;
import ro.amiq.pssdt.diagrams.action.rendering.ActionDiagramRenderingConstants;

public class ActionDiagramRenderingUtils {
    private static final KLayStyleFactory STYLE_FACTORY = KLayStyleFactory.INSTANCE;

    public static void renderNode(KNode kNode, ActionDiagramNode node, ActionDiagramMemberNode member, ADPreferenceBundle bundle) {
        KRendering nodeRendering = ActionDiagramRendering.INSTANCE.getNodeRenderingOrDefault(node.isActionNode());
        if (nodeRendering == null) {
            return;
        }
        EList styles = nodeRendering.getStyles();
        if (member != null && member.getPool() != null) {
            bgColor = ActionDiagramRenderingUtils.getColor(bundle.getColor(member.getPool()));
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        } else if (node.isActionNode()) {
            if (node instanceof ScenarioDiagramNode && ((ScenarioDiagramNode)node).isInferred()) {
                bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.LIGHT_YELLOW);
                styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
            } else if (node instanceof ActivityDiagramNode && ((ActivityDiagramNode)node).isCompoundAction()) {
                bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.DARK_GREEN);
                styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
            } else {
                bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.BG_ACTION_RGB);
                styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
            }
        } else if (node.isParallelNode() || node.isRuntimeIfNode() || node.isRuntimeWhileNode() || node.isRuntimeMatchNode()) {
            bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.GRAY);
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        } else if (node.isParallelEndNode() || node.isRuntimeIfEndNode() || node.isRuntimeWhileEndNode() || node.isRuntimeMatchEndNode()) {
            bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        } else {
            bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.BG_POOL_RGB);
            styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        }
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.FG_ACTION_RGB);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        float lineWidth = 1.0f;
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = ActionDiagramRenderingConstants.NODE_LINE_STYLE;
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_BG_NODE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_FG_NODE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        lineWidth = 1.0f;
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        kNode.getData().add((Object)nodeRendering);
    }

    static KColor getColor(RGB color) {
        return KLayStyleFactory.createColorFromRGB((RGB)color);
    }

    public static void renderDummyGate(KNode dummyNode) {
        KRendering gateRendering = ActionDiagramRendering.INSTANCE.getDummyNodeRenderingOrDefault();
        if (gateRendering == null) {
            return;
        }
        EList styles = gateRendering.getStyles();
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        dummyNode.getData().add((Object)gateRendering);
    }

    public static void renderPort(KPort port) {
        KRendering rendering = ActionDiagramRendering.INSTANCE.getPortRenderingOrDefault();
        if (rendering == null) {
            return;
        }
        EList styles = rendering.getStyles();
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        int bgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, bgAlpha));
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        int fgAlpha = 0;
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, fgAlpha));
        port.getData().add((Object)rendering);
    }

    public static void renderDataEdge(KEdge kEdge) {
        KRendering edgeRendering = ActionDiagramRendering.INSTANCE.getEdgeRenderingOrDefault();
        if (edgeRendering == null) {
            return;
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.DATA_FG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.DATA_BG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        float lineWidth = 1.0f;
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = ActionDiagramRenderingConstants.DATA_LINE_STYLE;
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_FG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_BG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        lineWidth = 2.0f;
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        kEdge.getData().add((Object)edgeRendering);
    }

    public static void renderFlowEdge(KEdge kEdge) {
        KRendering edgeRendering = ActionDiagramRendering.INSTANCE.getEdgeRenderingOrDefault();
        if (edgeRendering == null) {
            return;
        }
        EList styles = edgeRendering.getStyles();
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.FLOW_FG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.FLOW_BG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        float lineWidth = 1.0f;
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = ActionDiagramRenderingConstants.FLOW_LINE_STYLE;
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_LABEL_FG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_BG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        lineWidth = 2.0f;
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        kEdge.getData().add((Object)edgeRendering);
    }

    public static void renderLabel(KLabel label, IActionDiagramElement element, boolean selectable) {
        KText labelRendering = ActionDiagramRendering.INSTANCE.getLabelRenderingOrDefault();
        if (labelRendering == null) {
            return;
        }
        EList styles = labelRendering.getStyles();
        int size = ActionDiagramRendering.INSTANCE.getFontSize(label, element);
        styles.add((Object)STYLE_FACTORY.createFontSize(size));
        String fontName = ActionDiagramRendering.INSTANCE.getFontName();
        styles.add((Object)STYLE_FACTORY.createFontName(fontName));
        KFontBold fontBold = ActionDiagramRendering.INSTANCE.getFontBoldOrDefault(label, element);
        styles.add((Object)fontBold);
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.LABEL_FG_EDGE_RGB);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        if (selectable) {
            fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SEL_LABEL_FG_EDGE_RGB);
            styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        }
        label.getData().add((Object)labelRendering);
    }

    public static FontData getFontData(KLabel label) {
        if (label == null) {
            return null;
        }
        KRendering text = (KRendering)label.getData(KRendering.class);
        if (!(text instanceof KText)) {
            return null;
        }
        String fontName = null;
        int fontSize = 0;
        int fontStyle = 0;
        EList styles = text.getStyles();
        for (KStyle style : styles) {
            if (style instanceof KFontSize) {
                fontSize = ((KFontSize)style).getSize();
                continue;
            }
            if (style instanceof KFontName) {
                fontName = ((KFontName)style).getName();
                continue;
            }
            if (style instanceof KFontBold && ((KFontBold)style).isBold()) {
                fontStyle |= 1;
                continue;
            }
            if (!(style instanceof KFontItalic) || !((KFontItalic)style).isItalic()) continue;
            fontStyle |= 2;
        }
        return FontFactory.getInstance().getFontData(fontName, fontSize, fontStyle);
    }

    public static void renderContainerNode(KNode kNode) {
        KRendering nodeRendering = ActionDiagramRendering.INSTANCE.getNodeRenderingOrDefault(true);
        if (nodeRendering == null) {
            return;
        }
        EList styles = nodeRendering.getStyles();
        KColor bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        styles.add((Object)STYLE_FACTORY.createBackground(bgColor, 255));
        KColor fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.BLACK);
        styles.add((Object)STYLE_FACTORY.createForeground(fgColor, 255));
        float lineWidth = 1.0f;
        styles.add((Object)STYLE_FACTORY.createLineWidth(lineWidth));
        LineStyle lineStyle = ActionDiagramRenderingConstants.NODE_LINE_STYLE;
        styles.add((Object)STYLE_FACTORY.createLineStyle(lineStyle));
        bgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.WHITE);
        styles.add((Object)STYLE_FACTORY.createSelectionBackground(bgColor, 255));
        fgColor = ActionDiagramRenderingUtils.getColor(ActionDiagramRenderingConstants.SELECTION_RED);
        styles.add((Object)STYLE_FACTORY.createSelectionForeground(fgColor, 255));
        lineWidth = 3.0f;
        styles.add((Object)STYLE_FACTORY.createSelectionLineWidth(lineWidth));
        kNode.getData().add((Object)nodeRendering);
    }
}

