/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.externaltools;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.PSSProject;
import ro.amiq.pssdt.utils.PSSFileUtils;

public class PSSExternalToolsDelegate
implements IExternalToolsDelegate {
    private static volatile PSSExternalToolsDelegate fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private PSSExternalToolsDelegate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSSExternalToolsDelegate getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new PSSExternalToolsDelegate();
            }
        }
        return fInstance;
    }

    public IFile getResource(IProject project, String knownPath) {
        String customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        Path path = new Path(customPath);
        if (path.isAbsolute()) {
            File classicFile = new File(customPath);
            IFile candidate = PSSFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        PSSProject pssProject = (PSSProject)PSSModelManager.getInstance().getPSSModel().getPSSProject(project);
        if (pssProject != null) {
            File classicFile = new File(customPath);
            IFile candidate = PSSFileUtils.getInstance().getProjectFile(project, classicFile.getAbsolutePath());
            if (candidate == null) {
                return null;
            }
            return candidate;
        }
        customPath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(knownPath);
        IFile candidate = PSSFileUtils.getInstance().findProjectFile(project, customPath);
        if (candidate == null) {
            return null;
        }
        return candidate;
    }

    public String getBuilderKind() {
        return "ro.amiq.dvt.pssdtKind";
    }

    public void openEditor(IProject project, String workingDirectory, String filePath, int line) {
        if (!Path.fromOSString((String)filePath).isAbsolute()) {
            filePath = Path.fromOSString((String)workingDirectory).append(filePath).toOSString();
        }
        filePath = DVTUtilsCommon.INSTANCE.getCrossPlatformPath(filePath);
        PSSFileUtils.getInstance().openFile(project, filePath, line, null);
    }

    public boolean hasRelevantContentType(String fileName) {
        if (fileName == null) {
            return false;
        }
        String[] fileExtensions = DVTFileUtils.getInstance().getExtensionsForContentType("ro.amiq.pssdt.PSSSource", false);
        return DVTFileUtils.getInstance().validExtension(fileExtensions, fileName);
    }
}

