/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model;

import antlr.collections.AST;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.DVTFileInfo;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.DVTModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTFile;
import ro.amiq.dvt.model.IDVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.pssdt.model.IPSSModel;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.model.PSSFileInfo;
import ro.amiq.pssdt.model.PSSModel;
import ro.amiq.pssdt.model.PSSModule;
import ro.amiq.pssdt.model.floatingwidgets.PSSFNotificationProvider;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.util.NullProtectedList;
import ro.amiq.pssdt.parser.PSSCompiler;
import ro.amiq.pssdt.parser.PSSProblem;
import ro.amiq.pssdt.ui.syntaxerrors.SyntaxErrorsManager;

public class PSSModelManager
extends DVTModelManager {
    private static volatile PSSModelManager fInstance;
    private final PSSModel fModel;
    private HashMap<IPath, ArrayList> fTopFilesErrors = new HashMap();
    private HashMap<IPath, ArrayList> fTopFilesWarnings = new HashMap();
    private List<PSSProblem> fUnreportedErrors = new NullProtectedList<PSSProblem>();
    private List<PSSProblem> fUnreportedWarnings = new NullProtectedList<PSSProblem>();
    private RfManager fRfManager;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    private PSSModelManager() {
        this.fModel = new PSSModel();
        this.fRfManager = RfManager.getInstance();
        this.addBuildListener(this.fRfManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PSSModelManager getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new PSSModelManager();
            }
        }
        return fInstance;
    }

    public int getPriority() {
        return DVTMixedLangBuilder.getBuilderPriorityForNature((String)"ro.amiq.pssdt.pssnature");
    }

    public IPSSModel getPSSModel() {
        return this.fModel;
    }

    public IPSSProject getIPSSProject(IDVTProject iDVTProject) {
        return (IPSSProject)iDVTProject;
    }

    public IPSSModule getIPSSFile(IDVTFile iDVTFile) {
        return (IPSSModule)iDVTFile;
    }

    public PSSFileInfo getPSSFileInfo(DVTFileInfo dvtFileInfo) {
        return (PSSFileInfo)dvtFileInfo;
    }

    public void saveUnfinishedJobs(IProject project) {
    }

    public void cbClean(IProject project) {
        this.fTopFilesErrors.clear();
        this.fTopFilesWarnings.clear();
        this.fUnreportedErrors.clear();
        this.fUnreportedWarnings.clear();
        IPSSProject pssProject = this.getPSSModel().getPSSProject(project);
        if (pssProject == null) {
            return;
        }
        pssProject.clean();
        this.notifyReparseListeners(2, project);
        this.notifyBuildListenersClean(pssProject, true);
    }

    public void cbBuild(DVTFileInfo dvtFileInfo) {
        try {
            PSSFileInfo info = this.getPSSFileInfo(dvtFileInfo);
            IPSSProject pssProject = this.getPSSModel().getPSSProject(info.getProject());
            if (pssProject != null) {
                pssProject.addTopFile(info.getParserPath());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cbPostFullBuild(IProject project, boolean success) {
        DVTLogger.INSTANCE.logDebug("DEBUG: cbPostFullBuild start");
        IPSSProject pssProject = this.getPSSModel().getPSSProject(project);
        if (pssProject == null) {
            return;
        }
        PSSCompiler pssParser = pssProject.getPSSParser();
        if (pssParser == null) {
            return;
        }
        NullProtectedList<PSSProblem> unreportedErrors = new NullProtectedList<PSSProblem>();
        ArrayList<IPSSModule> pssFiles = new ArrayList<IPSSModule>();
        for (ParserPath parserPath : pssProject.getTopFiles()) {
            IFile file = DVTFileUtils.getInstance().findProjectFile(project, parserPath.path);
            if (file != null && file.getLocation() != null) {
                PSSCompiler pSSCompiler;
                IPath location = file.getLocation();
                String resourcePath = location.toOSString();
                IPSSModule pssFile = this.getPSSModel().getOrCreatePSSFile(file);
                if (this.fTopFilesErrors.containsKey(location)) {
                }
                if (pssFile != null) {
                    pssFiles.add(pssFile);
                    pSSCompiler = pssParser;
                    synchronized (pSSCompiler) {
                        pssFile.setEncrypted(pssParser.isEncrypted(parserPath));
                        boolean updatePath = !resourcePath.equals(parserPath.path);
                        pssFile.setErrors(pssParser.getErrors(parserPath), updatePath, resourcePath);
                        pssFile.setWarnings(pssParser.getWarnings(parserPath), updatePath, resourcePath);
                        pssFile.setTasks(pssParser.getTasks(parserPath));
                        continue;
                    }
                }
                pSSCompiler = pssParser;
                synchronized (pSSCompiler) {
                    unreportedErrors.addAll(pssParser.getErrors(parserPath));
                    continue;
                }
            }
            PSSCompiler pSSCompiler = pssParser;
            synchronized (pSSCompiler) {
                unreportedErrors.addAll(pssParser.getErrors(parserPath));
            }
        }
        int type = 6;
        this.notifyReparseListeners(1, type, pssFiles);
        this.notifyReparseListeners(3, project);
        if (!unreportedErrors.isEmpty()) {
            SyntaxErrorsManager.getInstance().updateProblemsUI(project, unreportedErrors);
        }
        this.notifyBuildListenersPostFullBuild(pssProject, success);
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo fileInfo, IDocument document, boolean saveRFDM) {
        if (fileInfo == null) {
            return;
        }
        IFile file = fileInfo.getFile();
        if (file == null || !file.exists()) {
            return;
        }
        if (!this.isTopFile(file) && this.isNonTopFileCompilationDisabled(file)) {
            return;
        }
        this.cbClean(file);
        IPSSModule pssFile = this.getPSSModel().getOrCreatePSSFile(file);
        if (pssFile == null) {
            return;
        }
        try {
            if (document != null) {
                pssFile.reparse(monitor, document.get(), saveRFDM);
            } else {
                pssFile.reparse(monitor, saveRFDM);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (pssFile.isAutoBuildStop()) {
            return;
        }
        int type = 1;
        type |= 2;
        this.notifyReparseListeners(0, type |= 4, pssFile);
        IProject project = file.getProject();
        if (project == null) {
            return;
        }
        IPSSProject pssProject = this.getPSSModel().getPSSProject(project);
        PSSCompiler pssParser = pssProject.getPSSParser();
        ParserPath parserPath = pssFile.getParserPath();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject != null && pssParser != null && parserPath != null) {
            this.handleFloatingNotification(PSSFNotificationProvider.getInstance(), project, file, pssProject.isParserInterrupted());
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
            AST pssAST = pssParser.getFileAST();
            this.notifyBuildListenersPostIncrementalBuild(new PSSFileInfo(project, parserPath, file, pssAST, fileDef == null ? -1 : fileDef.getIndex(), saveRFDM));
        }
    }

    private boolean isTopFile(IFile file) {
        if (file == null) {
            return false;
        }
        return this.fTopFilesErrors.containsKey(file.getFullPath());
    }

    private boolean isNonTopFileCompilationDisabled(IFile file) {
        if (file == null) {
            return false;
        }
        IProject project = file.getProject();
        if (project == null) {
            return false;
        }
        return BuildConfigManager.isNonTopFileCompilationDisabled((IProject)project);
    }

    public void cbInstanceIncrementalBuild(PSSModule pssFile, IDVTFileInstance instance, PSSCompiler pssParser) {
        if (pssFile == null) {
            return;
        }
        if (pssFile.isAutoBuildStop()) {
            return;
        }
        IFile file = pssFile.getFile();
        ParserPath parserPath = pssFile.getParserPath();
        RfProject rfProject = RfManager.getInstance().getRfProject(file.getProject());
        if (rfProject != null && pssParser != null && parserPath != null) {
            RfFileDef fileDef = rfProject.getFileDefUsingParserPath(parserPath);
            AST pssAST = pssParser.getFileAST();
            this.notifyBuildListenersIncrementalBuild(new PSSFileInfo(file.getProject(), parserPath, file, pssAST, fileDef == null ? -1 : fileDef.getIndex(), true));
        }
    }

    public void cbRemove(IFile file) {
        IPSSModule vModule = this.getPSSModel().getOrCreatePSSFile(file);
        if (vModule != null) {
            this.notifyBuildListenersRemove(vModule);
        }
    }

    public void cbClean(IFile file) {
        IPSSModule pssFile = this.getPSSModel().getOrCreatePSSFile(file);
        if (pssFile == null) {
            return;
        }
        this.notifyBuildListenersClean(pssFile);
    }

    public PSSFileInfo getModuleInfo(DVTFileInfo dvtFileInfo) {
        return (PSSFileInfo)dvtFileInfo;
    }

    public IPSSModule getIPSSModule(IDVTFile iDVTFile) {
        return (IPSSModule)iDVTFile;
    }

    public void addTopFile(String parserPath) {
        IPath path = Path.fromOSString((String)parserPath);
        this.fTopFilesErrors.put(path, null);
        this.fTopFilesWarnings.put(path, null);
    }

    public void cleanPSSProject(IProject project) {
        this.fModel.cleanIDVTProject(project);
    }
}

