/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.IDocument;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.model.ChangedFilesManager;
import ro.amiq.dvt.model.DVTFile;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.reportissue.IncrementalBuildThreadDumpHandler;
import ro.amiq.dvt.ui.reportissue.IncrementalInfoCallbackFactory;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.pssdt.builders.PSSPoolingCancelThread;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.parser.PSSCompiler;
import ro.amiq.pssdt.parser.PSSProblem;
import ro.amiq.pssdt.ui.persistenttask.PersistentTaskManager;
import ro.amiq.pssdt.utils.Utils;

public class PSSModule
extends DVTFile
implements IPSSModule {
    private RebuildTriggerJob fRebuildJob = new RebuildTriggerJob();
    private boolean fForceBuild;
    private boolean fAutobuildStop;
    private boolean fEncrypted;

    public PSSModule(IFile iFile) {
        super(iFile);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, boolean saveRFDM) {
        this.scheduleReparse(wait, force, delay, null, saveRFDM);
    }

    public void scheduleReparse(boolean wait, boolean force, long delay, IDocument document, boolean saveRFDM) {
        try {
            this.fForceBuild = force;
            boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
            if (cancelIncremental) {
                ChangedFilesManager.cancelBuildJob();
            } else {
                this.fRebuildJob.cancel();
            }
            this.fRebuildJob.setDocument(document);
            if (wait) {
                DVTJobsUtils.scheduleAndJoin((Job)this.fRebuildJob, (long)delay);
            } else {
                this.fRebuildJob.schedule(delay);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void reparse(IProgressMonitor monitor, boolean saveRFDM) {
        this.reparse(monitor, null, saveRFDM);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparse(IProgressMonitor monitor, String documentContent, boolean saveRFDM) {
        block19: {
            try {
                this.fAutobuildStop = false;
                IFile file = this.getFile();
                if (file == null) {
                    return;
                }
                IPath location = file.getLocation();
                if (location == null) {
                    return;
                }
                String resourcePath = location.toOSString();
                ParserPath parserPath = this.getParserPath();
                IProject project = file.getProject();
                if (BuildConfigManager.isBuildConfigFile((IProject)project, (ParserPath)parserPath)) {
                    return;
                }
                IPSSProject pssProject = PSSModelManager.getInstance().getPSSModel().getPSSProject(project);
                if (pssProject == null) break block19;
                PSSCompiler parser = pssProject.getPSSParser();
                PSSPoolingCancelThread pooling = null;
                PSSCompiler pSSCompiler = parser;
                synchronized (pSSCompiler) {
                    block22: {
                        block20: {
                            block21: {
                                if (!monitor.isCanceled()) break block20;
                                if (pooling == null) break block21;
                                pooling.stopPoolingThread();
                            }
                            monitor.worked(1);
                            return;
                        }
                        try {
                            try {
                                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                                if (BuildConfigManager.isSkip((IProject)project, (ParserPath)parserPath)) break block22;
                                pooling = new PSSPoolingCancelThread();
                                pooling.startPoolingThread(monitor, parser, project, true);
                                RfFileDef fileDef = rfProject.getFile((IResource)file);
                                String libraryName = "work";
                                if (fileDef != null && fileDef.getEnclosingLibrary() != null) {
                                    libraryName = fileDef.getEnclosingLibrary().getName();
                                }
                                IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.PSS;
                                if (fileDef != null) {
                                    languageSyntax = fileDef.getLanguageSyntax();
                                }
                                Set taskNames = PersistentTaskManager.getInstance().getAllTaskNames();
                                boolean hideTaskTags = PersistentTaskManager.getInstance().getHideTaskTags();
                                boolean caseSensitiveTaskTags = PersistentTaskManager.getInstance().getCaseSensitiveTaskTags();
                                DVTCodeCommentsPreferences commentsPreferences = BuildConfigManager.getCommentsPreferences((IProject)project);
                                List customPragmas = BuildConfigManager.getCustomPragmas((IProject)project);
                                int maxIssuesKindNumber = BuildConfigManager.getMaxNofSyntacticProblemsPerFile((IProject)project);
                                parser.addParsingInstanceListener(this);
                                pooling.setFileName(parserPath.path);
                                parser.parseFile(parserPath.path, libraryName, languageSyntax, rfProject, documentContent, true, -1, -1, maxIssuesKindNumber, customPragmas, commentsPreferences, taskNames, caseSensitiveTaskTags, hideTaskTags, null);
                            }
                            catch (Exception exception) {
                                if (pooling != null && pooling.getPoolingStatus() == 1) {
                                    this.fAutobuildStop = true;
                                }
                                if (pooling != null) {
                                    pooling.stopPoolingThread();
                                }
                                monitor.worked(1);
                            }
                        }
                        catch (Throwable throwable) {
                            if (pooling != null) {
                                pooling.stopPoolingThread();
                            }
                            monitor.worked(1);
                            throw throwable;
                        }
                    }
                    if (pooling != null) {
                        pooling.stopPoolingThread();
                    }
                    monitor.worked(1);
                    boolean updatePath = !resourcePath.equals(parserPath.path);
                    this.setErrors(parser.getErrors(parserPath), updatePath, resourcePath);
                    this.setWarnings(parser.getWarnings(parserPath), updatePath, resourcePath);
                    this.setTasks(parser.getTasks(parserPath));
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void cancelReparse() {
        this.fRebuildJob.cancel();
    }

    @Override
    public boolean isAutoBuildStop() {
        return this.fAutobuildStop;
    }

    @Override
    public boolean isEncrypted() {
        return this.fEncrypted;
    }

    @Override
    public void setEncrypted(boolean encrypted) {
        this.fEncrypted = encrypted;
    }

    @Override
    public void notifyInstanceParsing(IDVTFileInstance instance, PSSCompiler parser) {
        PSSModelManager.getInstance().cbInstanceIncrementalBuild(this, instance, parser);
    }

    public void setAST(Object ast) {
    }

    public Object getAST() {
        return null;
    }

    @Override
    public void setErrors(List<PSSProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setErrors(problems);
            return;
        }
        for (PSSProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setErrors(problems);
    }

    @Override
    public void setWarnings(List<PSSProblem> problems, boolean updatePath, String resourceFileName) {
        if (problems == null || problems.isEmpty() || !updatePath) {
            super.setWarnings(problems);
            return;
        }
        for (PSSProblem problem : problems) {
            problem.setFileName(resourceFileName);
        }
        super.setWarnings(problems);
    }

    public void blockingReparse(IProgressMonitor progressMonitor, IDocument document) {
        if (document != null) {
            this.fRebuildJob.setDocument(document);
        }
        this.fRebuildJob.run((IProgressMonitor)(progressMonitor == null ? new NullProgressMonitor() : progressMonitor));
    }

    class RebuildTriggerJob
    extends Job {
        private IDocument fDocument;

        public RebuildTriggerJob() {
            super("Incremental Build: " + PSSModule.this.getFile().getName());
            this.setPriority(20);
            this.setSystem(true);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISchedulingRule rule = workspace.getRuleFactory().buildRule();
            this.setRule(rule);
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_MANUAL_BUILD || family == IDVTConstants.PSS_FAMILY_REPARSE;
        }

        public void setDocument(IDocument document) {
            this.fDocument = document;
        }

        public boolean shouldSchedule() {
            block3: {
                try {
                    IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                    if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return super.shouldSchedule() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || PSSModule.this.fForceBuild) && PSSModule.this.isBuilderEnabled("ro.amiq.dvt.MixedLangBuilder");
        }

        public boolean shouldRun() {
            block3: {
                try {
                    IEclipsePreferences preferences = DVTPlugin.getDefault().getPreferences("org.eclipse.core.resources");
                    if (preferences != null && DVTPlugin.getDefault() != null && DVTPlugin.getDefault().getPreferenceStore() != null) break block3;
                    return false;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return super.shouldRun() && (ResourcesPlugin.getWorkspace().isAutoBuilding() && DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.TRIGGER_AUTOBUILD_ENABLE") || PSSModule.this.fForceBuild) && PSSModule.this.isBuilderEnabled("ro.amiq.dvt.MixedLangBuilder");
        }

        public IStatus run(IProgressMonitor monitor) {
            EnumMap<LanguageKind, Set> changedFiles = new EnumMap<LanguageKind, Set>(LanguageKind.class);
            try {
                block19: {
                    if (!DVTPlugin.getDefault().collect().c(PSSModule.this.getFile().getProject(), "F707373")) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    IFile file = PSSModule.this.getFile();
                    IProject project = file.getProject();
                    monitor.beginTask("Parse: " + PSSModule.this.getFile().getName(), 5);
                    monitor.worked(2);
                    RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
                    try {
                        try {
                            RfMixedLangProject rfMixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
                            IncrementalBuildThreadDumpHandler.INSTANCE.createSession(IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaFilesCallback(rfMixedLangProject, changedFiles), IncrementalInfoCallbackFactory.INSTANCE.createIncrementalDeltaInfoCallback(rfMixedLangProject), project);
                            FileCompileInfo fileCompileInfo = new FileCompileInfo(file);
                            ObjectionManager.getInstance().clear(Objection.BUILD);
                            Utils.setReadOnlyBreadcrumbs();
                            boolean cancelIncremental = PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE");
                            if (cancelIncremental) {
                                ChangedFilesManager.handleCanceledIncremental(new HashSet<FileCompileInfo>(Arrays.asList(fileCompileInfo)), (LanguageKind)LanguageKind.PSS, (IProject)project, (IProgressMonitor)monitor, changedFiles);
                            }
                            PSSModelManager.getInstance().cbIncrementalBuild(monitor, fileCompileInfo, this.fDocument, true);
                            changedFiles.computeIfAbsent(LanguageKind.PSS, x -> new LinkedHashSet()).add(fileCompileInfo);
                            DVTMixedLangModelManager.getInstance().notifyBuildListenersPostIncrementalBuild(project, changedFiles);
                            DVTMixedLangModelManager.getInstance().notifyBuildListenersMixedLangPostIncrementalBuild(project, changedFiles, IncrementalElaborationKind.NONE);
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                            DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                            IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                            if (rfProject != null) {
                                rfProject.cleanIncrementalDeltaContainer();
                            }
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                        IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                        if (rfProject != null) {
                            rfProject.cleanIncrementalDeltaContainer();
                        }
                        throw throwable;
                    }
                    DVTMixedLangModelManager.getInstance().fireBuildDone(IBuildDoneListener.BuildFinishReason.computeBuildFinishReason((int)9, (boolean)monitor.isCanceled()), project.getName());
                    IncrementalBuildThreadDumpHandler.INSTANCE.destroySession();
                    if (rfProject != null) {
                        rfProject.cleanIncrementalDeltaContainer();
                    }
                }
                monitor.worked(3);
                monitor.setTaskName("");
                monitor.done();
                ObjectionManager.getInstance().clear(Objection.BUILD_DONE);
                this.setName("");
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Exception e) {
                this.setName("");
                DVTLogger.INSTANCE.logError((Throwable)e);
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (!monitor.isCanceled()) {
                    RfMixedLangManager.getInstance().clearBacklogElements(PSSModule.this.getFile().getProject());
                }
            }
        }
    }
}

