/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.model.DVTProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.core.PSSPlugin;
import ro.amiq.pssdt.model.IPSSConstants;
import ro.amiq.pssdt.model.IPSSProject;
import ro.amiq.pssdt.parser.PSSCompiler;

public class PSSProject
extends DVTProject
implements IPSSProject,
IPSSConstants {
    private Set<ParserPath> fParserPaths;
    private PSSCompiler fParser = null;
    private final Object fPSSSynch = new Object();

    public PSSProject(IProject project) {
        super(project);
        this.fParserPaths = new LinkedHashSet<ParserPath>();
    }

    @Override
    public void addTopFile(ParserPath moduleName) {
        if (!this.fParserPaths.contains(moduleName)) {
            this.fParserPaths.add(moduleName);
        }
    }

    @Override
    public Collection<ParserPath> getTopFiles() {
        return this.fParserPaths;
    }

    @Override
    public void clean() {
        this.fParserPaths.clear();
        this.fParser = null;
    }

    @Override
    public PSSCompiler getPSSParser() {
        if (this.fParser == null) {
            this.createNewPSSParser();
        }
        this.fParser.resetInterrupt();
        return this.fParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PSSCompiler createNewPSSParser() {
        Object object = this.fPSSSynch;
        synchronized (object) {
            this.fParser = new PSSCompiler();
        }
        return this.fParser;
    }

    @Override
    public IPath getExtensionsPath(String name) {
        IPath stateLocation = PSSPlugin.getDefault().getStateLocation();
        IPath topLocation = stateLocation.addTrailingSeparator().append("__pss__" + this.getProject().getName() + "__" + name);
        return topLocation;
    }

    public boolean isParserInterrupted() {
        if (this.fParser == null) {
            return false;
        }
        return this.fParser.isInterrupted();
    }
}

