/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.core;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.ui.model.IDebugLabelProvider;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.pssdt.model.debug.core.EvalDebugThread;
import ro.amiq.pssdt.model.debug.core.IEvalDebugManager;

public class EvalDebugTarget
extends DebugElement
implements IDebugTarget,
IDebugLabelProvider {
    private boolean isTerminated = false;
    private boolean isSuspended;
    private ILaunch launch;
    private EvalDebugThread thread;
    private String name;
    private Image image;
    private IEvalDebugManager evaluator;

    public EvalDebugTarget(ILaunch launch, String name, Image image, IEvalDebugManager evaluator) {
        super(null);
        this.launch = launch;
        this.name = name;
        this.image = image;
        this.evaluator = evaluator;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public String getModelIdentifier() {
        return "ro.amiq.pssdt.debug";
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        try {
            this.isTerminated = true;
            this.thread.internalTerminate();
            this.fireTerminateEvent();
            this.evaluator.fireTerminateEvent();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public boolean canResume() {
        return !this.isTerminated;
    }

    public boolean canSuspend() {
        return false;
    }

    public boolean isSuspended() {
        return !this.isTerminated && this.isSuspended;
    }

    public void resume() throws DebugException {
        this.thread.internalResume();
        this.isSuspended = false;
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.thread.internalSuspend();
        this.isSuspended = true;
        this.fireSuspendEvent(this.thread.getBreakpoints().length == 0 ? this.thread.getStepKind() : 16);
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    public IProcess getProcess() {
        return null;
    }

    public void setThread(EvalDebugThread thread) {
        this.thread = thread;
    }

    public IThread[] getThreads() throws DebugException {
        IThread[] iThreadArray;
        if (this.isTerminated) {
            iThreadArray = new IThread[]{};
        } else {
            IThread[] iThreadArray2 = new IThread[1];
            iThreadArray = iThreadArray2;
            iThreadArray2[0] = this.thread;
        }
        return iThreadArray;
    }

    public boolean hasThreads() throws DebugException {
        return !this.isTerminated;
    }

    public String getName() {
        return this.name;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return true;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.getName();
    }

    public IWatchExpressionResult getWatchExpressionResult(String expression, IRfScopeElement cursorScope, IStackFrame[] stackFrames) {
        return this.evaluator.getWatchExpressionResult(expression, cursorScope, stackFrames);
    }
}

