/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.core;

import java.util.ArrayDeque;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.debug.ui.model.IDebugLabelProvider;
import ro.amiq.pssdt.model.debug.core.EvalStackFrame;

public class EvalDebugThread
extends DebugElement
implements IThread,
IDebugLabelProvider {
    private ArrayDeque<EvalStackFrame> stackFrames;
    private String name;
    private int stepKind;
    private IBreakpoint breakpoint;
    private boolean isStepping;
    private Image image;
    private boolean isTerminated;

    public EvalDebugThread(IDebugTarget target, String name, Image image) {
        super(target);
        this.name = name;
        this.stepKind = 0;
        this.image = image;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void internalResume() {
        this.isStepping = false;
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public void internalSuspend() {
        this.isStepping = true;
        this.stepKind = 0;
        this.fireSuspendEvent(this.getBreakpoints().length == 0 ? this.stepKind : 16);
    }

    public boolean canStepInto() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean canStepOver() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean canStepReturn() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean isStepping() {
        return !this.isTerminated() && this.isStepping;
    }

    public void stepInto() throws DebugException {
        this.isStepping = true;
        this.stepKind = 1;
        this.resume();
    }

    public void stepOver() throws DebugException {
        this.isStepping = true;
        this.stepKind = 2;
        this.resume();
    }

    public void stepReturn() throws DebugException {
        this.isStepping = true;
        this.stepKind = 4;
        this.resume();
    }

    public int getStepKind() {
        return this.stepKind;
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void internalTerminate() {
        this.isTerminated = true;
        for (EvalStackFrame stackFrame : this.stackFrames) {
            stackFrame.internalTerminate();
        }
        this.stackFrames.clear();
        this.fireTerminateEvent();
    }

    public void setStackFrames(ArrayDeque<EvalStackFrame> stackFrames) {
        this.stackFrames = stackFrames;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.stackFrames.toArray(new IStackFrame[this.stackFrames.size()]);
    }

    public boolean hasStackFrames() throws DebugException {
        return true;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() {
        return this.stackFrames.peek();
    }

    public String getName() {
        if (this.breakpoint == null) {
            return this.name;
        }
        int line = this.breakpoint.getMarker().getAttribute("lineNumber", -1);
        String location = this.breakpoint.getMarker().getResource().getName();
        return String.valueOf(this.name) + " (Suspended at line " + line + " in file '" + location + "')";
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.breakpoint != null) {
            return new IBreakpoint[]{this.breakpoint};
        }
        return new IBreakpoint[0];
    }

    public void setBreakpoint(LineBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.getName();
    }

    public void setStepKind(int stepKind) {
        this.stepKind = stepKind;
    }
}

