/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import ro.amiq.pssdt.model.debug.core.IEvalDebugManager;
import ro.amiq.pssdt.model.debug.core.IRfDebugElement;

public class EvalDebugValue
extends DebugElement
implements IValue {
    private String value;
    private IRfDebugElement rfElement;
    private IEvalDebugManager evaluator;
    private int bucketIndex;

    public EvalDebugValue(IDebugTarget target, String value, IRfDebugElement rfElement, int bucketIndex, IEvalDebugManager evaluator) {
        super(target);
        this.value = value;
        this.rfElement = rfElement;
        this.evaluator = evaluator;
        this.bucketIndex = bucketIndex;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.bucketIndex >= 0 ? null : this.evaluator.getValueTypeName(this.rfElement);
    }

    public String getValueString() throws DebugException {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isAllocated() throws DebugException {
        return false;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.evaluator.getVariables(this.rfElement, this.bucketIndex);
    }

    public boolean hasVariables() throws DebugException {
        return this.evaluator.hasVariables(this.rfElement);
    }
}

