/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.ui.model.IDebugLabelProvider;
import ro.amiq.pssdt.model.debug.core.EvalDebugValue;
import ro.amiq.pssdt.model.debug.core.IEvalDebugManager;
import ro.amiq.pssdt.model.debug.core.IRfDebugElement;

public class EvalDebugVariable
extends DebugElement
implements IVariable,
IDebugLabelProvider {
    private String name;
    private String typeName;
    private IValue value;
    private IRfDebugElement rfElement;
    private boolean isValueChanged;
    private IEvalDebugManager evaluator;

    public EvalDebugVariable(IDebugTarget target, String name, String typeName, IRfDebugElement rfElement, IEvalDebugManager evaluator) {
        super(target);
        this.name = name;
        this.typeName = typeName;
        this.rfElement = rfElement;
        this.evaluator = evaluator;
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public void setValue(String expression) throws DebugException {
        try {
            this.evaluator.setVariableValue(this.rfElement, expression);
            this.value = new EvalDebugValue(this.getDebugTarget(), expression, this.rfElement, -1, this.evaluator);
            this.fireChangeEvent(32);
        }
        catch (Exception exception) {
            throw new DebugException((IStatus)new Status(4, "ro.amiq.dvt", "Fail to change variable value"));
        }
    }

    public void setValue(IValue value) throws DebugException {
        this.value = value;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.typeName;
    }

    public boolean hasValueChanged() throws DebugException {
        return this.isValueChanged;
    }

    public Image getImage() {
        return this.rfElement.getImage();
    }

    public String getText() {
        return this.getName();
    }

    public void setValueChanged(boolean isValueChanged) {
        this.isValueChanged = isValueChanged;
    }
}

