/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.core;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.debug.ui.model.IDebugLabelProvider;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.pssdt.model.debug.core.IEvalDebugManager;
import ro.amiq.pssdt.model.debug.core.IRfDebugElement;
import ro.amiq.pssdt.model.reflection.elaboration.util.Stack;

public class EvalStackFrame
extends DebugElement
implements IStackFrame,
IDebugLabelProvider {
    private IThread thread;
    private int stackIndex;
    private IRfDebugElement rfElement;
    private IEvalDebugManager evaluator;
    private Stack<IRfDebugElement> currentScopeStack;
    private boolean isTerminated;
    private int lineNumber;
    private ParserPath parserPath;

    public EvalStackFrame(IDebugTarget target, IThread thread, int stackIndex, int lineNumber, ParserPath parserPath, IRfDebugElement rfElement, IEvalDebugManager evaluator) {
        super(target);
        this.thread = thread;
        this.stackIndex = stackIndex;
        this.lineNumber = lineNumber;
        this.rfElement = rfElement;
        this.evaluator = evaluator;
        this.parserPath = parserPath;
        this.currentScopeStack = new Stack();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public boolean canResume() {
        return this.getDebugTarget().canResume();
    }

    public boolean canSuspend() {
        return this.getDebugTarget().canSuspend();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean canStepOver() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean canStepReturn() {
        return !this.getDebugTarget().isTerminated();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.thread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.thread.stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated;
    }

    public boolean isTerminated() {
        return this.isTerminated;
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public void internalTerminate() {
        this.isTerminated = true;
        this.fireTerminateEvent();
    }

    public String getName() {
        return this.rfElement.getName();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.evaluator.getVariables(this.getCurrentScope(), -1);
    }

    public boolean hasVariables() throws DebugException {
        return this.evaluator.hasVariables(this.getCurrentScope());
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() throws DebugException {
        return this.lineNumber;
    }

    public void setParserPath(ParserPath parserPath) {
        this.parserPath = parserPath;
    }

    public ParserPath getParserPath() {
        return this.parserPath;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public Image getImage() {
        return this.rfElement.getImage();
    }

    public String getText() {
        return this.evaluator.getText(this.rfElement);
    }

    public IRfDebugElement getRfElement() {
        return this.rfElement;
    }

    public void setRfElement(IRfDebugElement rfElement) {
        this.rfElement = rfElement;
    }

    public int getStackIndex() {
        return this.stackIndex;
    }

    public void pushInstanceScope(IRfDebugElement currentScope) {
        this.currentScopeStack.push(currentScope);
    }

    public void popInstanceScope() {
        if (this.currentScopeStack.isEmpty()) {
            return;
        }
        this.currentScopeStack.pop();
    }

    public IRfDebugElement getCurrentScope() {
        if (this.currentScopeStack.isEmpty()) {
            return this.rfElement;
        }
        return this.currentScopeStack.peek();
    }
}

