/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.ui.breakpoints;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import ro.amiq.dvt.debug.ui.breakpoints.ToggleLineBreakpointAdapter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfExecBlock;
import ro.amiq.pssdt.model.reflection.RfFileDef;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMethod;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfProject;

public class EvalToggleLineBreakpointAdapter
extends ToggleLineBreakpointAdapter {
    public static final Set<Class<? extends RfNamedElement>> PROCEDURAL_SCOPE_CONTAINERS = new HashSet<Class<? extends RfNamedElement>>();

    static {
        PROCEDURAL_SCOPE_CONTAINERS.add(RfMethod.class);
        PROCEDURAL_SCOPE_CONTAINERS.add(RfExecBlock.class);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        try {
            DVTEditor textEditor = this.getEditor(part);
            if (textEditor != null) {
                RfNamedElement namedElement;
                IResource resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                IProject project = resource.getProject();
                RfProject rfProject = RfManager.getInstance().getRfProject(project);
                if (rfProject == null) {
                    Utils.popMessage((int)1, (String)"Toggle Breakpoint Error", (String)"DVT was unable to determine the project in which the current file is located.");
                    return;
                }
                RfFileDef defFile = rfProject.getFile(resource);
                if (defFile == null) {
                    Utils.popMessage((int)1, (String)"Toggle Breakpoint Error", (String)"DVT was unable to determine the scope of the breakpoint.");
                    return;
                }
                RfDefElement proceduralScope = defFile.getScope(offset, PROCEDURAL_SCOPE_CONTAINERS);
                RfNamedElement rfNamedElement = namedElement = proceduralScope == null ? null : proceduralScope.getNamedElement();
                if (namedElement == null || !PROCEDURAL_SCOPE_CONTAINERS.contains(namedElement.getClass()) || namedElement instanceof RfExecBlock && ((RfExecBlock)namedElement).isActivity()) {
                    Utils.popMessage((int)1, (String)"Toggle Breakpoint Error", (String)"Breakpoint is allowed in procedural code only (function body or exec block body)");
                    return;
                }
                super.toggleBreakpoints(part, selection);
            }
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return super.canToggleBreakpoints(part, selection);
    }
}

