/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.debug.ui.editor.hover;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.debug.ui.editor.hover.ITextHoverParticipant;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.DVTTooltipContent;
import ro.amiq.pssdt.model.debug.core.EvalDebugTarget;
import ro.amiq.pssdt.model.debug.core.EvalDebugValue;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.pssdt.ui.editor.PSSWordFinder;

public class PSSDebugTextHoverParticipant
implements ITextHoverParticipant {
    private ITextEditor textEditor;

    public void makeInfo(ITextViewer textViewer, IRegion region, DVTTooltipContent tooltipContent) {
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        StringBuilder info = new StringBuilder();
        int i = 0;
        while (i < launches.length) {
            String subInfo;
            IDebugTarget target;
            if (launches[i] != null && (target = launches[i].getDebugTarget()) instanceof EvalDebugTarget && (subInfo = this.getInfo(textViewer, region, (EvalDebugTarget)target)) != null) {
                if (launches.length > 1) {
                    String targetName;
                    try {
                        targetName = target.getName();
                    }
                    catch (DebugException debugException) {
                        targetName = String.valueOf(i);
                    }
                    info.append("<br>[").append(targetName).append("]: ").append(subInfo).append("</br>");
                } else {
                    info.append("<br>").append(subInfo).append("</br>");
                }
            }
            ++i;
        }
        tooltipContent.set(DVTTooltipContent.TooltipContent.DEBUG_INFO, info.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getInfo(ITextViewer textViewer, IRegion region, EvalDebugTarget debugTarget) {
        try {
            IDocument document = textViewer.getDocument();
            String result = "";
            if (document == null) {
                return null;
            }
            int offset = region.getOffset();
            IRfScopeElement cursorScope = null;
            if (this.textEditor instanceof DVTEditor) {
                IFile file = (IFile)this.textEditor.getAdapter(IResource.class);
                if (file == null) {
                    return null;
                }
                IProject project = file.getProject();
                if (project == null) {
                    return null;
                }
                RfWNamedElementAndScope elementScope = RfUtils.getRfElement(file, document, offset);
                if (elementScope != null) {
                    if (elementScope.getIRfNamedElement() instanceof IRfMethodElement) {
                        return null;
                    }
                    cursorScope = elementScope.getScope();
                }
            }
            if (region.getLength() == 0 && (region = PSSWordFinder.getDefault().getExpressionAtOffset(document, offset)) == null) {
                return null;
            }
            result = document.get(region.getOffset(), region.getLength());
            if (result == null) {
                return null;
            }
            result = result.trim();
            IThread[] threads = debugTarget.getThreads();
            if (threads != null && threads.length > 0 && threads[0].getTopStackFrame() != null) {
                IStackFrame[] stackFrames = threads[0].getStackFrames();
                IWatchExpressionResult request = debugTarget.getWatchExpressionResult(result, cursorScope, stackFrames);
                if (request == null || request.hasErrors()) {
                    return null;
                }
                result = String.valueOf(result) + " = " + ((EvalDebugValue)request.getValue()).getValueString();
            }
            return "<b>" + result + "</b>";
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void setTextEditor(ITextEditor textEditor) {
        this.textEditor = textEditor;
    }
}

