/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import antlr.collections.AST;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.csp.variables.IntDomain;
import ro.amiq.dvt.model.reflection.semantic.extension.IDataType;
import ro.amiq.pssdt.model.reflection.Endianness;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.StructKind;
import ro.amiq.pssdt.parser.utils.BitVectorArray;
import ro.amiq.pssdt.parser.utils.BitVectorInt;
import ro.amiq.pssdt.parser.utils.BitVectorMap;
import ro.amiq.pssdt.parser.utils.BitVectorRef;
import ro.amiq.pssdt.parser.utils.BitVectorStr;

public class DataType
implements IDataType {
    public static final int NONE = 0;
    public static final int INPUT = 1;
    public static final int INOUT = 2;
    public static final int OUTPUT = 3;
    private String typeName;
    private String arrayDim;
    private int arrayDimInt;
    private RfEnumType arrayDimEnumType;
    private int direction;
    private String initialValueText;
    private BitVectorInt initialValue;
    private int left;
    private int right;
    private boolean sign;
    private List<Range> ranges;
    private CollectionKind containerKind;
    private DataType keyDataType;
    private DataType valueDataType;
    private StructKind structKind;
    private AST initialValueAST;
    private boolean isRef;
    public static final DataType BOOL = new UnmodifiableDataType("bool", 0, 0, false);
    public static final DataType INT = new UnmodifiableDataType("int", 31, 0, true);
    public static final DataType STRING = new UnmodifiableDataType("string");
    public static final DataType VOID = new UnmodifiableDataType("void");
    public static final DataType FLOAT32 = new UnmodifiableDataType("float32", 31, 0, false);
    public static final DataType FLOAT64 = new UnmodifiableDataType("float64", 63, 0, false);

    public final IntDomain toIntDomain(IntDomain fullDomain) {
        BigInteger lowerBound = fullDomain.getLowerBound();
        BigInteger upperBound = fullDomain.getUpperBound();
        if (this.ranges == null || this.ranges.isEmpty()) {
            return new IntDomain(lowerBound, upperBound);
        }
        IntDomain domain = new IntDomain();
        for (Range range : this.ranges) {
            BigInteger ub;
            if (range == null || range.getLeft() == null && range.getRight() == null) continue;
            BigInteger lb = range.getLeft() == null ? lowerBound : range.getLeft().bigIntegerValue();
            BigInteger bigInteger = ub = range.getRight() == null ? upperBound : range.getRight().bigIntegerValue();
            if (ub.compareTo(lb) < 0) continue;
            domain = domain.remove(lb, ub);
            domain.addSubdomain(lb, ub);
            domain.subDomainsSort();
            domain.updateBounds();
        }
        domain = domain.intersect(lowerBound, upperBound);
        domain.subDomainsSort();
        return domain;
    }

    public DataType(StructKind structKind) {
        this(structKind.toString());
        this.structKind = structKind;
    }

    public DataType(String typeName) {
        this.typeName = typeName;
        this.left = -1;
        this.right = -1;
    }

    public BitVectorInt getInitialValue(int index) {
        if (index < 0 || this.initialValue == null) {
            return this.initialValue;
        }
        if (index >= this.initialValue.nofBits()) {
            return null;
        }
        return ((BitVectorArray)this.initialValue).get(index);
    }

    public StructKind getStructKind() {
        return this.structKind;
    }

    public boolean isGenericType() {
        return this.structKind != null;
    }

    public BitVectorInt getInitialValue() {
        return this.initialValue;
    }

    public void clear() {
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public RfEnumType getArrayDimEnumType() {
        return this.arrayDimEnumType;
    }

    public void setArrayDim(String arrayDim, AST arrayDimAST, BitVectorInt initialValue, boolean isDynamicArray) {
        this.arrayDim = arrayDim;
        if (initialValue instanceof BitVectorRef && ((BitVectorRef)initialValue).get() instanceof RfEnumType) {
            this.arrayDimEnumType = (RfEnumType)((BitVectorRef)initialValue).get();
        }
        this.arrayDimInt = initialValue == null || initialValue instanceof BitVectorRef ? -1 : initialValue.intValue();
    }

    public String getArrayDim() {
        if (this.arrayDimEnumType != null) {
            return Integer.toString(this.arrayDimEnumType.getItemsCount());
        }
        return this.arrayDim;
    }

    public int getArrayDimAsInteger() {
        if (this.arrayDimEnumType != null) {
            return this.arrayDimEnumType.getItemsCount();
        }
        return this.arrayDimInt;
    }

    public DataType setInitialValue(DataType dataType) {
        if (dataType == null) {
            return this;
        }
        this.initialValueText = dataType.initialValueText;
        this.initialValue = dataType.initialValue;
        this.initialValueAST = dataType.initialValueAST;
        return this;
    }

    public DataType setInitialValue(String initialValueText, AST initialValueAST, BitVectorInt initialValue) {
        this.initialValueText = initialValueText;
        this.initialValueAST = initialValueAST;
        if (this.left == -1 && initialValue != null && initialValue.getClass() == BitVectorInt.class) {
            this.left = initialValue.nofBits();
            this.right = -1;
        }
        if (initialValue instanceof BitVectorArray) {
            this.initialValue = initialValue;
            if (this.containerKind == CollectionKind.LIST || this.containerKind == CollectionKind.SET) {
                this.arrayDimInt = ((BitVectorArray)initialValue).size();
                this.arrayDim = Integer.toString(((BitVectorArray)initialValue).size());
            }
        } else if (initialValue instanceof BitVectorMap) {
            this.initialValue = initialValue;
            if (this.containerKind == CollectionKind.MAP) {
                this.arrayDimInt = ((BitVectorMap)initialValue).size();
                this.arrayDim = Integer.toString(((BitVectorMap)initialValue).size());
            }
        } else if (initialValue instanceof BitVectorStr) {
            this.initialValue = initialValue;
        } else if (initialValue != null) {
            this.initialValue = new BitVectorInt(!"bit".equals(this.typeName), this.left(), this.right());
            this.initialValue.setValue(BigInteger.ZERO);
            this.initialValue = this.initialValue.from(initialValue);
            if (initialValue.getEnumItemName() != null) {
                this.initialValue.setEnumItemName(initialValue.getEnumItemName());
                this.initialValueText = initialValue.getEnumItemName();
            }
        } else {
            this.initialValue = null;
        }
        return this;
    }

    public AST getInitialValueAST() {
        return this.initialValueAST;
    }

    public void setFromDataType(DataType dataType) {
        if (dataType == null) {
            return;
        }
        this.arrayDim = dataType.arrayDim;
        this.arrayDimInt = dataType.arrayDimInt;
        this.arrayDimEnumType = dataType.arrayDimEnumType;
        this.initialValueText = dataType.initialValueText;
        this.initialValueAST = dataType.initialValueAST;
        this.initialValue = dataType.initialValue;
        this.direction = dataType.direction;
        this.left = dataType.left;
        this.right = dataType.right;
        this.sign = dataType.sign;
        this.isRef = dataType.isRef;
        this.containerKind = dataType.containerKind;
        this.keyDataType = dataType.keyDataType;
        this.valueDataType = dataType.valueDataType;
    }

    public void setValueParamDataType(DataType dataType) {
        if (dataType == null) {
            return;
        }
        this.typeName = dataType.typeName;
        this.arrayDim = dataType.arrayDim;
        this.arrayDimInt = dataType.arrayDimInt;
        this.arrayDimEnumType = dataType.arrayDimEnumType;
        this.direction = dataType.direction;
        this.left = dataType.left;
        this.right = dataType.right;
        this.sign = dataType.sign;
        this.isRef = dataType.isRef;
        this.containerKind = dataType.containerKind;
        this.keyDataType = dataType.keyDataType;
        this.valueDataType = dataType.valueDataType;
    }

    public DataType set(int left, int right, boolean sign) {
        this.left = left;
        this.right = right;
        this.sign = sign;
        return this;
    }

    public boolean hasSign() {
        return this.sign;
    }

    public int left() {
        return this.right == -1 && this.left >= 0 ? this.left - 1 : this.left;
    }

    public int right() {
        return this.right == -1 && this.left >= 0 ? 0 : this.right;
    }

    public void addInString(String inString) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.ranges.add(new Range(inString));
    }

    public void addInRange(BitVectorInt rLeft, BitVectorInt rRight) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<Range>();
        }
        this.ranges.add(new Range(rLeft, rRight));
    }

    public List<Range> getInRanges() {
        return this.ranges;
    }

    public String[] getInStrings() {
        if (this.ranges == null) {
            return null;
        }
        String[] result = new String[this.ranges.size()];
        int i = 0;
        while (i < this.ranges.size()) {
            result[i] = this.ranges.get(i).getInString();
            ++i;
        }
        return result;
    }

    public int nofBits() {
        if (this.right < 0) {
            return this.left;
        }
        if (this.left < this.right) {
            return this.right - this.left + 1;
        }
        return this.left - this.right + 1;
    }

    public Endianness endianness() {
        return this.left < this.right ? Endianness.BIG : Endianness.LITTLE;
    }

    public void setContainerKind(CollectionKind containerKind) {
        this.containerKind = containerKind;
    }

    public void setItemDataType(DataType keyDataType, DataType valueDataType, CollectionKind containerKind) {
        this.keyDataType = keyDataType;
        this.valueDataType = valueDataType;
        this.containerKind = containerKind;
    }

    public DataType getKeyDataType() {
        return this.keyDataType;
    }

    public DataType getValueDataType() {
        return this.valueDataType;
    }

    public CollectionKind getContainerKind() {
        return this.containerKind;
    }

    public String getInitialValueText() {
        return this.initialValueText;
    }

    public int getDirection() {
        return this.direction == 0 ? 1 : this.direction;
    }

    public int getRawDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.arrayDimEnumType == null ? 0 : this.arrayDimEnumType.hashCode());
        result = 31 * result + this.arrayDimInt;
        result = 31 * result + (this.containerKind == null ? 0 : this.containerKind.hashCode());
        result = 31 * result + (this.keyDataType == null ? 0 : this.keyDataType.hashCode());
        result = 31 * result + this.left;
        result = 31 * result + this.right;
        result = 31 * result + (this.sign ? 1231 : 1237);
        result = 31 * result + (this.isRef ? 1231 : 1237);
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.valueDataType == null ? 0 : this.valueDataType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataType other = (DataType)obj;
        if (this.arrayDimInt != other.arrayDimInt) {
            return false;
        }
        if (this.containerKind != other.containerKind) {
            return false;
        }
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        if (this.sign != other.sign) {
            return false;
        }
        if (this.isRef != other.isRef) {
            return false;
        }
        if (this.typeName == null ? other.typeName != null : !this.typeName.equals(other.typeName)) {
            return false;
        }
        if (this.arrayDimEnumType == null ? other.arrayDimEnumType != null : !this.arrayDimEnumType.equals(other.arrayDimEnumType)) {
            return false;
        }
        if (this.keyDataType == null ? other.keyDataType != null : !this.keyDataType.equals(other.keyDataType)) {
            return false;
        }
        return !(this.valueDataType == null ? other.valueDataType != null : !this.valueDataType.equals(other.valueDataType));
    }

    public void setRef(boolean isRef) {
        this.isRef = isRef;
    }

    public boolean isRef() {
        return this.isRef;
    }

    public static enum CollectionKind {
        ARRAY,
        ARRAY_INIT,
        LIST,
        MAP,
        MAP_INIT,
        SET,
        SET_INIT;

    }

    public static class Range {
        private BitVectorInt rLeft;
        private BitVectorInt rRight;
        private String inString;

        public Range(BitVectorInt rLeft, BitVectorInt rRight) {
            this.rLeft = rLeft;
            this.rRight = rRight;
        }

        public Range(String inString) {
            this.inString = inString;
        }

        public BitVectorInt getLeft() {
            return this.rLeft;
        }

        public BitVectorInt getRight() {
            return this.rRight;
        }

        public String getInString() {
            return this.inString;
        }
    }

    public static class UnmodifiableDataType
    extends DataType {
        public UnmodifiableDataType(String typeName) {
            super(typeName);
        }

        public UnmodifiableDataType(String typeName, int left, int right, boolean sign) {
            super(typeName);
            super.set(left, right, sign);
        }

        @Override
        public DataType set(int left, int right, boolean sign) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setArrayDim(String arrayDim, AST arrayDimAST, BitVectorInt initialValue, boolean isDynamicArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setContainerKind(CollectionKind containerKind) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setDirection(int direction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setFromDataType(DataType dataType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataType setInitialValue(DataType dataType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DataType setInitialValue(String initialValueText, AST initialValueAST, BitVectorInt initialValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setItemDataType(DataType keyDataType, DataType valueDataType, CollectionKind containerKind) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setTypeName(String typeName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setRef(boolean isRef) {
            throw new UnsupportedOperationException();
        }
    }
}

