/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.buildconfig.BCFileInstance;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.indexer.IdentifierIndexerManager;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.reflection.IReflectionContributor;
import ro.amiq.dvt.model.reflection.IRfKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.IMembersLabelProvider;
import ro.amiq.dvt.ui.views.MembersViewInput;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.pssdt.model.IPSSModule;
import ro.amiq.pssdt.model.PSSModelManager;
import ro.amiq.pssdt.model.indexer.IdentifierIndexer;
import ro.amiq.pssdt.model.persistence.Persistence;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfEnumType;
import ro.amiq.pssdt.model.reflection.RfField;
import ro.amiq.pssdt.model.reflection.RfKind;
import ro.amiq.pssdt.model.reflection.RfManager;
import ro.amiq.pssdt.model.reflection.RfMembersContainer;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPackage;
import ro.amiq.pssdt.model.reflection.RfPredefinedEnumType;
import ro.amiq.pssdt.model.reflection.RfProject;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.util.RfUtils;
import ro.amiq.pssdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.pssdt.model.reflection.views.TypesViewMembersLabelProvider;
import ro.amiq.pssdt.ui.editor.PSSSourceViewerConfiguration;
import ro.amiq.pssdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class PSSReflectionContributor
implements IReflectionContributor {
    public boolean hasHits(IFile file, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(IdentifierIndexer.class, file, names, matcher, isRegexp);
    }

    public boolean hasHits(ParserPath file, IProject project, String[] names, Matcher matcher, boolean isRegexp) {
        return IdentifierIndexerManager.getInstance().hasHits(IdentifierIndexer.class, file, project, names, matcher, isRegexp);
    }

    public boolean isEnabled(IProject project) {
        try {
            return project.hasNature("ro.amiq.pssdt.pssnature");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getNature() {
        return "ro.amiq.pssdt.pssnature";
    }

    public IRfNamedElementAndScope getRfElement(IFile file, IDocument document, int offset, boolean validateContentType) {
        boolean validContentType;
        if (validateContentType && !(validContentType = RfSearchUtils.validContentType((IProject)file.getProject(), (IDocument)document, (int)offset))) {
            return null;
        }
        return RfUtils.getRfElement(file, document, offset);
    }

    public IRfSingleLangProject makeRfProject(IProject project, RfMixedLangProject rfMixedLangProject) {
        return new RfProject(project, rfMixedLangProject);
    }

    public PersistenceBase makePersistence(IProject project) {
        return new Persistence(project);
    }

    public DVTSourceViewerConfiguration getSourceViewerConfiguration() {
        return new PSSSourceViewerConfiguration(null);
    }

    public boolean gotoSelectedMember(IProject project, IDVTElementWrapper element) {
        if (element == null) {
            return false;
        }
        Object elem = element.getRfElement();
        if (!(elem instanceof RfNamedElement)) {
            return false;
        }
        RfUtils.createOpenAction((IRfNamedElement)elem, project, null, null).open();
        return true;
    }

    public boolean gotoElement(IProject project, Object wrapper) {
        RfNamedElementActionHyperlink actionHyperlink;
        block7: {
            Object object;
            block6: {
                block5: {
                    try {
                        if (wrapper instanceof RfTreeElementWrapper) break block5;
                        return false;
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return false;
                    }
                }
                object = ((RfTreeElementWrapper)((Object)wrapper)).getRfElement();
                if (object != null && object instanceof RfNamedElement) break block6;
                return false;
            }
            actionHyperlink = RfUtils.createOpenAction((RfNamedElement)object, project, (IRegion)new Region(0, 1), null);
            if (actionHyperlink != null) break block7;
            return false;
        }
        actionHyperlink.open();
        return true;
    }

    public MembersViewInput getMembersInput(IDVTElementWrapper wrapper, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        boolean hasGUIFilteredMembers = false;
        MembersViewInput emptyResult = new MembersViewInput(Collections.emptyList(), false);
        if (wrapper == null) {
            return emptyResult;
        }
        Object rfElement = wrapper.getRfElement();
        if (!(rfElement instanceof RfNamedElement)) {
            return emptyResult;
        }
        RfNamedElement namedElemet = (RfNamedElement)rfElement;
        ArrayList<IDVTElementWrapper> elements = new ArrayList<IDVTElementWrapper>();
        if (namedElemet instanceof IRfAssociatedType && ((IRfAssociatedType)((Object)namedElemet)).getAssociatedType() != null) {
            namedElemet = (RfNamedElement)((IRfAssociatedType)((Object)namedElemet)).getAssociatedType();
        }
        if (namedElemet instanceof RfMembersContainer) {
            Collection<RfNamedElement> members = namedElemet.getLocalMembers();
            hasGUIFilteredMembers = this.collectMatchingMembers(elements, members, stringMatcher, defaultLabelProvider, applyContentFilters) || hasGUIFilteredMembers;
        }
        return new MembersViewInput(elements, hasGUIFilteredMembers);
    }

    private boolean collectMatchingMembers(Collection<IDVTElementWrapper> result, Iterable<? extends RfNamedElement> members, StringMatcher stringMatcher, IMembersLabelProvider defaultLabelProvider, boolean applyContentFilters) {
        boolean hasGUIFilteredMembers = false;
        if (members == null) {
            return hasGUIFilteredMembers;
        }
        for (RfNamedElement rfNamedElement : members) {
            boolean access;
            RfTreeElementWrapper elementWrapper;
            if (rfNamedElement.isAnonymous() || rfNamedElement.isPredefined() && rfNamedElement.getLocalMembers() == null || rfNamedElement instanceof RfPredefinedEnumType && !((RfPredefinedEnumType)rfNamedElement).hasNonPredefinedMembers() || rfNamedElement instanceof RfStruct || rfNamedElement instanceof RfPackage || rfNamedElement instanceof RfEnumType || !ViewsUtils.matchCamelCaseOrRegex((StringMatcher)stringMatcher, (String)defaultLabelProvider.getText((Object)(elementWrapper = new RfTreeElementWrapper(rfNamedElement, access = rfNamedElement instanceof RfField))))) continue;
            if (applyContentFilters && DVTNamedElementGUIFilterMatcher.filterElement((ViewSet.ViewName)ViewSet.ViewName.TYPES_MEMBERS, (IRfNamedElement)rfNamedElement, () -> defaultLabelProvider.getText((Object)elementWrapper)) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED) {
                hasGUIFilteredMembers = true;
                continue;
            }
            result.add(elementWrapper);
        }
        return hasGUIFilteredMembers;
    }

    public IRfKind getKind(IRfNamedElement e) {
        return RfKind.of(e);
    }

    public IMembersLabelProvider getMembersLabelProvider() {
        return new TypesViewMembersLabelProvider();
    }

    public void clearBacklogElements(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            rfProject.getChangedFilesManager().clear();
        }
    }

    public void addBacklogElement(IProject project, FileCompileInfo info) {
        RfProject rfProjectWithoutRestore = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProjectWithoutRestore == null) {
            return;
        }
        IPSSModule module = PSSModelManager.getInstance().getPSSModel().getPSSFile(info.getFile());
        if (module != null) {
            rfProjectWithoutRestore.getChangedFilesManager().addBacklogElements(new LinkedHashSet<FileCompileInfo>(Collections.singleton(info)));
        }
    }

    public Set<FileCompileInfo> getChangedElements(IProject project) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            return rfProject.getChangedFilesManager().getBacklogElements();
        }
        return null;
    }

    public void cbIncrementalBuild(IProgressMonitor monitor, FileCompileInfo changedElement, IDocument document, IProject project) {
        PSSModelManager.getInstance().cbIncrementalBuild(monitor, changedElement, document, true);
    }

    public void restoreInvocationsInfo(IProject project, Map<String, BCFileInstance> buildConfigFiles) {
        RfProject rfProject = RfManager.getInstance().getRfProjectWithoutRestore(project);
        if (rfProject != null) {
            rfProject.restoreInvocationsInfo(rfProject.getRfProjectContent(), rfProject.getRfCompiledFiles(), buildConfigFiles);
        }
    }
}

