/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.pssdt.model.reflection;

import ro.amiq.pssdt.model.reflection.DataType;
import ro.amiq.pssdt.model.reflection.IRfAssociatedType;
import ro.amiq.pssdt.model.reflection.RfCollectionType;
import ro.amiq.pssdt.model.reflection.RfDefElement;
import ro.amiq.pssdt.model.reflection.RfDummyElement;
import ro.amiq.pssdt.model.reflection.RfNamedElement;
import ro.amiq.pssdt.model.reflection.RfPredefinedField;
import ro.amiq.pssdt.model.reflection.RfStruct;
import ro.amiq.pssdt.model.reflection.RfTemplateInstance;
import ro.amiq.pssdt.model.reflection.RfTemplateParam;
import ro.amiq.pssdt.model.reflection.semantic.SemanticUtils;
import ro.amiq.pssdt.parser.utils.BitVectorInt;

public abstract class RfAssociatedType
extends RfNamedElement
implements IRfAssociatedType {
    private DataType associatedDataType;
    private RfNamedElement associatedType;

    public RfAssociatedType(String name, DataType dataType) {
        super(name);
        this.associatedDataType = dataType;
    }

    public void setDataType(DataType dataType) {
        this.associatedDataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.associatedDataType;
    }

    public BitVectorInt getInitialValue(int index) {
        if (this.associatedDataType == null) {
            return null;
        }
        return this.associatedDataType.getInitialValue(index);
    }

    @Override
    public boolean getAssociatedTypeArray() {
        if (this.associatedDataType == null) {
            return false;
        }
        return this.associatedDataType.getArrayDim() != null;
    }

    @Override
    public String getAssociatedTypeArrayDim() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return "";
        }
        return this.associatedDataType.getArrayDim();
    }

    public String getAssociatedTypeName() {
        if (this.associatedType instanceof RfTemplateInstance) {
            return this.associatedType.getName();
        }
        if (this.associatedDataType == null || this instanceof RfPredefinedField && "comp".equals(this.getName())) {
            return this.associatedType == null ? "" : this.associatedType.getName();
        }
        return this.associatedDataType.getTypeName();
    }

    public RfNamedElement getAssociatedBaseType() {
        if (this.associatedType instanceof RfCollectionType) {
            return ((RfCollectionType)this.associatedType).getAssociatedBaseType();
        }
        return this.associatedType;
    }

    public RfNamedElement getAssociatedType() {
        return this.associatedType;
    }

    public void setAssociatedType(RfNamedElement namedElement) {
        if (namedElement instanceof RfTemplateParam.RfInstanceTypeParam) {
            this.associatedDataType = ((RfTemplateParam.RfInstanceTypeParam)namedElement).getDataType();
            this.associatedType = ((RfTemplateParam.RfInstanceTypeParam)namedElement).getAssociatedType();
        } else {
            this.associatedType = namedElement;
        }
    }

    @Override
    public void deepClean() {
        super.deepClean();
        if (this.associatedDataType != null) {
            this.associatedDataType.clear();
        }
        this.associatedDataType = null;
        this.associatedType = null;
    }

    @Override
    public void removeLayer(RfDefElement layer) {
        super.removeLayer(layer);
        this.associatedDataType = null;
    }

    public String getRange() {
        return null;
    }

    public int getAssociatedTypeArrayDimAsInteger() {
        if (this.associatedDataType == null || this.associatedDataType.getArrayDim() == null) {
            return -1;
        }
        return this.associatedDataType.getArrayDimAsInteger();
    }

    public boolean isFixedSizeArray() {
        if (this.associatedDataType == null) {
            return false;
        }
        if (this.associatedDataType.getContainerKind() == DataType.CollectionKind.ARRAY) {
            return this.associatedDataType.getArrayDim() != null;
        }
        if (this.associatedDataType.getContainerKind() == DataType.CollectionKind.LIST) {
            return this.isRand();
        }
        return false;
    }

    @Override
    public boolean isStructType() {
        RfNamedElement unwrapType = SemanticUtils.unwrap(this.associatedType, true, true);
        return unwrapType instanceof RfStruct || unwrapType instanceof RfCollectionType && ((RfCollectionType)unwrapType).isStructType();
    }

    @Override
    public boolean isComponentType() {
        RfNamedElement unwrapType = SemanticUtils.unwrap(this.associatedType, true, true);
        return unwrapType instanceof RfStruct || unwrapType instanceof RfCollectionType && ((RfCollectionType)unwrapType).isComponentType();
    }

    @Override
    public boolean isContainerType() {
        RfNamedElement unwrapType = SemanticUtils.unwrap(this.associatedType, true, true);
        return this.associatedDataType != null && this.associatedDataType.getContainerKind() != null || unwrapType instanceof RfCollectionType;
    }

    public static class RfLazyCollectionType
    extends RfDummyElement {
        private RfNamedElement baseType;

        public RfLazyCollectionType(RfNamedElement baseType) {
            super("[lazy collection type]");
            this.baseType = baseType;
        }

        public RfNamedElement getBaseType() {
            return this.baseType;
        }
    }
}

